/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import forestry.Forestry;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.config.ForestryConfig;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ButterflySpawner
implements ILeafTickHandler {
    static boolean attemptButterflySpawn(Level world, IButterfly butterfly, BlockPos pos) {
        Mob entityLiving = ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).spawnButterflyInWorld(world, butterfly.copy(), pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
        Forestry.LOGGER.trace("Spawned a butterfly '{}' at {}/{}/{}.", (Object)butterfly.getDisplayName(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        return entityLiving != null;
    }

    @Override
    public boolean onRandomLeafTick(ITree tree, Level world, RandomSource rand, BlockPos pos, boolean isDestroyed) {
        if (!world.m_46469_().m_46207_(GameRules.f_46134_) || ((Boolean)ForestryConfig.SERVER.disableButterflySpawning.get()).booleanValue()) {
            return false;
        }
        if (rand.m_188501_() >= tree.getGenome().getActiveValue(TreeChromosomes.SAPPINESS) * tree.getGenome().getActiveValue(TreeChromosomes.YIELD)) {
            return false;
        }
        IButterfly spawn = (IButterfly)((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).createRandomIndividual(rand);
        IButterflySpecies activeSpecies = spawn.getSpecies();
        float rarity = ModuleLepidopterology.spawnRarities.getOrDefault((Object)activeSpecies.id().m_135815_(), activeSpecies.getRarity());
        if (rand.m_188501_() >= rarity * 0.5f) {
            return false;
        }
        if (EntityButterfly.isMaxButterflyCluster(Vec3.m_82512_((Vec3i)pos), world)) {
            return false;
        }
        if (!spawn.canSpawn(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return false;
        }
        if (world.m_46859_(pos.m_122012_())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.m_122012_());
        } else if (world.m_46859_(pos.m_122019_())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.m_122019_());
        } else if (world.m_46859_(pos.m_122024_())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.m_122024_());
        } else if (world.m_46859_(pos.m_122029_())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.m_122029_());
        }
        return false;
    }
}

