/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.TreeUtil;
import forestry.lepidopterology.entities.AIButterflyInteract;
import forestry.lepidopterology.entities.EntityButterfly;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;

public class AIButterflyMate
extends AIButterflyInteract {
    @Nullable
    private EntityButterfly targetMate;

    public AIButterflyMate(EntityButterfly entity) {
        super(entity);
    }

    @Override
    protected boolean canInteract() {
        if (this.entity.getButterfly().getMate() == null && this.entity.canMate()) {
            return true;
        }
        if (this.entity.cooldownEgg > 0) {
            return false;
        }
        if (this.entity.getButterfly().getMate() == null) {
            return false;
        }
        if (EntityButterfly.isMaxButterflyCluster(this.entity.m_20182_(), this.entity.m_9236_())) {
            return false;
        }
        return this.rest != null && GeneticsUtil.canNurse(this.entity.getButterfly(), this.entity.m_9236_(), this.rest);
    }

    public void m_8037_() {
        if (this.m_8045_()) {
            if (this.entity.getButterfly().getMate() == null && this.targetMate != null) {
                if (this.entity.cooldownMate <= 0 && (double)this.entity.m_20270_((Entity)this.targetMate) < 9.0) {
                    this.entity.getButterfly().setMate(this.targetMate.getButterfly().getGenome());
                    this.targetMate.getButterfly().setMate(this.entity.getButterfly().getGenome());
                    this.entity.cooldownMate = 1500;
                }
            } else if (this.rest != null) {
                IButterflyNursery nursery = TreeUtil.getOrCreateNursery((LevelAccessor)this.entity.m_9236_(), this.rest, false);
                if (nursery != null && nursery.canNurse(this.entity.getButterfly())) {
                    nursery.setCaterpillar(this.entity.getButterfly().spawnCaterpillar(nursery));
                    if (this.entity.m_217043_().m_188501_() < 1.0f / (float)this.entity.getButterfly().getGenome().getActiveValue(ButterflyChromosomes.FERTILITY)) {
                        this.entity.m_21153_(0.0f);
                    }
                }
                this.setHasInteracted();
                this.entity.cooldownEgg = 1500;
            }
        }
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            return false;
        }
        if (this.entity.getButterfly().getMate() == null) {
            if (!this.entity.canMate()) {
                return false;
            }
            this.targetMate = this.getNearbyMate();
            return this.targetMate != null;
        }
        return true;
    }

    @Override
    public boolean m_8045_() {
        if (!super.m_8045_()) {
            return false;
        }
        if (this.entity.getButterfly().getMate() == null) {
            return this.targetMate != null && this.targetMate.m_6084_() && this.targetMate.canMate();
        }
        return true;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.targetMate = null;
    }

    @Nullable
    private EntityButterfly getNearbyMate() {
        float f = 8.0f;
        List nextButterflys = this.entity.m_9236_().m_45976_(EntityButterfly.class, this.entity.m_20191_().m_82363_((double)f, (double)f, (double)f));
        double d0 = Double.MAX_VALUE;
        EntityButterfly nextButterfly = null;
        for (EntityButterfly butterfly : nextButterflys) {
            if (!this.entity.canMateWith(butterfly) || !((double)this.entity.m_20270_((Entity)butterfly) < d0)) continue;
            nextButterfly = butterfly;
            d0 = this.entity.m_20270_((Entity)butterfly);
        }
        return nextButterfly;
    }
}

