/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.recipe;

import forestry.Forestry;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.lepidopterology.features.LepidopterologyRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ButterflyMatingRecipe
extends CustomRecipe {
    public ButterflyMatingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer grid, Level level) {
        int containerSize = grid.m_6643_();
        boolean hasButterfly = false;
        boolean hasSerum = false;
        for (int i = 0; i < containerSize; ++i) {
            ItemStack stack = grid.m_8020_(i);
            if (stack.m_41619_()) continue;
            IIndividualHandlerItem handler = IIndividualHandlerItem.get(stack);
            if (handler == null) {
                return false;
            }
            if (handler.getStage() == ButterflyLifeStage.BUTTERFLY) {
                if (hasButterfly) {
                    return false;
                }
                hasButterfly = true;
                continue;
            }
            if (handler.getStage() == ButterflyLifeStage.SERUM) {
                if (hasSerum) {
                    return false;
                }
                hasSerum = true;
                continue;
            }
            return false;
        }
        return hasButterfly && hasSerum;
    }

    public ItemStack assemble(CraftingContainer grid, RegistryAccess lookup) {
        IButterfly butterfly = null;
        IIndividual serum = null;
        int containerSize = grid.m_6643_();
        for (int i = 0; i < containerSize; ++i) {
            IIndividualHandlerItem handler = IIndividualHandlerItem.get(grid.m_8020_(i));
            if (handler == null) continue;
            if (handler.getStage() == ButterflyLifeStage.BUTTERFLY) {
                butterfly = (IButterfly)handler.getIndividual();
                continue;
            }
            if (handler.getStage() != ButterflyLifeStage.SERUM) continue;
            serum = handler.getIndividual();
        }
        if (butterfly != null && serum != null) {
            IButterfly copy = butterfly.copy();
            copy.setMate(serum.getGenome());
            return copy.createStack(ButterflyLifeStage.BUTTERFLY);
        }
        Forestry.LOGGER.warn("Failed to craft butterfly");
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LepidopterologyRecipes.MATING_SERIALIZER.get();
    }
}

