/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import forestry.Forestry;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.IForestryModule;
import forestry.api.modules.IModuleManager;
import forestry.core.utils.ModUtil;
import forestry.modules.ModuleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.objectweb.asm.Type;

public class ForestryModuleManager
implements IModuleManager {
    private final LinkedHashMap<ResourceLocation, IForestryModule> loadedModules = new LinkedHashMap();
    private final LinkedHashMap<String, List<IForestryModule>> loadedModulesByMod = new LinkedHashMap();

    @Override
    public Collection<IForestryModule> getLoadedModules() {
        return Collections.unmodifiableCollection(this.loadedModules.values());
    }

    @Override
    public boolean isModuleLoaded(ResourceLocation id) {
        return this.loadedModules.containsKey(id);
    }

    @Override
    public List<IForestryModule> getModulesForMod(String modId) {
        return Collections.unmodifiableList(this.loadedModulesByMod.get(modId));
    }

    private void loadModules() {
        IForestryModule module;
        Iterator iterator;
        boolean changed;
        LinkedHashMap<String, List<IForestryModule>> discoveredModules = ForestryModuleManager.discoverModules();
        HashSet<ResourceLocation> discoveredIds = new HashSet<ResourceLocation>();
        LinkedList<IForestryModule> modulesToLoad = new LinkedList<IForestryModule>();
        for (List<IForestryModule> modModules : discoveredModules.values()) {
            for (IForestryModule module2 : modModules) {
                discoveredIds.add(module2.getId());
                modulesToLoad.add(module2);
            }
        }
        do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IForestryModule)iterator.next();
                List<ResourceLocation> dependencies = module.getModuleDependencies();
                List<String> modDependencies = module.getModDependencies();
                if (discoveredIds.containsAll(dependencies)) {
                    for (String modId2 : modDependencies) {
                        if (ModList.get().isLoaded(modId2)) continue;
                        Forestry.LOGGER.warn("Module {} is missing mod dependencies: {}", (Object)module.getId(), modDependencies);
                    }
                    continue;
                }
                Forestry.LOGGER.warn("Module {} is missing dependencies: {}", (Object)module.getId(), dependencies);
                iterator.remove();
                changed = true;
                discoveredIds.remove(module.getId());
            }
        } while (changed);
        block5: do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IForestryModule)iterator.next();
                if (!this.loadedModules.keySet().containsAll(module.getModuleDependencies())) continue;
                iterator.remove();
                this.loadedModules.put(module.getId(), module);
                this.loadedModulesByMod.computeIfAbsent(module.getId().m_135827_(), modId -> new ArrayList()).add(module);
                changed = true;
                continue block5;
            }
        } while (changed);
    }

    public void init() {
        this.loadModules();
        for (Map.Entry<ResourceLocation, IForestryModule> entry : this.loadedModules.entrySet()) {
            IEventBus modBus = ModuleUtil.getModBus(entry.getKey().m_135827_());
            IForestryModule module = entry.getValue();
            module.registerEvents(modBus);
            if (FMLEnvironment.dist != Dist.CLIENT) continue;
            module.registerClientHandler(handler -> handler.registerEvents(modBus));
        }
        this.loadedModulesByMod.forEach((modid, modules) -> Forestry.LOGGER.debug("Handling Forestry module loading for mod '{}' with {} modules: {}", modid, (Object)modules.size(), (Object)Arrays.toString(modules.toArray())));
    }

    private static LinkedHashMap<String, List<IForestryModule>> discoverModules() {
        LinkedHashMap<String, List<IForestryModule>> modules = new LinkedHashMap<String, List<IForestryModule>>();
        ModuleUtil.forEachAnnotated(Type.getType(ForestryModule.class), klass -> {
            IForestryModule module;
            try {
                module = klass.asSubclass(IForestryModule.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to instantiate module class " + klass.getName(), e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Cannot load class" + klass.getName() + " as a @ForestryModule, it does not implement IForestryModule", e);
            }
            String modId = module.getId().m_135827_();
            if (!ModUtil.isModLoaded(modId)) {
                throw new RuntimeException("Module " + module.getClass() + " returned '" + module.getId() + "' for its ID namespace, but no mod with ID '" + modId + "' is loaded");
            }
            List modModules = modules.computeIfAbsent(modId, k -> new ArrayList());
            if (module.isCore()) {
                modModules.add(0, module);
            } else {
                modModules.add(module);
            }
        });
        return modules;
    }

    public void setupApi() {
        for (IForestryModule module : this.getLoadedModules()) {
            try {
                module.setupApi();
            }
            catch (Throwable t) {
                Forestry.LOGGER.fatal("Module {} threw an error in its IForestryModule.setupApi method", (Object)module.getId(), (Object)t);
                throw new RuntimeException(t);
            }
        }
    }
}

