/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IBlockSubtype;
import forestry.api.core.IItemSubtype;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureBlockTable;
import forestry.modules.features.FeatureCreativeTab;
import forestry.modules.features.FeatureEntityType;
import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureItemGroup;
import forestry.modules.features.FeatureItemTable;
import forestry.modules.features.FeatureMenuType;
import forestry.modules.features.FeatureRecipeType;
import forestry.modules.features.FeatureTileType;
import forestry.modules.features.IModFeature;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegisterEvent;

public interface IFeatureRegistry {
    public ResourceLocation getModuleId();

    public <V> DeferredRegister<V> getRegistry(ResourceKey<? extends Registry<V>> var1);

    @Nullable
    public <V> DeferredRegister<V> getRegistryNullable(ResourceKey<? extends Registry<V>> var1);

    public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> var1, String var2);

    public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> var1, @Nullable Function<B, I> var2, String var3);

    public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> var1, Class<? extends S> var2);

    public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> var1, Collection<S> var2);

    public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> var1, S[] var2);

    public <I extends Item> FeatureItem<I> item(Supplier<I> var1, String var2);

    default public FeatureItem<Item> item(String identifier) {
        return this.item(() -> new Item(new Item.Properties()), identifier);
    }

    public FeatureItem<Item> backpack(IBackpackDefinition var1, EnumBackpackType var2, String var3);

    public FeatureItem<Item> naturalistBackpack(IBackpackDefinition var1, ResourceLocation var2, CreativeModeTab var3, String var4);

    public <I extends Item, S extends IItemSubtype> FeatureItemGroup<I, S> itemGroup(Function<S, I> var1, String var2, S[] var3);

    public <I extends Item, S extends IItemSubtype> FeatureItemGroup.Builder<I, S> itemGroup(Function<S, I> var1, S[] var2);

    public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable<I, R, C> itemTable(BiFunction<R, C, I> var1, R[] var2, C[] var3, String var4);

    public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable.Builder<I, R, C> itemTable(BiFunction<R, C, I> var1, R[] var2, C[] var3);

    public <B extends Block, R extends IBlockSubtype, C extends IBlockSubtype> FeatureBlockTable.Builder<B, R, C> blockTable(BiFunction<R, C, B> var1, R[] var2, C[] var3);

    public <T extends BlockEntity> FeatureTileType<T> tile(BlockEntityType.BlockEntitySupplier<T> var1, String var2, Supplier<Collection<? extends Block>> var3);

    public <C extends AbstractContainerMenu> FeatureMenuType<C> menuType(IContainerFactory<C> var1, String var2);

    public <E extends Entity> FeatureEntityType<E> entity(EntityType.EntityFactory<E> var1, MobCategory var2, String var3);

    public <E extends Entity> FeatureEntityType<E> entity(EntityType.EntityFactory<E> var1, MobCategory var2, String var3, UnaryOperator<EntityType.Builder<E>> var4);

    public <E extends Entity> FeatureEntityType<E> entity(EntityType.EntityFactory<E> var1, MobCategory var2, String var3, UnaryOperator<EntityType.Builder<E>> var4, Supplier<AttributeSupplier.Builder> var5);

    public FeatureFluid.Builder fluid(String var1);

    public <R extends Recipe<?>> FeatureRecipeType<R> recipeType(String var1, Supplier<RecipeSerializer<? extends R>> var2);

    public FeatureCreativeTab creativeTab(String var1, Consumer<CreativeModeTab.Builder> var2);

    @Deprecated(forRemoval=true)
    public void addRegistryListener(ResourceKey<? extends Registry<?>> var1, Consumer<RegisterEvent> var2);

    public void addRegistryListener(ResourceKey<? extends Registry<?>> var1, Runnable var2);

    public <F extends IModFeature> F register(F var1);

    public Collection<IModFeature> getFeatures();

    public Collection<IModFeature> getFeatures(ResourceKey<? extends Registry<?>> var1);
}

