/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.filter.IFilterManager;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.sorting.DefaultFilterRuleType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class FilterManager
implements IFilterManager {
    private static final Comparator<IFilterRuleType> FILTER_COMPARATOR = (f, s) -> f.getId().compareToIgnoreCase(s.getId());
    private final ImmutableMap<String, IFilterRuleType> filterRules;
    private final Object2IntOpenHashMap<String> filterIdByName;
    private final Int2ObjectOpenHashMap<IFilterRuleType> filterById;

    public FilterManager(List<IFilterRuleType> registeredRuleTypes) {
        registeredRuleTypes.sort(FILTER_COMPARATOR);
        int size = registeredRuleTypes.size();
        ImmutableMap.Builder filterRules = ImmutableMap.builderWithExpectedSize((int)size);
        Object2IntOpenHashMap filterIdByName = new Object2IntOpenHashMap(size);
        Int2ObjectOpenHashMap filterById = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            IFilterRuleType ruleType = registeredRuleTypes.get(i);
            filterRules.put((Object)ruleType.getId(), (Object)ruleType);
            filterIdByName.put((Object)ruleType.getId(), i);
            filterById.put(i, (Object)ruleType);
        }
        this.filterRules = filterRules.build();
        this.filterIdByName = filterIdByName;
        this.filterById = filterById;
    }

    @Override
    public ImmutableCollection<IFilterRuleType> getRules() {
        return this.filterRules.values();
    }

    @Override
    public IFilterRuleType getDefaultRule() {
        return DefaultFilterRuleType.CLOSED;
    }

    @Override
    @Nullable
    public IFilterRuleType getRule(String id) {
        return (IFilterRuleType)this.filterRules.get((Object)id);
    }

    @Override
    public int getId(IFilterRuleType rule) {
        return this.filterIdByName.get((Object)rule.getId());
    }

    @Override
    @Nullable
    public IFilterRuleType getRule(int id) {
        return (IFilterRuleType)this.filterById.get(id);
    }
}

