/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.network.packets;

import forestry.api.ForestryCapabilities;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.modules.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SpeciesUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PacketFilterChangeGenome(BlockPos pos, Direction facing, short index, boolean active, @Nullable ISpecies<?> species) implements IForestryPacketServer
{
    public static void handle(PacketFilterChangeGenome msg, ServerPlayer player) {
        TileUtil.getInterface(player.m_9236_(), msg.pos(), ForestryCapabilities.FILTER_LOGIC, null).ifPresent(logic -> {
            if (logic.setGenomeFilter(msg.facing(), msg.index(), msg.active(), msg.species())) {
                logic.getNetworkHandler().sendToPlayers((IFilterLogic)logic, player.m_284548_(), (Player)player);
            }
        });
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        NetworkUtil.writeDirection(buffer, this.facing);
        buffer.writeShort((int)this.index);
        buffer.writeBoolean(this.active);
        if (this.species != null) {
            buffer.writeBoolean(true);
            buffer.m_130085_(this.species.id());
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public ResourceLocation id() {
        return PacketIdServer.FILTER_CHANGE_GENOME;
    }

    public static PacketFilterChangeGenome decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        Direction facing = NetworkUtil.readDirection(buffer);
        short index = buffer.readShort();
        boolean active = buffer.readBoolean();
        ISpecies<?> allele = buffer.readBoolean() ? SpeciesUtil.getAnySpecies(buffer.m_130281_()) : null;
        return new PacketFilterChangeGenome(pos, facing, index, active, allele);
    }
}

