/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public abstract class AbstractRecipeBuilder<T extends AbstractRecipeBuilder<T>> {
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    @Nonnull
    protected String group = "";

    public T unlockedBy(String name, CriterionTriggerInstance criteria) {
        this.advancementBuilder.m_138386_(name, criteria);
        return (T)this;
    }

    public T group(String group) {
        this.group = group;
        return (T)this;
    }

    public T group(ResourceLocation group) {
        if ("minecraft".equals(group.m_135827_())) {
            return this.group(group.m_135815_());
        }
        return this.group(group.toString());
    }

    public abstract void save(Consumer<FinishedRecipe> var1);

    public abstract void save(Consumer<FinishedRecipe> var1, ResourceLocation var2);

    private ResourceLocation buildAdvancementInternal(ResourceLocation id, String folder) {
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        this.advancementBuilder.f_138336_.put("has_the_recipe", new Criterion((CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)));
        return new ResourceLocation(id.m_135827_(), "recipes/" + folder + "/" + id.m_135815_());
    }

    protected ResourceLocation buildAdvancement(ResourceLocation id, String folder) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        return this.buildAdvancementInternal(id, folder);
    }

    @Nullable
    protected ResourceLocation buildOptionalAdvancement(ResourceLocation id, String folder) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            return null;
        }
        return this.buildAdvancementInternal(id, folder);
    }

    protected static class LoadableFinishedRecipe<R extends Recipe<?>>
    extends AbstractFinishedRecipe {
        private final R recipe;
        private final RecordLoadable<R> loadable;
        final /* synthetic */ AbstractRecipeBuilder this$0;

        public LoadableFinishedRecipe(R recipe, @Nullable RecordLoadable<R> loadable, ResourceLocation advancementId) {
            this.this$0 = this$0;
            super(recipe.m_6423_(), advancementId);
            this.recipe = recipe;
            this.loadable = loadable;
        }

        public void m_7917_(JsonObject json) {
            this.loadable.serialize(this.recipe, json);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.recipe.m_7707_();
        }
    }

    protected abstract class AbstractFinishedRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        @Nullable
        private final ResourceLocation advancementId;

        @Nullable
        public JsonObject m_5860_() {
            if (this.advancementId == null) {
                return null;
            }
            return AbstractRecipeBuilder.this.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        public AbstractFinishedRecipe(@Nullable ResourceLocation id, ResourceLocation advancementId) {
            this.id = id;
            this.advancementId = advancementId;
        }
    }
}

