/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class CaveWallFeature
extends AbstractCaveFeature<Config> {
    public CaveWallFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        int width = rand.m_188503_(6) + 5;
        int height = rand.m_188503_(6) + 5;
        int depth = rand.m_188503_(6) + 5;
        for (int x = -width; x <= width; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                for (int y = -height; y <= height; ++y) {
                    if (!GeometryHelper.isInEllipsoid(width, height, depth, x, y, z)) continue;
                    BlockPos offsetPos = pos.m_7918_(x, y, z);
                    boolean airInOneDir = world.m_46859_(offsetPos.m_122012_()) || world.m_46859_(offsetPos.m_122019_()) || world.m_46859_(offsetPos.m_122029_()) || world.m_46859_(offsetPos.m_122024_()) || world.m_46859_(offsetPos.m_7495_());
                    BlockState state = world.m_8055_(offsetPos);
                    if (!SkiesFeatures.Carvers.CARVABLE_BLOCKS.contains(state.m_60734_()) || state.m_204336_(BlockTags.f_13047_) || world.m_46859_(offsetPos.m_7494_()) || !airInOneDir) continue;
                    if (rand.m_188501_() < 0.3f) {
                        this.m_5974_((LevelWriter)world, offsetPos, config.accentBlock);
                        continue;
                    }
                    this.m_5974_((LevelWriter)world, offsetPos, config.mainBlock);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        return world.m_46859_(pos.m_7494_());
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("main_block").forGetter(config -> config.mainBlock), (App)BlockState.f_61039_.fieldOf("accent_block").forGetter(config -> config.accentBlock)).apply((Applicative)instance, Config::new));
        public final BlockState mainBlock;
        public final BlockState accentBlock;

        public Config(BlockState mainBlock, BlockState accentBlock) {
            this.mainBlock = mainBlock;
            this.accentBlock = accentBlock;
        }

        public Config(BlockState mainBlock) {
            this(mainBlock, mainBlock);
        }
    }
}

