/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.registries.DeferredRegister;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import lombok.NonNull;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.component.world.CommonShockwaveHandlerComponent;
import net.arna.jcraft.api.registry.JAdvancementTriggerRegistry;
import net.arna.jcraft.api.registry.JBlockEntityTypeRegistry;
import net.arna.jcraft.api.registry.JBlockRegistry;
import net.arna.jcraft.api.registry.JCommandRegistry;
import net.arna.jcraft.api.registry.JCreativeMenuTabRegistry;
import net.arna.jcraft.api.registry.JDimensionRegistry;
import net.arna.jcraft.api.registry.JEnchantmentRegistry;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JEventsRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JMarkerExtractorRegistry;
import net.arna.jcraft.api.registry.JMarkerInjectorRegistry;
import net.arna.jcraft.api.registry.JMenuRegistry;
import net.arna.jcraft.api.registry.JMoveActionTypeRegistry;
import net.arna.jcraft.api.registry.JMoveConditionTypeRegistry;
import net.arna.jcraft.api.registry.JMoveTypeRegistry;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.argumenttype.StandArgumentType;
import net.arna.jcraft.common.block.CoffinBlock;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.effects.DazedStatusEffect;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.config.GravityChangerConfig;
import net.arna.jcraft.common.gravity.util.GravityChannel;
import net.arna.jcraft.common.loot.JLootTableHelper;
import net.arna.jcraft.common.network.RemoteStandInteractPacket;
import net.arna.jcraft.common.network.c2s.ConfigUpdatePacket;
import net.arna.jcraft.common.network.c2s.CooldownCancelPacket;
import net.arna.jcraft.common.network.c2s.MenuCallPacket;
import net.arna.jcraft.common.network.c2s.PlayerInputPacket;
import net.arna.jcraft.common.network.c2s.PredictionTriggerPacket;
import net.arna.jcraft.common.network.c2s.StandBlockPacket;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.network.s2c.ShaderActivationPacket;
import net.arna.jcraft.common.network.s2c.ShaderDeactivationPacket;
import net.arna.jcraft.common.network.s2c.TimeAccelStatePacket;
import net.arna.jcraft.common.network.s2c.TimeStopStatePacket;
import net.arna.jcraft.common.saveddata.ExclusiveStandsData;
import net.arna.jcraft.common.tickable.JEnemies;
import net.arna.jcraft.common.tickable.MoveTickQueue;
import net.arna.jcraft.common.tickable.PastDimensions;
import net.arna.jcraft.common.tickable.Timestops;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.DashData;
import net.arna.jcraft.common.util.DimensionData;
import net.arna.jcraft.common.util.DummyClientEntityHandler;
import net.arna.jcraft.common.util.EntityInterest;
import net.arna.jcraft.common.util.EntitySelectorOptionsRegistrar;
import net.arna.jcraft.common.util.EvolutionItemHandler;
import net.arna.jcraft.common.util.IClientEntityHandler;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class JCraft {
    public static final String MOD_ID = "jcraft";
    public static final Logger LOGGER = LogManager.getLogger((String)"jcraft");
    public static final int SPEC_QUEUE_MOVESTUN_LIMIT = 11;
    public static final int QUEUE_MOVESTUN_LIMIT = 7;
    public static final GravityChangerConfig gravityConfig = new GravityChangerConfig();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TAB_REGISTRY = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_279569_);
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_256890_);
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_256929_);
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_256840_);
    public static final DeferredRegister<Enchantment> ENCHANTMENT = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_256762_);
    public static final DeferredRegister<ResourceLocation> STATS = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_256887_);
    public static final DeferredRegister<MenuType<?>> MENU_REGISTRY = DeferredRegister.create((String)"jcraft", (ResourceKey)Registries.f_256798_);
    public static final GameRules.Key<GameRules.IntegerValue> CHANCE_MOB_SPAWNS_WITH_STAND = GameRules.m_46189_((String)"chanceMobSpawnsWithStand", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)5));
    public static final GameRules.Key<GameRules.BooleanValue> ALLOW_MOB_EVOLVED_STANDS = GameRules.m_46189_((String)"allowMobEvolvedStands", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
    public static final GameRules.Key<GameRules.BooleanValue> STAND_GRIEFING = GameRules.m_46189_((String)"standGriefing", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> KEEP_STAND = GameRules.m_46189_((String)"keepStand", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> KEEP_SPEC = GameRules.m_46189_((String)"keepSpec", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.IntegerValue> STAND_ARROW_BASE_DAMAGE = GameRules.m_46189_((String)"standArrowBaseDamage", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)2));
    public static final GameRules.Key<GameRules.BooleanValue> FALLING_METEORS = GameRules.m_46189_((String)"doFallingMeteors", (GameRules.Category)GameRules.Category.SPAWNING, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static int preloadLockTicks = 0;
    public static ServerLevel auWorld;
    private static final List<ChunkPos> preloadedChunks;
    public static final Object2IntMap<LivingEntity> burstTimers;
    public static final Object2IntMap<LivingEntity> pushblockCooldowns;
    public static final Map<LivingEntity, DashData> dashes;
    private static final Map<Entity, EntityInterest> entitiesOfInterest;
    public static final int DASH_COOLDOWN = 40;
    public static final int LIGHT_COOLDOWN = 20;
    private static IClientEntityHandler clientEntityHandler;
    private static ExclusiveStandsData exclusiveStandsData;

    public static void init() {
        JRegistries.init();
        JParticleTypeRegistry.init();
        PARTICLES.register();
        JSoundRegistry.init();
        SOUNDS.register();
        JEntityTypeRegistry.ENTITY_TYPE_REGISTRY.register();
        JBlockRegistry.BLOCK_REGISTRY.register();
        JItemRegistry.ITEM_REGISTRY.register();
        JBlockEntityTypeRegistry.BLOCK_ENTITY_TYPE_REGISTRY.register();
        JStandTypeRegistry.STAND_TYPE_REGISTRY.register();
        JSpecTypeRegistry.SPEC_TYPE_REGISTRY.register();
        JMoveActionTypeRegistry.MOVE_ACTION_TYPE_REGISTRY.register();
        JMoveConditionTypeRegistry.MOVE_CONDITION_TYPE_REGISTRY.register();
        JMoveTypeRegistry.MOVE_TYPE_REGISTRY.register();
        JMarkerExtractorRegistry.EXTRACTOR_REGISTRY.register();
        JMarkerInjectorRegistry.INJECTOR_REGISTRY.register();
        JTagRegistry.init();
        JAdvancementTriggerRegistry.init();
        JCreativeMenuTabRegistry.init();
        CREATIVE_TAB_REGISTRY.register();
        JMenuRegistry.init();
        MENU_REGISTRY.register();
        CommandRegistrationEvent.EVENT.register(JCommandRegistry::registerCommands);
        JEventsRegistry.registerEvents();
        JStatusRegistry.init();
        EFFECTS.register();
        JEntityTypeRegistry.registerAttributes();
        JDimensionRegistry.init();
        JEnchantmentRegistry.init();
        ENCHANTMENT.register();
        JLootTableHelper.registerLootTables();
        TimeAccelStatePacket.init();
        JServerConfig.init();
        JStatRegistry.init();
        STATS.register();
        MoveTickQueue.registerMoveTickQueue();
        GravityChannel.registerReceivers();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_PLAYER_INPUT, PlayerInputPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_PLAYER_INPUT_HOLD, PlayerInputPacket::handleHold);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ConfigUpdatePacket.ID, ConfigUpdatePacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_STAND_BLOCK, StandBlockPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_COOLDOWN_CANCEL, CooldownCancelPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_REMOTE_STAND_INTERACT, RemoteStandInteractPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_PREDICTION_TRIGGER, PredictionTriggerPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)JPacketRegistry.C2S_MENU_CALL, MenuCallPacket::handle);
    }

    public static void postInit() {
        JCraft.initBlockPostLoad();
        EvolutionItemHandler.init();
        JCraft.initDispenserBehaviors();
        JStatRegistry.initFormatters();
    }

    private static void initBlockPostLoad() {
        CoffinBlock.init();
    }

    private static void initDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JItemRegistry.KNIFE.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NonNull
            protected Projectile m_6895_(@NonNull Level world, @NonNull Position position, @NonNull ItemStack stack) {
                if (world == null) {
                    throw new NullPointerException("world is marked non-null but is null");
                }
                if (position == null) {
                    throw new NullPointerException("position is marked non-null but is null");
                }
                if (stack == null) {
                    throw new NullPointerException("stack is marked non-null but is null");
                }
                KnifeProjectile knife = new KnifeProjectile(world);
                knife.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                knife.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                return knife;
            }
        });
    }

    public static void registerEntitySelectorOptions(EntitySelectorOptionsRegistrar registrar) {
        registrar.register("jcraft_timestopped", parser -> {
            parser.m_121270_((builder, consumer) -> SharedSuggestionProvider.m_82970_(Arrays.asList("true", "false"), (SuggestionsBuilder)builder));
            boolean invert = parser.m_121330_();
            StringReader reader = parser.m_121346_();
            boolean value = reader.readBoolean() && !invert;
            parser.m_121272_(e -> JUtils.isAffectedByTimeStop(e) == value);
        }, p -> true, (Component)Component.m_237115_((String)"argument.entity.options.jcraft_timestopped"));
        registrar.register("jcraft_stand", parser -> {
            StandType standType;
            StringReader reader = parser.m_121346_();
            int cursor = reader.getCursor();
            ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
            parser.m_121270_((builder, consumer) -> SharedSuggestionProvider.m_82981_(JRegistries.STAND_TYPE_REGISTRY.getIds().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder));
            try {
                standType = (StandType)JRegistries.STAND_TYPE_REGISTRY.get(resourceLocation);
            }
            catch (IllegalArgumentException e2) {
                reader.setCursor(cursor);
                throw StandArgumentType.NOT_FOUND.createWithContext((ImmutableStringReader)reader);
            }
            parser.m_121272_(e -> {
                if (!(e instanceof LivingEntity)) {
                    return false;
                }
                LivingEntity entity = (LivingEntity)e;
                CommonStandComponent standData = JComponentPlatformUtils.getStandComponent(entity);
                return standData.getType() == standType;
            });
        }, p -> true, (Component)Component.m_237115_((String)"argument.entity.options.jcraft_stand"));
    }

    public static void markItemOfInterest(@NonNull Entity entity, @NonNull EntityInterest interest) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (interest == null) {
            throw new NullPointerException("interest is marked non-null but is null");
        }
        entitiesOfInterest.put(entity, interest);
    }

    public static void beginTimestop(@NonNull LivingEntity timestopper, @NonNull Vec3 position, @NonNull ServerLevel world, int duration) {
        if (timestopper == null) {
            throw new NullPointerException("timestopper is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        ResourceKey worldRegistryKey = world.m_46472_();
        Timestops.enqueue(new DimensionData(timestopper, position, (ResourceKey<Level>)worldRegistryKey, duration));
        TimeStopStatePacket.send(world.m_6907_(), TimeStopStatePacket.createStartPacket(timestopper.m_19879_(), position, (ResourceKey<Level>)worldRegistryKey, duration));
        List toStop = world.m_6443_(ServerPlayer.class, new AABB(position.m_82520_(96.0, 96.0, 96.0), position.m_82492_(96.0, 96.0, 96.0)), EntitySelector.f_20403_);
        for (ServerPlayer serverPlayer : toStop) {
            ShaderActivationPacket.send(serverPlayer, (Entity)timestopper, 0, duration, ShaderActivationPacket.Type.ZA_WARUDO);
            if (serverPlayer == timestopper || serverPlayer.m_7500_()) continue;
            for (int i = 0; i < serverPlayer.m_150109_().f_35974_.size(); ++i) {
                serverPlayer.m_36335_().m_41524_(((ItemStack)serverPlayer.m_150109_().f_35974_.get(i)).m_41720_(), duration);
            }
            serverPlayer.m_36335_().m_41524_(serverPlayer.m_21206_().m_41720_(), duration);
        }
    }

    public static void stopTimestop(Entity timestopper) {
        DimensionData timestop = Timestops.getTimestop(timestopper);
        Level world = timestopper.m_9236_();
        if (timestop == null || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        TimeStopStatePacket.send(serverWorld.m_6907_(), TimeStopStatePacket.createStopPacket(timestopper.m_19879_()));
        Vec3 position = Objects.requireNonNull(timestop.getPos());
        List toUnfreeze = serverWorld.m_6443_(ServerPlayer.class, new AABB(position.m_82520_(96.0, 96.0, 96.0), position.m_82492_(96.0, 96.0, 96.0)), EntitySelector.f_20403_);
        for (ServerPlayer serverPlayer : toUnfreeze) {
            ShaderDeactivationPacket.send(serverPlayer, ShaderActivationPacket.Type.ZA_WARUDO);
            for (int i = 0; i < serverPlayer.m_150109_().f_35974_.size(); ++i) {
                serverPlayer.m_36335_().m_41527_(((ItemStack)serverPlayer.m_150109_().f_35974_.get(i)).m_41720_());
            }
            serverPlayer.m_36335_().m_41527_(serverPlayer.m_21206_().m_41720_());
        }
        Timestops.remove(timestop);
    }

    public static void clearPreloadedChunks() {
        if (preloadedChunks.isEmpty()) {
            return;
        }
        for (ChunkPos p : preloadedChunks) {
            auWorld.m_8602_(p.f_45578_, p.f_45579_, false);
        }
        preloadedChunks.clear();
    }

    public static void preloadChunk(ServerLevel auWorld, int chunkX, int chunkZ) {
        if (auWorld.m_8902_().contains(new ChunkPos(chunkX, chunkZ).m_45588_())) {
            return;
        }
        preloadedChunks.add(new ChunkPos(chunkX, chunkZ));
        auWorld.m_8602_(chunkX, chunkZ, true);
    }

    public static StandEntity<?, ?> summon(LivingEntity user) {
        return JCraft.summon(user.m_9236_(), user);
    }

    public static StandEntity<?, ?> summon(Level world, LivingEntity user) {
        if (user.m_21023_((MobEffect)JStatusRegistry.STANDLESS.get()) || user.m_5833_()) {
            return null;
        }
        CommonStandComponent standData = JComponentPlatformUtils.getStandComponent(user);
        StandType type = standData.getType();
        if (StandTypeUtil.isNone(type)) {
            return null;
        }
        StandEntity<?, ?> stand = type.createEntity(world);
        int skin = standData.getSkin();
        stand.setSkin(skin);
        stand.m_146884_(user.m_20182_().m_82546_(user.m_20154_()));
        stand.m_20329_((Entity)user);
        stand.setUser(user);
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            if (JUtils.canAct(user) && StandBlockPacket.isBlocking(player)) {
                stand.wantToBlock = true;
                stand.tryBlock();
            }
        } else if (user instanceof Mob) {
            Mob mob = (Mob)user;
            JEnemies.add(mob);
        }
        world.m_7967_(stand);
        standData.setStand(stand);
        return stand;
    }

    public static void createParticle(ServerLevel world, double x, double y, double z, JParticleType type) {
        if (world == null || type == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(3);
        buf.writeDouble(x);
        buf.writeDouble(y);
        buf.writeDouble(z);
        buf.m_130068_((Enum)type);
        ServerChannelFeedbackPacket.send(JUtils.around(world, new Vec3(x, y, z), 128.0), buf);
    }

    public static void createHitsparks(ServerLevel world, double x, double y, double z, JParticleType type, int sparkCount, double sparkSpeed) {
        if (world == null || type == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(5);
        buf.writeDouble(x);
        buf.writeDouble(y);
        buf.writeDouble(z);
        buf.m_130068_((Enum)type);
        buf.writeInt(sparkCount);
        buf.writeDouble(sparkSpeed);
        ServerChannelFeedbackPacket.send(JUtils.around(world, new Vec3(x, y, z), 128.0), buf);
    }

    public static void tryPushBlock(ServerLevel world, LivingEntity user, @NonNull StandEntity<?, ?> stand) {
        if (stand == null) {
            throw new NullPointerException("stand is marked non-null but is null");
        }
        if (pushblockCooldowns.getOrDefault((Object)user, -1) > 0) {
            return;
        }
        float third = stand.getMaxStandGauge() / 3.0f;
        float gauge = stand.getStandGauge();
        if (gauge <= third) {
            return;
        }
        pushblockCooldowns.put((Object)user, 8);
        stand.setStandGauge(gauge - third);
        stand.setMoveStun(10);
        world.m_6269_(null, (Entity)user, (SoundEvent)JSoundRegistry.STAND_PUSHBLOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        JUtils.setVelocity((Entity)user, Vec3.f_82478_);
        Vec3 position = user.m_20182_();
        double userWidth = user.m_20205_();
        IntOpenHashSet pushed = new IntOpenHashSet();
        for (Entity entity : world.m_8583_()) {
            double launchVel;
            int id;
            StandEntity standTarget;
            StandEntity<?, ?> targetStand;
            LivingEntity living;
            if (entity == user || entity == stand || !(entity instanceof LivingEntity)) continue;
            Object target = living = (LivingEntity)entity;
            CommonStandComponent standComponent = JComponentPlatformUtils.getStandComponent(living);
            if (standComponent.getStand() != null && (targetStand = standComponent.getStand()).m_20238_(position) < living.m_20238_(position)) {
                target = targetStand;
            }
            double distance = target.m_20182_().m_82554_(position);
            double radius = (double)target.m_20205_() + 2.0;
            if (target instanceof StandEntity && !(standTarget = (StandEntity)target).isRemote() && standTarget.hasUser()) {
                target = standTarget.getUserOrThrow();
            }
            if (pushed.contains(id = target.m_19879_()) || !(distance < radius)) continue;
            if (DashData.isDashing(target)) {
                DashData.getDash((LivingEntity)target).finished = true;
            }
            double d = launchVel = target.m_20096_() ? 1.5 : 0.75;
            if (distance < userWidth * 2.0) {
                launchVel += (userWidth * 2.0 - distance) / 1.5;
            }
            Vec3 delta = target.m_20182_().m_82546_(position).m_82541_();
            delta = switch (GravityChangerAPI.getGravityDirection((Entity)target).m_122434_()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> new Vec3(0.0, delta.f_82480_, delta.f_82481_);
                case Direction.Axis.Y -> new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
                case Direction.Axis.Z -> new Vec3(delta.f_82479_, delta.f_82480_, 0.0);
            };
            JComponentPlatformUtils.getShockwaveHandler((Level)world).addShockwave(stand.m_146892_(), delta, 1.5f, CommonShockwaveHandlerComponent.Shockwave.Type.PUSHBLOCK);
            JUtils.addVelocity((Entity)target, delta.m_82490_(launchVel));
            pushed.add(id);
        }
    }

    public static void comboBreak(ServerLevel world, LivingEntity player, MobEffectInstance stun) {
        if (stun == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(player);
        if (stun.m_19557_() > 1 && DazedStatusEffect.canBeComboBroken(stun.m_19564_()) && cooldowns.getCooldown(CooldownType.COMBO_BREAKER) <= 0) {
            cooldowns.startCooldown(CooldownType.COMBO_BREAKER);
            JCraft.stun(player, 5, 2);
            world.m_6269_(null, (Entity)player, (SoundEvent)JSoundRegistry.COMBO_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Vec3 pPos = player.m_146892_();
            burstTimers.put((Object)player, 4);
            JCraft.createParticle(world, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, JParticleType.COMBO_BREAK);
        }
    }

    @Nullable
    public static <T extends Entity> T teleportToWorld(T e, ServerLevel w, double x, double y, double z) {
        if (!e.m_213877_()) {
            e.m_19877_();
            Entity entity = e.m_6095_().m_20615_((Level)w);
            if (entity != null) {
                entity.m_20361_(e);
                entity.m_7678_(x, y, z, e.m_146908_(), e.m_146909_());
                entity.m_20256_(e.m_20184_());
                w.m_143334_(entity);
                e.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                w.m_8886_();
                return (T)entity;
            }
        }
        return null;
    }

    public static void dimensionHop(LivingEntity entity, int heightOffset) {
        ServerLevel original = (ServerLevel)entity.m_9236_();
        MinecraftServer server = original.m_7654_();
        ServerLevel au = server.m_129880_(JDimensionRegistry.AU_DIMENSION_KEY);
        if (au == null) {
            LOGGER.fatal("Alternate universe world does not exist!");
            return;
        }
        if (original == au) {
            return;
        }
        Vec3 pos = entity.m_20182_();
        LivingEntity finalEnt = entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ChunkPos chunkPos = new ChunkPos(BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_));
            au.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)player.m_19879_());
            player.m_8999_(au, pos.f_82479_, pos.f_82480_ - (double)heightOffset, pos.f_82481_, entity.m_146908_(), entity.m_146909_());
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)JSoundRegistry.D4C_ALT_UNIVERSE_AMBIENCE.get())), SoundSource.MUSIC, pos.f_82479_, pos.f_82480_ - (double)heightOffset, pos.f_82481_, 1.0f, 1.0f, 0L));
        } else {
            finalEnt = JCraft.teleportToWorld(entity, au, entity.m_20185_(), entity.m_20186_() - (double)heightOffset, entity.m_20189_());
        }
        if (finalEnt == null) {
            LOGGER.error("Failed to teleport " + String.valueOf(entity) + " to alternate universe!");
            return;
        }
        finalEnt.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 9, true, false, true));
        PastDimensions.enqueue(new DimensionData(finalEnt, pos, (ResourceKey<Level>)original.m_46472_()));
    }

    public static boolean wasRecentlyAttacked(CombatTracker tracker) {
        tracker.m_19296_();
        return tracker.f_19281_;
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void stun(LivingEntity victim, int duration, @Range(from=0L, to=4L) int amplifier) {
        JCraft.stun(victim, duration, amplifier, null);
    }

    public static void stun(LivingEntity victim, int duration, @Range(from=0L, to=4L) int amplifier, @Nullable Entity attacker) {
        if (victim == null || !victim.m_6084_() || duration == 0) {
            return;
        }
        victim.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.DAZED.get(), duration, amplifier, false, false, true));
    }

    public static void prefixedLog(boolean isClient, String msg) {
        LOGGER.info(isClient ? "[CLIENT]: " + msg : "[SERVER]: " + msg);
    }

    public static Map<Entity, EntityInterest> getEntitiesOfInterest() {
        return entitiesOfInterest;
    }

    public static IClientEntityHandler getClientEntityHandler() {
        return clientEntityHandler;
    }

    public static void setClientEntityHandler(IClientEntityHandler clientEntityHandler) {
        JCraft.clientEntityHandler = clientEntityHandler;
    }

    public static ExclusiveStandsData getExclusiveStandsData() {
        return exclusiveStandsData;
    }

    public static void setExclusiveStandsData(ExclusiveStandsData exclusiveStandsData) {
        JCraft.exclusiveStandsData = exclusiveStandsData;
    }

    static {
        preloadedChunks = new ArrayList<ChunkPos>();
        burstTimers = new Object2IntOpenHashMap();
        pushblockCooldowns = new Object2IntOpenHashMap();
        dashes = new WeakHashMap<LivingEntity, DashData>();
        entitiesOfInterest = new HashMap<Entity, EntityInterest>();
        clientEntityHandler = DummyClientEntityHandler.INSTANCE;
        exclusiveStandsData = null;
    }
}

