/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.AttackData;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.TrainingDummyEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.network.s2c.ComboCounterPacket;
import net.arna.jcraft.common.network.s2c.DamageNumberPacket;
import net.arna.jcraft.common.util.IComboCounter;
import net.arna.jcraft.common.util.ICustomDamageHandler;
import net.arna.jcraft.common.util.IJCraftComboTracker;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.mixin.LivingEntityInvoker;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface Attacks {
    @Deprecated(forRemoval=false, since="0.17.3")
    public static void damageLogic(Level world, LivingEntity ent, Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, @Nullable Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation, boolean canBackstab, boolean unblockable) {
        if (world == null || world.f_46443_ || ent == null || !ent.m_142066_()) {
            return;
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)attacker;
            Attacks.comboCounterLogic(playerEntity, ent);
        }
        Attacks.baseDamageLogic(ent, kbVec, stunTicks, stunLevel, overrideStun, damage, lift, blockstun, source, attacker, hitAnimation, null, canBackstab, unblockable, true);
    }

    @Deprecated(forRemoval=false, since="0.17.3")
    public static void damageLogic(Level world, LivingEntity ent, Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, @Nullable Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation, boolean canBackstab) {
        if (world == null || world.f_46443_ || ent == null || !ent.m_142066_()) {
            return;
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)attacker;
            Attacks.comboCounterLogic(playerEntity, ent);
        }
        Attacks.baseDamageLogic(ent, kbVec, stunTicks, stunLevel, overrideStun, damage, lift, blockstun, source, attacker, hitAnimation, null, canBackstab, false, true);
    }

    @Deprecated(forRemoval=false, since="0.17.3")
    public static void damageLogic(Level world, LivingEntity ent, Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, @Nullable Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation) {
        if (world == null || world.f_46443_ || ent == null || !ent.m_142066_()) {
            return;
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)attacker;
            Attacks.comboCounterLogic(playerEntity, ent);
        }
        Attacks.baseDamageLogic(ent, kbVec, stunTicks, stunLevel, overrideStun, damage, lift, blockstun, source, attacker, hitAnimation, null, false, false, true);
    }

    public static void damageLogic(Level world, LivingEntity victim, AttackData attackData) {
        if (world == null || world.f_46443_ || victim == null || !victim.m_142066_()) {
            return;
        }
        Entity entity = attackData.attacker();
        if (entity instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entity;
            Attacks.comboCounterLogic(playerEntity, victim);
        }
        Attacks.baseDamageLogic(victim, attackData.kbVec(), attackData.stunTicks(), attackData.stunLevel(), attackData.overrideStun(), attackData.damage(), attackData.lift(), attackData.blockStun(), attackData.source(), attackData.attacker(), attackData.hitAnimation(), attackData.moveUsage(), attackData.canBackstab(), attackData.unblockable(), attackData.cancelMoves());
    }

    public static void comboCounterLogic(ServerPlayer playerEntity, @Nullable LivingEntity victim) {
        IOwnable ownable;
        if (victim == null || victim instanceof IOwnable && (ownable = (IOwnable)victim).getMaster() == playerEntity) {
            return;
        }
        if (!JServerConfig.ENABLE_FRIENDLY_FIRE.getValue() && victim.m_7307_((Entity)playerEntity)) {
            return;
        }
        IComboCounter comboCounter = (IComboCounter)playerEntity;
        if (comboCounter.jcraft$getLastAttacked() != victim) {
            comboCounter.jcraft$setComboCount(1);
        } else {
            MobEffectInstance stun = comboCounter.jcraft$getLastAttacked().m_21124_((MobEffect)JStatusRegistry.DAZED.get());
            if (stun != null && stun.m_19564_() != 2) {
                comboCounter.jcraft$incrementComboCount();
            } else {
                comboCounter.jcraft$setComboCount(1);
            }
            ComboCounterPacket.send(playerEntity, comboCounter.jcraft$getComboCount(), ((IJCraftComboTracker)victim).jcraft$getDamageScaling());
        }
        comboCounter.jcraft$setLastAttacked(victim);
    }

    public static void baseDamageLogic(LivingEntity victim, Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, @Nullable Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation, @Nullable MoveUsage moveUsage, boolean canBackstab, boolean unblockable, boolean cancelAttack) {
        JSpec<?, ?> spec;
        ICustomDamageHandler customDamageHandler;
        if (victim instanceof ICustomDamageHandler && !(customDamageHandler = (ICustomDamageHandler)victim).handleDamage(kbVec, stunTicks, stunLevel, overrideStun, damage, lift, blockstun, source, attacker, hitAnimation, moveUsage, canBackstab, unblockable)) {
            return;
        }
        if (victim != null && !JServerConfig.ENABLE_FRIENDLY_FIRE.getValue() && attacker != null && victim.m_7307_(attacker)) {
            return;
        }
        boolean hit = true;
        boolean tsHit = JUtils.isAffectedByTimeStop((Entity)victim);
        StandEntity<?, ?> stand = JUtils.getStand(victim);
        if (stand != null) {
            AbstractMove<?, ?> standAttack;
            if (stand.wantToBlock && stand.canBlock()) {
                stand.tryBlock();
            }
            if ((standAttack = stand.getCurrentMove()) != null) {
                if (!tsHit && standAttack.isCounter() && stand.getMoveStun() < standAttack.getWindupPoint()) {
                    ((AbstractCounterAttack)standAttack).counter(stand, attacker, source);
                    victim.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
                    return;
                }
                if (--stand.armorPoints < 0) {
                    if (cancelAttack) {
                        stand.cancelMove(true);
                    }
                } else {
                    JComponentPlatformUtils.getMiscData(victim).displayArmoredHit();
                }
            }
            if (stand.blocking && !stand.isRemote()) {
                boolean backstabbed = false;
                if (attacker != null) {
                    double delta = Math.abs((victim.f_20885_ + 90.0f) % 360.0f - (attacker.m_6080_() + 90.0f) % 360.0f);
                    if (canBackstab && (360.0 - delta % 360.0 < 45.0 || delta % 360.0 < 45.0) && victim.m_20238_(attacker.m_20182_()) >= 1.5625) {
                        JCraft.createParticle((ServerLevel)attacker.m_9236_(), victim.m_20185_(), attacker.m_20188_(), victim.m_20189_(), JParticleType.BACK_STAB);
                        stand.m_5496_((SoundEvent)JSoundRegistry.BACKSTAB.get(), 1.0f, 1.0f);
                        stand.blocking = false;
                        overrideStun = true;
                        backstabbed = true;
                    }
                }
                if (!backstabbed && !unblockable) {
                    stand.setMoveStun(blockstun);
                    stand.setStandGauge(stand.getStandGauge() - 2.0f * damage);
                    stand.m_5496_((SoundEvent)JSoundRegistry.STAND_BLOCK.get(), 1.0f, 1.0f);
                    hit = false;
                    overrideStun = false;
                } else {
                    stand.blocking = false;
                }
            }
        }
        if (victim == null) {
            return;
        }
        if (tsHit) {
            stunLevel = 3;
            if (stunTicks > 20) {
                stunTicks = 20;
            }
            lift = false;
        }
        IJCraftComboTracker comboTracker = (IJCraftComboTracker)victim;
        LivingEntity livingAttacker = null;
        if (attacker instanceof LivingEntity) {
            LivingEntity l;
            livingAttacker = l = (LivingEntity)attacker;
        }
        if (hit) {
            MobEffectInstance stun;
            comboTracker.jcraft$increaseHitCount();
            boolean allowFurtherStun = true;
            if (livingAttacker != null && moveUsage != null) {
                boolean bl = allowFurtherStun = !comboTracker.jcraft$addMoveToCombo(livingAttacker, moveUsage);
            }
            if ((stun = victim.m_21124_((MobEffect)JStatusRegistry.DAZED.get())) != null && overrideStun) {
                victim.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            }
            if (allowFurtherStun) {
                JCraft.stun(victim, stunTicks, stunLevel, attacker);
            }
            if (hitAnimation != null) {
                JComponentPlatformUtils.getHitProperties(victim).setHitAnimation(hitAnimation, stunTicks);
            }
            if (!tsHit) {
                victim.m_5997_(kbVec.f_82479_, kbVec.f_82480_, kbVec.f_82481_);
            }
        }
        if ((spec = JUtils.getSpec(victim)) != null && spec.curMove != null) {
            if (--spec.armorPoints < 0) {
                if (cancelAttack) {
                    spec.cancelMove(true);
                }
            } else {
                JComponentPlatformUtils.getMiscData(victim).displayArmoredHit();
            }
        }
        if (lift) {
            Vec3 vel = victim.m_20184_();
            double finalY = vel.f_82480_;
            if (!victim.m_20096_()) {
                finalY = Mth.m_14008_((double)(vel.f_82480_ / 2.0), (double)0.085, (double)0.25);
            }
            GravityChangerAPI.setWorldVelocity((Entity)victim, new Vec3(Mth.m_14008_((double)vel.f_82479_, (double)-1.0, (double)1.0), Mth.m_14008_((double)finalY, (double)-0.25, (double)0.25), Mth.m_14008_((double)vel.f_82481_, (double)-1.0, (double)1.0)));
        }
        Attacks.damage(attacker, damage, source, victim);
        if ((victim.m_21224_() || victim.m_21223_() <= 0.0f) && livingAttacker != null) {
            StandEntity<?, ?> standAttacker = JUtils.getStand(livingAttacker);
            if (standAttacker != null) {
                standAttacker.freshKill(victim);
            }
            if (stand != null && stand.hasUser()) {
                Player player;
                LivingEntity livingEntity;
                LivingEntity livingEntity2 = livingEntity = standAttacker != null ? standAttacker.getUser() : livingAttacker;
                if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
                    player.m_36220_((ResourceLocation)JStatRegistry.STAND_USERS_KILLED.get());
                }
            }
        }
        if (tsHit) {
            JComponentPlatformUtils.getTimeStopData((Entity)victim).ifPresent(ts -> ts.addTotalVelocity(kbVec));
        } else {
            JUtils.syncVelocityUpdate((Entity)victim);
        }
    }

    public static void damage(@Nullable Entity attacker, float damage, DamageSource damageSource, LivingEntity ent) {
        if (!JUtils.canDamage(damageSource, (Entity)ent)) {
            return;
        }
        float scaling = ((IJCraftComboTracker)ent).jcraft$getDamageScaling();
        damage *= scaling;
        switch (JServerConfig.DAMAGE_SCALING_TYPE.getValue()) {
            case TargetHealth: {
                float healthRatio = ent.m_21233_() / 20.0f;
                float damageAdjustment = healthRatio - 1.0f;
                if (damageAdjustment > 0.0f) {
                    damage *= 1.0f + damageAdjustment / 5.0f;
                }
            }
            case AttackerDamage: {
                double playerDps;
                double multiplier;
                if (!(attacker instanceof LivingEntity)) break;
                LivingEntity livingAttacker = (LivingEntity)attacker;
                double baseDamage = 1.0;
                double baseAttackSpeed = 1.999999970197677;
                double baseDps = baseDamage * baseAttackSpeed;
                double netheriteDamage = 8.0;
                double netheriteSpeed = 1.5999998807907119;
                double netheriteDps = netheriteDamage * netheriteSpeed;
                AttributeMap attributes = livingAttacker.m_21204_();
                double playerSpeed = 1.0;
                if (attributes.m_22171_(Attributes.f_22283_)) {
                    playerSpeed = livingAttacker.m_21133_(Attributes.f_22283_) * 2.0;
                }
                double playerDamage = 1.0;
                if (attributes.m_22171_(Attributes.f_22281_)) {
                    playerDamage = livingAttacker.m_21133_(Attributes.f_22281_);
                }
                if (!((multiplier = 1.0 + ((playerDps = playerDamage * playerSpeed) - baseDps) / (netheriteDps - baseDps)) > 0.0)) break;
                damage = (float)((double)damage * (multiplier * (double)JServerConfig.DAMAGE_SCALING_MULTIPLIER.getValue()));
            }
        }
        float armor = ent.m_21230_();
        float toughness = (float)ent.m_21133_(Attributes.f_22285_);
        Entity entity = JUtils.getUserIfStand(attacker);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36222_((ResourceLocation)JStatRegistry.RAW_DAMAGE.get(), (int)damage);
        }
        if (ent instanceof Player) {
            armor = 20.0f;
            toughness = 12.0f;
        } else if (!(ent instanceof StandEntity) && JUtils.getStand(ent) == null) {
            damage *= JServerConfig.VS_STANDLESS_DAMAGE_MULTIPLIER.getValue();
        }
        damage = JUtils.getDamageThroughArmor(damage, armor * 0.9f, toughness * 0.9f);
        damage = ((LivingEntityInvoker)ent).invokeModifyAppliedDamage(damageSource, damage);
        Attacks.applyAbsorptionAndStats(damage, damageSource, ent);
    }

    public static void trueDamage(float damage, DamageSource damageSource, LivingEntity ent) {
        if (ent == null || ent.m_213877_() || ent.m_21224_()) {
            return;
        }
        float scaling = ((IJCraftComboTracker)ent).jcraft$getDamageScaling();
        damage *= scaling;
        if (ent instanceof TrainingDummyEntity && !ent.m_9236_().m_5776_() && damage > 0.0f) {
            Attacks.sendDamageNumberPacketForTrueDamage((TrainingDummyEntity)ent, damage);
        }
        damage = JUtils.getDamageThroughArmor(damage, (float)ent.m_21230_() * 0.9f, (float)ent.m_21133_(Attributes.f_22285_) * 0.9f);
        Attacks.applyAbsorptionAndStats(damage, damageSource, ent);
    }

    public static void sendDamageNumberPacketForTrueDamage(TrainingDummyEntity entity, float damage) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 pos = entity.m_20182_();
        int radius = Math.max(0, JServerConfig.DUMMY_DAMAGE_INDICATOR_RANGE.getValue());
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(pos.m_82520_((double)radius, (double)radius, (double)radius), pos.m_82492_((double)radius, (double)radius, (double)radius)));
        if (!nearbyPlayers.isEmpty()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            new DamageNumberPacket(entity.m_19879_(), damage).write(buf);
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (ResourceLocation)JPacketRegistry.S2C_DAMAGE_NUMBER, (FriendlyByteBuf)buf);
        }
    }

    public static void applyAbsorptionAndStats(float damage, DamageSource damageSource, LivingEntity ent) {
        float f = damage;
        damage = Math.max(damage - ent.m_6103_(), 0.0f);
        ent.m_7911_(ent.m_6103_() - (f - damage));
        if (damage <= 0.0f) {
            return;
        }
        float h = ent.m_21223_();
        LivingEntityInvoker invoker = (LivingEntityInvoker)ent;
        Level world = ent.m_9236_();
        if (ent instanceof Player) {
            NetworkManager.sendToPlayers(JUtils.tracking((Entity)ent), (ResourceLocation)JPacketRegistry.S2C_STAND_HURT, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()).m_130130_(ent.m_19879_()));
        } else {
            world.m_7605_((Entity)ent, (byte)2);
        }
        ent.m_9236_().m_269196_((Entity)ent, damageSource);
        invoker.callPlayHurtSound(damageSource);
        invoker.setLastDamageTaken(damage);
        invoker.setLastDamageSource(damageSource);
        invoker.setLastDamageTime(world.m_46467_());
        ent.f_19802_ = 20;
        ent.f_20916_ = 10;
        ent.f_20917_ = 10;
        ent.m_21153_(h - damage);
        ent.m_21231_().m_289194_(damageSource, damage);
        ent.m_146850_(GameEvent.f_223706_);
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)entity;
            ent.m_6703_(livingAttacker);
        }
        if (ent.m_21224_()) {
            ent.m_6667_(damageSource);
        }
    }

    public static boolean prototypeMatch(AbstractMove<?, ?> a, AbstractMove<?, ?> b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a.getMoveClass() != b.getMoveClass()) {
            return false;
        }
        if (a.isAerialVariant() != b.isAerialVariant()) {
            return false;
        }
        if (a.isCrouchingVariant() != b.isCrouchingVariant()) {
            return false;
        }
        if (a.getCooldown() != b.getCooldown()) {
            return false;
        }
        if (a.getDuration() != b.getDuration()) {
            return false;
        }
        if (a.getWindup() != b.getWindup()) {
            return false;
        }
        if (a instanceof AbstractSimpleAttack) {
            AbstractSimpleAttack aa = (AbstractSimpleAttack)a;
            if (b instanceof AbstractSimpleAttack) {
                AbstractSimpleAttack ab = (AbstractSimpleAttack)b;
                if (aa.getStun() != ab.getStun()) {
                    return false;
                }
                if (aa.getOffset() != ab.getOffset()) {
                    return false;
                }
                if (aa.getKnockback() != ab.getKnockback()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

