/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.api.attack.core.MoveCondition;
import net.arna.jcraft.api.attack.core.MoveConditionType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.util.TriConsumer;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public final class JRegistries {
    private static final RegistrarManager MANAGER = RegistrarManager.get((String)"jcraft");
    public static final Registrar<StandType> STAND_TYPE_REGISTRY = MANAGER.builder(JCraft.id("stand_type"), (Object[])new StandType[0]).syncToClients().build();
    public static final Registrar<SpecType> SPEC_TYPE_REGISTRY = MANAGER.builder(JCraft.id("spec_type"), (Object[])new SpecType[0]).syncToClients().build();
    public static final Registrar<MoveType<?>> MOVE_TYPE_REGISTRY = MANAGER.builder(JCraft.id("move_type"), (Object[])new MoveType[0]).syncToClients().build();
    public static final Registrar<MoveConditionType<?>> MOVE_CONDITION_TYPE_REGISTRY = MANAGER.builder(JCraft.id("move_condition_type"), (Object[])new MoveConditionType[0]).syncToClients().build();
    public static final Registrar<MoveActionType<?>> MOVE_ACTION_TYPE_REGISTRY = MANAGER.builder(JCraft.id("move_action_type"), (Object[])new MoveActionType[0]).syncToClients().build();
    public static final Registrar<TriConsumer<ResourceLocation, Entity, CompoundTag>> EXTRACTOR_REGISTRY = MANAGER.builder(JCraft.id("extractor"), (Object[])new TriConsumer[0]).syncToClients().build();
    public static final Registrar<TriConsumer<ResourceLocation, Entity, CompoundTag>> INJECTOR_REGISTRY = MANAGER.builder(JCraft.id("injector"), (Object[])new TriConsumer[0]).syncToClients().build();
    public static final ResourceKey<Registry<StandType>> STAND_TYPE_REGISTRY_KEY = JRegistries.createKey(STAND_TYPE_REGISTRY);
    public static final ResourceKey<Registry<SpecType>> SPEC_TYPE_REGISTRY_KEY = JRegistries.createKey(SPEC_TYPE_REGISTRY);
    public static final ResourceKey<Registry<MoveType<?>>> MOVE_TYPE_REGISTRY_KEY = JRegistries.createKey(MOVE_TYPE_REGISTRY);
    public static final ResourceKey<Registry<MoveConditionType<?>>> MOVE_CONDITION_TYPE_REGISTRY_KEY = JRegistries.createKey(MOVE_CONDITION_TYPE_REGISTRY);
    public static final ResourceKey<Registry<MoveActionType<?>>> MOVE_ACTION_TYPE_REGISTRY_KEY = JRegistries.createKey(MOVE_ACTION_TYPE_REGISTRY);
    public static final ResourceKey<Registry<TriConsumer<ResourceLocation, Entity, CompoundTag>>> EXTRACTOR_REGISTRY_KEY = JRegistries.createKey(EXTRACTOR_REGISTRY);
    public static final ResourceKey<Registry<TriConsumer<ResourceLocation, Entity, CompoundTag>>> INJECTOR_REGISTRY_KEY = JRegistries.createKey(INJECTOR_REGISTRY);
    public static final Codec<StandType> STAND_TYPE_CODEC = JRegistries.createCodec(STAND_TYPE_REGISTRY);
    public static final Codec<SpecType> SPEC_TYPE_CODEC = JRegistries.createCodec(SPEC_TYPE_REGISTRY);
    public static final Codec<MoveType<?>> MOVE_TYPE_CODEC = JRegistries.createCodec(MOVE_TYPE_REGISTRY);
    public static final Codec<AbstractMove<?, ?>> MOVE_CODEC = MOVE_TYPE_CODEC.dispatch("type", AbstractMove::getMoveType, MoveType::getCodec);
    public static final Codec<MoveConditionType<?>> MOVE_CONDITION_TYPE_CODEC = JRegistries.createCodec(MOVE_CONDITION_TYPE_REGISTRY);
    public static final Codec<MoveCondition<?, ?>> MOVE_CONDITION_CODEC = MOVE_CONDITION_TYPE_CODEC.dispatch("type", MoveCondition::getType, MoveConditionType::getCodec);
    public static final Codec<MoveActionType<?>> MOVE_ACTION_TYPE_CODEC = JRegistries.createCodec(MOVE_ACTION_TYPE_REGISTRY);
    public static final Codec<MoveAction<?, ?>> MOVE_ACTION_CODEC = MOVE_ACTION_TYPE_CODEC.dispatch("type", MoveAction::getType, MoveActionType::getCodec);
    public static final Codec<TriConsumer<ResourceLocation, Entity, CompoundTag>> EXTRACTOR_CODEC = JRegistries.createCodec(EXTRACTOR_REGISTRY);
    public static final Codec<TriConsumer<ResourceLocation, Entity, CompoundTag>> INJECTOR_CODEC = JRegistries.createCodec(INJECTOR_REGISTRY);

    public static void init() {
    }

    public static <T> Codec<T> createCodec(Registrar<T> registrar) {
        return ResourceLocation.f_135803_.flatXmap(rl -> {
            Object t = registrar.get(rl);
            if (t == null) {
                return DataResult.error(() -> "Could not find " + String.valueOf(registrar.key().m_135782_()) + " with ID: " + String.valueOf(rl));
            }
            return DataResult.success((Object)t);
        }, t -> {
            ResourceLocation rl = registrar.getId(t);
            if (rl == null) {
                return DataResult.error(() -> "Could not find ID for " + String.valueOf(registrar.key().m_135782_()) + ": " + String.valueOf(t));
            }
            return DataResult.success((Object)rl);
        });
    }

    private static <T> ResourceKey<Registry<T>> createKey(Registrar<T> registrar) {
        return ResourceKey.m_135788_((ResourceLocation)registrar.key().m_135782_());
    }

    @Nullable
    public static <T> T parseRegistryEntry(Registrar<T> registry, StringReader reader, Predicate<T> filter) {
        ResourceLocation id;
        Object t;
        int i = reader.getCursor();
        while (reader.canRead() && ResourceLocation.m_135816_((char)reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(i, reader.getCursor());
        String namespace = "jcraft";
        String path = string;
        if (string.contains(":")) {
            String[] parts = string.split(":", 2);
            namespace = parts[0];
            path = parts[1];
        }
        if ((t = registry.get(id = new ResourceLocation(namespace, path))) == null || !filter.test(t)) {
            reader.setCursor(i);
            return null;
        }
        return (T)t;
    }

    public static <T> CompletableFuture<Suggestions> listSuggestions(Registrar<T> registry, SuggestionsBuilder builder, Predicate<T> filter) {
        String input = builder.getRemainingLowerCase();
        registry.entrySet().stream().filter(entry -> filter.test(entry.getValue())).map(Map.Entry::getKey).map(ResourceKey::m_135782_).filter(id -> "jcraft".equals(id.m_135827_()) && id.m_135815_().startsWith(input) || id.toString().startsWith(input)).map(ResourceLocation::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private JRegistries() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

