/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack;

import java.util.Set;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.CombatEntityContext;
import net.arna.jcraft.common.ai.CombatInstantContext;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.util.IJCraftComboTracker;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IAttacker<A extends IAttacker<? extends A, S>, S extends Enum<?>> {
    public boolean hasUser();

    public LivingEntity getUser();

    public LivingEntity getUserOrThrow();

    public int getMoveStun();

    public void setMoveStun(int var1);

    default public Level getEntityWorld() {
        return this.getBaseEntity().m_9236_();
    }

    public LivingEntity getBaseEntity();

    public DamageSource getDamageSource();

    public MoveMap<A, S> getMoveMap();

    public boolean initMove(MoveClass var1);

    public boolean canHoldMove(@Nullable MoveInputType var1);

    default public void onUserMoveInput(AbstractMove<?, ? super A> currentMove, MoveInputType type, boolean pressed, boolean moveInitiated) {
        if (moveInitiated && pressed && this.canHoldMove(type)) {
            this.setHoldingType(type);
        }
        if (this.getHoldingType() == type) {
            this.setHolding(pressed);
        }
        if (currentMove != null) {
            currentMove.onUserMoveInput(this.getThis(), type, pressed, moveInitiated);
        }
    }

    public boolean isHolding();

    public void setHolding(boolean var1);

    public MoveInputType getHoldingType();

    public void setHoldingType(MoveInputType var1);

    public boolean canAttack();

    public void cancelMove();

    public void queueMove(MoveInputType var1);

    public boolean isRemote();

    public AbstractMove<?, ? super A> getCurrentMove();

    public void setCurrentMove(AbstractMove<?, ? super A> var1);

    default public void setMove(AbstractMove<?, ? super A> move, S state) {
        this.setCurrentMove(move);
        this.setState(state);
    }

    public S getState();

    public void setState(S var1);

    default public void playAttackerSound(SoundEvent sound, float volume, float pitch) {
        this.getBaseEntity().m_5496_(sound, volume, pitch);
    }

    default public void onPerform(AbstractMove<?, ? super A> move, Set<LivingEntity> targets) {
    }

    public void setPerformedThisTick(boolean var1);

    public boolean performedThisTick();

    public A getThis();

    public MoveUsage getMoveUsage();

    public void executePlan(int var1, AttackerBrainInfo var2, CombatInstantContext var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void plan(int aiLevel, AttackerBrainInfo info, CombatInstantContext combatCtx) {
        if (info.getTicksSinceStateChange() <= (20 - aiLevel) / 4) {
            return;
        }
        CombatEntityContext attackerCtx = combatCtx.getAttackerCtx();
        CombatEntityContext targetCtx = combatCtx.getTargetCtx();
        AttackerBrainInfo.State state = info.getState();
        if (state == AttackerBrainInfo.State.COMBOED) {
            if (attackerCtx.stun() != null && !attackerCtx.blocking()) return;
            state = AttackerBrainInfo.State.DEFENSE;
        } else if (state == AttackerBrainInfo.State.DEFENSE) {
            if (attackerCtx.disadvantage() > targetCtx.disadvantage()) return;
            state = AttackerBrainInfo.State.IDLE;
        }
        double distance = combatCtx.getDistanceBetween();
        if (distance <= this.getEngagementDistance()) {
            if (targetCtx.stun() != null && !targetCtx.blocking()) {
                state = AttackerBrainInfo.State.COMBOING;
            } else if (targetCtx.moveStun() < 1) {
                state = AttackerBrainInfo.State.PRESSURE;
            }
        } else if (info.getTicksSinceStateChange() % 10 == 0 && this.getBaseEntity().m_217043_().m_188499_()) {
            state = JUtils.chooseRandom(this.getBaseEntity().m_217043_(), AttackerBrainInfo.State.APPROACH, AttackerBrainInfo.State.KEEPAWAY, AttackerBrainInfo.State.DISENGAGE);
        }
        info.setState(state);
    }

    default public double getEngagementDistance() {
        return 6.0;
    }

    @Nullable
    default public MoveMap.Entry<A, S> getFirstValidEntry(MoveClass moveClass) {
        boolean hasUser = this.hasUser();
        boolean crouching = hasUser && this.getUserOrThrow().m_6144_();
        boolean aerial = hasUser && !this.getUserOrThrow().m_20096_();
        return this.getMoveMap().getFirstValidEntry(moveClass, this.getThis(), crouching, aerial);
    }

    default public AbstractMove<?, ? super A> getFallbackMove() {
        MoveMap.Entry<A, S> lightEntry = this.getFirstValidEntry(MoveClass.LIGHT);
        if (lightEntry != null) {
            return lightEntry.getMove();
        }
        MoveMap.Entry<A, S> heavyEntry = this.getFirstValidEntry(MoveClass.HEAVY);
        if (heavyEntry == null) {
            JCraft.LOGGER.warn("Couldn't find light or heavy attack entry while running selectAttack on attacker: {}", (Object)this);
            return null;
        }
        return heavyEntry.getMove();
    }

    default public MoveSelectionResult specificMoveSelectionCriterion(AbstractMove<?, ? super A> attack, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        return attack.specificMoveSelectionCriterion(this.getThis(), mob, target, stunTicks, enemyMoveStun, distance, enemyStand, enemyAttack);
    }

    @Nullable
    default public AbstractMove<?, ? super A> doMoveSelection(AttackerBrainInfo info, Mob mob, LivingEntity target, JumpControl mobJumpControl, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack, double distance, int enemyMoveStun, int stunTicks) {
        AbstractMove<?, A> followup;
        StandEntity standEntity;
        AbstractMove<?, A> selectedAttack = this.selectAttack(info, mob instanceof StandEntity && (standEntity = (StandEntity)mob).hasUser() ? JComponentPlatformUtils.getCooldowns(standEntity.getUser()) : JComponentPlatformUtils.getCooldowns((LivingEntity)mob), (LivingEntity)mob, target, stunTicks, enemyMoveStun, distance, enemyStand, enemyAttack);
        if (selectedAttack == null) {
            return null;
        }
        boolean shouldPerformMove = this.getMoveStun() < 1;
        AbstractMove<?, A> currentMove = this.getCurrentMove();
        if (currentMove != null && (followup = currentMove.getFollowup()) != null && Attacks.prototypeMatch(followup, selectedAttack)) {
            shouldPerformMove = true;
        }
        mob.m_20260_(selectedAttack.isCrouchingVariant());
        if (selectedAttack.isAerialVariant()) {
            mob.m_6862_(true);
            mobJumpControl.m_24901_();
            mob.m_6853_(false);
        }
        if (shouldPerformMove) {
            if (selectedAttack.getMoveClass() == null) {
                JCraft.LOGGER.error("Attempting to use move with unset MoveClass: {}, stand: {}", (Object)selectedAttack.getName().getString(), (Object)this);
            } else {
                this.initMove(selectedAttack.getMoveClass());
            }
        } else {
            this.queueMove(MoveInputType.fromMoveClass(selectedAttack.getMoveClass()));
        }
        return selectedAttack;
    }

    @Nullable
    default public AbstractMove<?, ? super A> selectAttack(AttackerBrainInfo info, CommonCooldownsComponent cooldowns, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        AbstractSimpleAttack boxAttack;
        boolean enemyIsAttacking;
        AttackerBrainInfo.State state = info.getState();
        boolean doFinalChecks = true;
        boolean bl = enemyIsAttacking = enemyAttack != null;
        if (enemyIsAttacking && enemyAttack.isCounter()) {
            return null;
        }
        int movesOnCooldown = 0;
        AbstractMove<?, A> selectedAttack = this.getFallbackMove();
        if (selectedAttack == null) {
            return null;
        }
        int selectedAttackInitTime = selectedAttack.getDuration() - selectedAttack.getWindup();
        RandomSource random = mob.m_217043_();
        int aiLevel = info.getAiLevel();
        for (AbstractMove<?, A> attack : this.getMoveMap().asMovesList()) {
            boolean baseSelectionCondition;
            MoveSelectionResult result;
            int windupPoint = attack.getWindupPoint();
            if (attack.isFollowup()) {
                if (this.getCurrentMove() == null || this.getCurrentMove().getFollowup() == null) {
                    continue;
                }
            } else if (cooldowns.getCooldown(attack.getMoveClass().getDefaultCooldownType()) > 0 && attack.getCooldown() != 0) {
                ++movesOnCooldown;
                continue;
            }
            if ((result = this.specificMoveSelectionCriterion(attack, mob, target, stunTicks, enemyMoveStun, distance, enemyStand, enemyAttack)) == MoveSelectionResult.USE) {
                selectedAttack = attack;
                break;
            }
            if (result == MoveSelectionResult.STOP) continue;
            if (attack.getMobilityType() != null) {
                if (stunTicks > 0) continue;
                if (attack.getMobilityType() != MobilityType.HIGHJUMP && distance > 6.0) {
                    if (target.m_20096_()) {
                        if (attack.getMobilityType() == MobilityType.TELEPORT) {
                            mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        } else if (attack.getMobilityType() == MobilityType.DASH) {
                            mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_().m_82520_(0.0, 0.5, 0.0));
                        }
                    }
                    if (attack.getMobilityType() == MobilityType.FLIGHT) {
                        mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    selectedAttack = attack;
                    break;
                }
                if (target.m_20186_() > mob.m_20186_() + 2.0 || enemyAttack != null && enemyStand != null && enemyAttack.hasWindupPassed(enemyStand)) {
                    selectedAttack = attack;
                    break;
                }
            }
            if (enemyIsAttacking && enemyAttack != null && !enemyAttack.isRanged() && attack.isCounter()) {
                if (enemyStand == null || enemyStand.blocking || enemyMoveStun <= 0) continue;
                selectedAttack = attack;
                break;
            }
            boolean isBarrage = attack.isBarrage();
            boolean isCharge = attack.isCharge();
            if (distance <= 5.0) {
                if (isBarrage && !isCharge && !mob.m_142582_((Entity)target) && attack instanceof MainBarrageAttack) {
                    selectedAttack = attack;
                    doFinalChecks = false;
                    break;
                }
                if (distance <= 2.0 && (isBarrage || attack.isMultiHit() && attack.hasWindupPassed(this))) {
                    if (enemyStand != null && enemyStand.blocking) continue;
                    selectedAttack = attack;
                    break;
                }
            }
            if (attack.isRanged() && distance > (double)attack.getDuration() * target.m_21133_(Attributes.f_22279_) * 2.0) {
                mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                selectedAttack = attack;
                break;
            }
            switch (state) {
                case KEEPAWAY: 
                case DISENGAGE: 
                case DEFENSE: {
                    boolean bl2;
                    if (windupPoint <= selectedAttackInitTime || attack.isRanged() || attack.getArmor() > 0) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                case COMBOING: {
                    boolean bl2;
                    if (windupPoint <= stunTicks && windupPoint >= selectedAttackInitTime) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                case PRESSURE: {
                    boolean bl2;
                    if (windupPoint <= selectedAttackInitTime) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = baseSelectionCondition = windupPoint <= stunTicks;
                }
            }
            if ((!baseSelectionCondition || !random.m_188499_()) && !(random.m_188501_() <= 0.05f)) continue;
            if (state == AttackerBrainInfo.State.COMBOING) {
                AbstractSimpleAttack simpleAttack;
                if (attack.isLoopPrevention() && ((IJCraftComboTracker)target).jcraft$comboFromAttackerContains(mob, attack)) continue;
                float chanceToNotUseLaunchAttack = 0.9f;
                if (aiLevel < 15) {
                    chanceToNotUseLaunchAttack -= (float)(15 - aiLevel) * 0.02f;
                }
                if (attack instanceof AbstractSimpleAttack && (simpleAttack = (AbstractSimpleAttack)attack).getStunType() == StunType.LAUNCH && random.m_188501_() <= chanceToNotUseLaunchAttack) continue;
            }
            selectedAttackInitTime = windupPoint;
            selectedAttack = attack;
        }
        if (movesOnCooldown > 5 && JServerConfig.SURVIVAL_CDC.getValue() && !(mob instanceof StandEntity)) {
            cooldowns.cooldownCancel();
        }
        if (doFinalChecks && (selectedAttack.isCounter() ? aiLevel > 3 && stunTicks > 0 : state != AttackerBrainInfo.State.PRESSURE && state != AttackerBrainInfo.State.COMBOING && selectedAttack.getMobilityType() == null && selectedAttack instanceof AbstractSimpleAttack && (boxAttack = (AbstractSimpleAttack)selectedAttack).getHitboxSize() > 0.0f && !selectedAttack.isRanged() && distance > (double)(selectedAttack.getMoveDistance() + boxAttack.getHitboxSize()))) {
            return null;
        }
        return selectedAttack;
    }
}

