/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack;

import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.core.MoveMapImpl;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JCodecUtils;
import org.jetbrains.annotations.Nullable;

public interface MoveMap<A extends IAttacker<? extends A, S>, S extends Enum<?>>
extends Iterable<Entry<A, S>> {
    public static <A extends IAttacker<? extends A, S>, S extends Enum<? extends S>> Codec<MoveMap<A, S>> codecFor(Class<S> stateEnum) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Entry.codecFor(stateEnum).listOf().fieldOf("moves").forGetter(m -> List.copyOf(m.getEntries().values()))).apply((Applicative)instance, MoveMapImpl::new));
    }

    default public Entry<A, S> register(@NonNull MoveClass moveClass, @NonNull AbstractMove<?, ? super A> move) {
        if (moveClass == null) {
            throw new NullPointerException("moveClass is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        return this.register(moveClass, move, null);
    }

    default public Entry<A, S> register(@NonNull MoveClass type, @NonNull AbstractMove<?, ? super A> move, @Nullable S animState) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        return this.register(type, move, type.getDefaultCooldownType(), animState);
    }

    public Entry<A, S> register(@NonNull MoveClass var1, @NonNull AbstractMove<?, ? super A> var2, @Nullable CooldownType var3, @Nullable S var4);

    public void registerImmediate(@NonNull MoveClass var1, @NonNull AbstractMove<?, ? super A> var2, @Nullable S var3);

    public void freeze();

    public boolean isFrozen();

    default public void copyFrom(@NonNull MoveMap<A, S> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.copyFrom(other, false);
    }

    public void copyFrom(@NonNull MoveMap<A, S> var1, boolean var2);

    public Multimap<MoveClass, Entry<A, S>> getEntries();

    public Collection<Entry<A, S>> getEntries(@NonNull MoveClass var1);

    @Nullable
    default public Entry<A, S> getEntry(AbstractMove<?, ? super A> move) {
        return Streams.stream((Iterable)this).filter(entry -> entry.getMove().getOriginalMove() == move).findFirst().orElse(null);
    }

    default public <M extends AbstractMove<?, ?>> Optional<M> findMoveByType(Class<M> moveType) {
        return this.asMovesList().stream().filter(moveType::isInstance).map(moveType::cast).findFirst();
    }

    default public void initiateFollowup(A attacker, AbstractMove<?, ? super A> move, boolean setMoveStun, int chargeTime) {
        Entry<A, S> entry = this.getEntry((AbstractMove<?, ? super A>)move.getOriginalMove());
        if (entry == null || entry.getFollowup() == null) {
            return;
        }
        if (!(entry = entry.getFollowup()).getMove().conditionsMet(attacker)) {
            return;
        }
        move = entry.getMove();
        move.setChargeTime(chargeTime);
        attacker.setMove(move.isCopyOnUse() ? move.copy() : move, entry.getAnimState());
        if (setMoveStun) {
            attacker.setMoveStun(move.getDuration());
        }
    }

    default public void tickMoves(A attacker) {
        this.asMovesList().forEach(move -> move.tick(attacker));
    }

    public List<AbstractMove<?, ? super A>> asMovesList();

    @Nullable
    default public Entry<A, S> getFirstValidEntry(MoveClass type, A attacker, boolean crouching, boolean aerial) {
        return this.getEntries(type).stream().map(entry -> {
            if (crouching && entry.getCrouchingVariant() != null) {
                entry = entry.getCrouchingVariant();
                if (aerial && entry.getAerialVariant() != null) {
                    return entry.getAerialVariant();
                }
                return entry;
            }
            if (aerial && entry.getAerialVariant() != null) {
                entry = entry.getAerialVariant();
                if (crouching && entry.getCrouchingVariant() != null) {
                    return entry.getCrouchingVariant();
                }
                return entry;
            }
            return entry;
        }).filter(entry -> entry.getMove().conditionsMet((IAttacker)attacker)).findFirst().orElse(null);
    }

    public static interface Entry<A extends IAttacker<? extends A, S>, S extends Enum<?>> {
        public static <A extends IAttacker<? extends A, S>, S extends Enum<? extends S>> Codec<Entry<A, S>> codecFor(Class<S> stateEnum) {
            Codec stateCodec = JCodecUtils.createEnumCodec(stateEnum);
            return JCodecUtils.recursive("MoveMap.Entry", self -> RecordCodecBuilder.create(instance -> instance.group((App)MoveClass.CODEC.fieldOf("class").forGetter(Entry::getMoveClass), (App)JRegistries.MOVE_CODEC.fieldOf("move").forGetter(Entry::getMove), (App)CooldownType.CODEC.fieldOf("cooldown_type").forGetter(Entry::getCooldownType), (App)stateCodec.optionalFieldOf("anim_state").forGetter(e -> Optional.ofNullable(e.getAnimState())), (App)self.optionalFieldOf("crouching_variant").forGetter(e -> Optional.ofNullable(e.getCrouchingVariant())), (App)self.optionalFieldOf("aerial_variant").forGetter(e -> Optional.ofNullable(e.getAerialVariant())), (App)self.optionalFieldOf("followup").forGetter(e -> Optional.ofNullable(e.getFollowup()))).apply((Applicative)instance, (moveClass, move, cooldownType, animState, crouchingVariant, aerialVariant, followup) -> new MoveMapImpl.EntryImpl((MoveClass)((Object)((Object)((Object)moveClass))), (AbstractMove<?, ?>)move, (CooldownType)((Object)((Object)((Object)cooldownType))), animState.orElse(null), crouchingVariant.orElse(null), aerialVariant.orElse(null), followup.orElse(null)))));
        }

        public MoveClass getMoveClass();

        public AbstractMove<?, ? super A> getMove();

        public CooldownType getCooldownType();

        public S getAnimState();

        @Nullable
        public Entry<A, S> getCrouchingVariant();

        @Nullable
        public Entry<A, S> getAerialVariant();

        @Nullable
        public Entry<A, S> getFollowup();

        default public Entry<A, S> withCrouchingVariant(S animState) {
            return this.withCrouchingVariant(this.getCooldownType(), animState);
        }

        public Entry<A, S> withCrouchingVariant(CooldownType var1, S var2);

        default public Entry<A, S> withAerialVariant(S animState) {
            return this.withAerialVariant(this.getCooldownType(), animState);
        }

        public Entry<A, S> withAerialVariant(CooldownType var1, S var2);

        default public Entry<A, S> withFollowup(S animState) {
            return this.withFollowup(this.getCooldownType(), animState);
        }

        public Entry<A, S> withFollowup(CooldownType var1, S var2);

        public Entry<A, S> copy();
    }
}

