/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack;

import com.google.common.collect.ImmutableMap;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.arna.jcraft.api.IAttackerType;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.common.attack.core.MoveSetImpl;
import net.arna.jcraft.common.data.MoveSetLoader;
import net.minecraft.resources.ResourceLocation;

public class MoveSetManager {
    private static final Map<ResourceLocation, Map<String, MoveSet<?, ?>>> MOVE_SETS = new HashMap();

    private MoveSetManager() {
    }

    public static Map<ResourceLocation, Map<String, MoveSet<?, ?>>> getMoveSets() {
        return MOVE_SETS.entrySet().stream().map(e -> Map.entry((ResourceLocation)e.getKey(), Collections.unmodifiableMap((Map)e.getValue()))).collect(ImmutableMap::builder, ImmutableMap.Builder::put, (b1, b2) -> b1.putAll((Map)b2.build())).build();
    }

    public static boolean hasMoveSets(IAttackerType type) {
        return !MOVE_SETS.getOrDefault(type.getId(), Collections.emptyMap()).isEmpty();
    }

    public static <A extends IAttacker<? extends A, S>, S extends Enum<S>> Map<String, MoveSet<A, S>> get(IAttackerType type) {
        return MoveSetManager.get(type.getId());
    }

    public static <A extends IAttacker<? extends A, S>, S extends Enum<S>> Map<String, MoveSet<A, S>> get(ResourceLocation typeLoc) {
        return ImmutableMap.copyOf(MOVE_SETS.getOrDefault(typeLoc, Collections.emptyMap()));
    }

    public static <A extends IAttacker<? extends A, S>, S extends Enum<S>> MoveSet<A, S> get(IAttackerType type, String name) {
        return MoveSetManager.get(type.getId(), name);
    }

    public static <A extends IAttacker<? extends A, S>, S extends Enum<S>> MoveSet<A, S> get(ResourceLocation typeLoc, String name) {
        return (MoveSet)MOVE_SETS.getOrDefault(typeLoc, Collections.emptyMap()).get(name);
    }

    public static <A extends IAttacker<? extends A, S>, S extends Enum<S>> MoveSet<A, S> create(RegistrySupplier<? extends IAttackerType> type, Consumer<MoveMap<A, S>> register, Class<S> stateClass) {
        return MoveSetManager.create(type, "default", register, stateClass);
    }

    public static <A extends IAttacker<? extends A, S>, S extends Enum<S>> MoveSet<A, S> create(RegistrySupplier<? extends IAttackerType> type, String name, Consumer<MoveMap<A, S>> register, Class<S> stateClass) {
        if (MOVE_SETS.getOrDefault(type.getId(), Collections.emptyMap()).containsKey(name)) {
            throw new IllegalArgumentException("Move set " + name + " for type " + String.valueOf(type.getId()) + "already exists");
        }
        MoveSetImpl<A, S> moveSet = new MoveSetImpl<A, S>(type, name, register, stateClass);
        MOVE_SETS.computeIfAbsent(type.getId(), k -> new HashMap()).put(name, moveSet);
        MoveSetLoader.attemptLoad(moveSet);
        return moveSet;
    }
}

