/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack;

import com.mojang.serialization.Codec;
import java.util.Optional;

public class StateContainer<S extends Enum<S>> {
    public static final Codec<StateContainer<?>> CODEC = Codec.STRING.xmap(StateContainer::new, stateContainer -> stateContainer.valueName);
    private final String valueName;
    private Optional<S> value;

    private StateContainer(String valueName) {
        this(valueName, Optional.empty());
    }

    private StateContainer(String valueName, Optional<S> value) {
        this.valueName = valueName;
        this.value = value;
    }

    public static <S extends Enum<S>> StateContainer<S> of(S value) {
        return new StateContainer<S>(value.name(), Optional.of(value));
    }

    public S getValue() {
        return (S)((Enum)this.value.orElseThrow(() -> new IllegalStateException("StateContainer has not yet been configured.")));
    }

    public void configure(Class<S> stateClass) {
        this.value = Optional.of(Enum.valueOf(stateClass, this.valueName));
    }

    public StateContainer<S> copy() {
        return new StateContainer<S>(this.valueName, this.value);
    }
}

