/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.util.JCodecUtils;
import net.minecraft.world.entity.LivingEntity;

public abstract class RunMoment {
    private static final BiMap<String, RunMomentType<?>> BY_NAME = HashBiMap.create();
    public static RunMoment NEVER = RunMoment.create("never", RunMomentType.unit(() -> NEVER));
    public static RunMoment AT_INIT = RunMoment.create("at_init", RunMomentType.unit(() -> AT_INIT));
    public static RunMoment ON_STRIKE = RunMoment.create("on_strike", RunMomentType.unit(() -> ON_STRIKE));
    public static RunMoment ON_HIT = RunMoment.create("on_hit", RunMomentType.unit(() -> ON_HIT));
    public static RunMoment AT_END = RunMoment.create("on_end", RunMomentType.unit(() -> AT_END));
    public static RunMoment EVERY_TICK = RunMoment.create("every_tick", RunMomentType.unit(() -> EVERY_TICK));
    public static MapCodec<RunMoment> CODEC;
    private final RunMomentType<?> type;

    private static RunMoment create(String name, RunMomentType<?> type) {
        return RunMoment.create(name, type, (move, attacker, user, tick, targets) -> false);
    }

    private static RunMoment create(String name, RunMomentType<?> type, final RunMomentFunc func) {
        RunMoment runMoment = new RunMoment(type){

            @Override
            public boolean shouldRun(AbstractMove<?, ?> move, IAttacker<?, ?> attacker, LivingEntity user, int tick, @Nullable Set<LivingEntity> targets) {
                return func.shouldRun(move, attacker, user, tick, targets);
            }
        };
        BY_NAME.put((Object)name, type);
        return runMoment;
    }

    public static RunMoment atTick(int tick) {
        return new TickRunMoment(tick);
    }

    public abstract boolean shouldRun(AbstractMove<?, ?> var1, IAttacker<?, ?> var2, LivingEntity var3, int var4, @Nullable Set<LivingEntity> var5);

    private RunMoment(RunMomentType<?> type) {
        this.type = type;
    }

    public RunMomentType<?> getType() {
        return this.type;
    }

    static {
        BY_NAME.put((Object)"at_tick", (Object)TickRunMomentType.INSTANCE);
        CODEC = JCodecUtils.codecFromMap(Codec.STRING, BY_NAME).dispatchMap("run", RunMoment::getType, RunMomentType::getCodec);
    }

    @FunctionalInterface
    private static interface RunMomentFunc {
        public boolean shouldRun(AbstractMove<?, ?> var1, IAttacker<?, ?> var2, LivingEntity var3, int var4, @Nullable Set<LivingEntity> var5);
    }

    public static interface RunMomentType<T extends RunMoment> {
        public Codec<T> getCodec();

        public static <T extends RunMoment> RunMomentType<T> unit(Supplier<T> runMoment) {
            return () -> Codec.unit((Supplier)runMoment);
        }
    }

    private static class TickRunMoment
    extends RunMoment {
        private final int tick;

        public TickRunMoment(int tick) {
            super(TickRunMomentType.INSTANCE);
            this.tick = tick;
        }

        @Override
        public boolean shouldRun(AbstractMove<?, ?> move, IAttacker<?, ?> attacker, LivingEntity user, int tick, @Nullable Set<LivingEntity> targets) {
            return tick < 0 ? attacker.getMoveStun() == -tick - 1 : tick == this.tick;
        }
    }

    private static class TickRunMomentType
    implements RunMomentType<TickRunMoment> {
        public static final TickRunMomentType INSTANCE = new TickRunMomentType();
        private static final Codec<TickRunMoment> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tick").forGetter(runMoment -> runMoment.tick)).apply((Applicative)instance, TickRunMoment::new));

        private TickRunMomentType() {
        }

        @Override
        public Codec<TickRunMoment> getCodec() {
            return codec;
        }
    }
}

