/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.enums;

import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Random;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JCodecUtils;
import net.minecraft.network.chat.Component;

public enum MoveClass {
    LIGHT(CooldownType.STAND_LIGHT, "key.attack"),
    HEAVY(CooldownType.STAND_HEAVY),
    BARRAGE(CooldownType.STAND_BARRAGE),
    SPECIAL1(CooldownType.STAND_SP1),
    SPECIAL2(CooldownType.STAND_SP2),
    SPECIAL3(CooldownType.STAND_SP3),
    ULTIMATE(CooldownType.STAND_ULTIMATE),
    UTILITY(CooldownType.UTILITY),
    STANDBY_OFF(CooldownType.STAND_STANDBY),
    TOSS(CooldownType.STAND_TOSS);

    public static final Codec<MoveClass> CODEC;
    private static final Random random;
    private final Component friendlyName;
    private final Component key;
    private final CooldownType defaultCooldownType;
    private final String name = this.name().toLowerCase(Locale.ROOT);

    private MoveClass(CooldownType defaultCooldownType) {
        this(defaultCooldownType, null);
    }

    private MoveClass(CooldownType defaultCooldownType, String key) {
        this.friendlyName = Component.m_237115_((String)("jcraft.movetype." + this.name().toLowerCase(Locale.ROOT)));
        this.key = Component.m_237117_((String)(key == null ? "key.jcraft." + this.name().toLowerCase(Locale.ROOT) : key));
        this.defaultCooldownType = defaultCooldownType;
    }

    public static MoveClass randomMoveType() {
        return MoveClass.values()[random.nextInt(MoveClass.values().length)];
    }

    public Component getFriendlyName() {
        return this.friendlyName;
    }

    public Component getKey() {
        return this.key;
    }

    public CooldownType getDefaultCooldownType() {
        return this.defaultCooldownType;
    }

    public String getName() {
        return this.name;
    }

    static {
        CODEC = JCodecUtils.createEnumCodec(MoveClass.class);
        random = new Random();
    }
}

