/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.arna.jcraft.api.attack.enums.MoveClass;
import org.jetbrains.annotations.Nullable;

public enum MoveInputType {
    LIGHT(MoveClass.LIGHT, true),
    HEAVY(MoveClass.HEAVY, false, MoveClass.TOSS, true),
    BARRAGE(MoveClass.BARRAGE),
    SPECIAL1(MoveClass.SPECIAL1),
    SPECIAL2(MoveClass.SPECIAL2),
    SPECIAL3(MoveClass.SPECIAL3),
    ULTIMATE(MoveClass.ULTIMATE),
    UTILITY(MoveClass.UTILITY, MoveClass.STANDBY_OFF),
    STAND_SUMMON(null);

    public static final int types = 9;
    private static final AtomicReference<Object> fromMoveType;
    @Nullable
    private final MoveClass moveClass;
    private final boolean holdable;
    @Nullable
    private final MoveClass moveClassStandby;
    private final boolean holdableStandby;

    private MoveInputType(MoveClass moveClass) {
        this(moveClass, false);
    }

    private MoveInputType(MoveClass moveClass, boolean holdable) {
        this(moveClass, holdable, null, false);
    }

    private MoveInputType(MoveClass moveClass, MoveClass moveClassStandby) {
        this(moveClass, false, moveClassStandby, false);
    }

    private MoveInputType(@Nullable MoveClass moveClass, boolean holdable, MoveClass moveClassStandby, boolean holdableStandby) {
        this.moveClass = moveClass;
        this.holdable = holdable;
        this.moveClassStandby = moveClassStandby;
        this.holdableStandby = holdable;
    }

    public MoveClass getMoveClass(boolean standby) {
        if (standby) {
            return this.moveClassStandby;
        }
        return this.moveClass;
    }

    public boolean isHoldable(boolean standby) {
        if (standby) {
            return this.holdableStandby;
        }
        return this.holdable;
    }

    @Nullable
    public static MoveInputType fromMoveClass(MoveClass moveClass) {
        return MoveInputType.getFromMoveType().get((Object)moveClass);
    }

    @Nullable
    public MoveClass getMoveClass() {
        return this.moveClass;
    }

    public boolean isHoldable() {
        return this.holdable;
    }

    @Nullable
    public MoveClass getMoveClassStandby() {
        return this.moveClassStandby;
    }

    public boolean isHoldableStandby() {
        return this.holdableStandby;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<MoveClass, MoveInputType> getFromMoveType() {
        Object $value = fromMoveType.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = fromMoveType;
            synchronized (atomicReference) {
                $value = fromMoveType.get();
                if ($value == null) {
                    Map actualValue = (Map)Arrays.stream(MoveInputType.values()).filter(v -> v.getMoveClass() != null).collect(ImmutableMap.toImmutableMap(MoveInputType::getMoveClass, v -> v));
                    $value = actualValue == null ? fromMoveType : actualValue;
                    fromMoveType.set($value);
                }
            }
        }
        return (Map)($value == fromMoveType ? null : $value);
    }

    static {
        fromMoveType = new AtomicReference();
    }
}

