/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function10;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.core.data.AttackMoveExtras;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractBarrageAttack<T extends AbstractBarrageAttack<T, A>, A extends IAttacker<? extends A, ?>>
extends AbstractSimpleAttack<T, A> {
    private final int interval;
    protected boolean inflictsSlowness = true;
    private boolean stunWindsUp = true;
    private final int originalStun;

    protected AbstractBarrageAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.barrage = true;
        this.interval = interval;
        this.withBlockStun(3);
        this.withStunType(StunType.WINDED);
        this.withHitSpark(null);
        this.originalStun = stun;
    }

    @NonNull
    public T withoutSlowness() {
        this.inflictsSlowness = false;
        return (T)((AbstractBarrageAttack)this.getThis());
    }

    @Override
    public boolean shouldPerform(A attacker, int moveStun) {
        return attacker.hasUser() && this.hasWindupPassed((IAttacker<?, ?>)attacker, moveStun) && (this.getDuration() - this.getWindup() - moveStun) % this.interval == 0;
    }

    public T withNoStunWindup() {
        this.stunWindsUp = false;
        return (T)((AbstractBarrageAttack)this.getThis());
    }

    @Override
    public void activeTick(A attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (this.stunWindsUp) {
            float twoThirdsDuration = 0.75f * (float)this.getDuration();
            if ((float)moveStun > twoThirdsDuration) {
                int newStun = (int)Mth.m_14116_((float)((float)this.originalStun / ((float)moveStun - twoThirdsDuration))) + this.originalStun / this.interval;
                this.withStun(newStun);
            } else {
                this.withStun(this.originalStun);
            }
        }
        if (attacker.hasUser() && this.inflictsSlowness && !attacker.isRemote()) {
            attacker.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 2, true, false));
        }
    }

    @Override
    protected Set<LivingEntity> validateTargets(A attacker, Set<LivingEntity> targets) {
        if (!(attacker instanceof StandEntity)) {
            return targets;
        }
        StandEntity stand = (StandEntity)attacker;
        for (LivingEntity target : targets) {
            LivingEntity livingEntity;
            ServerPlayer serverPlayer;
            StandEntity<?, ?> targetStand = JUtils.getStand(target);
            Vec3 forwardPos = stand.m_20154_();
            forwardPos = new Vec3(stand.m_20185_() + forwardPos.f_82479_, stand.m_20186_() + forwardPos.f_82480_, stand.m_20189_() + forwardPos.f_82481_);
            if (targetStand == null || targetStand == attacker || targetStand.getCurrentMove() == null || !targetStand.getCurrentMove().isBarrage() || targetStand.m_20238_(forwardPos) > 4.0) continue;
            this.onClash(attacker.getUserOrThrow());
            this.onClash(target);
            if (target instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)target;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(null, SoundSource.PLAYERS));
            }
            if ((livingEntity = attacker.getUserOrThrow()) instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingEntity;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(null, SoundSource.PLAYERS));
            }
            stand.cancelMove();
            targetStand.cancelMove();
            Vec3 midPos = attacker.getBaseEntity().m_20182_().m_82490_(0.5).m_82549_(targetStand.m_20182_().m_82490_(0.5));
            attacker.getEntityWorld().m_6263_(null, midPos.f_82479_, midPos.f_82480_, midPos.f_82481_, (SoundEvent)JSoundRegistry.IMPACT_1.get(), SoundSource.NEUTRAL, 1.0f, 0.5f);
            return Set.of();
        }
        return targets;
    }

    protected void onClash(LivingEntity entity) {
        entity.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
        entity.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.DAZED.get(), 10, 3, true, false));
    }

    @Override
    public int getBlow(A attacker) {
        int tick = this.getDuration() - attacker.getMoveStun();
        return tick <= this.getWindup() ? 0 : (tick - this.getWindup()) / this.getInterval();
    }

    @Override
    protected void createShockwaves(A attacker, LivingEntity user) {
        LivingEntity attackerEntity = attacker.getBaseEntity();
        RandomSource random = attackerEntity.m_217043_();
        Vec3 shockwavePos = attackerEntity.m_20182_().m_82520_(random.m_188583_() / 3.0, random.m_188583_() / 3.0, random.m_188583_() / 3.0);
        Vec3 rotVec = user.m_20154_();
        shockwavePos = shockwavePos.m_82549_(rotVec);
        shockwavePos = shockwavePos.m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, (double)attackerEntity.m_20206_() / 1.8 - (double)this.getOffset(), 0.0), GravityChangerAPI.getGravityDirection((Entity)user)));
        JComponentPlatformUtils.getShockwaveHandler(attacker.getEntityWorld()).addShockwave(shockwavePos, user.m_20154_(), this.getDamage() / 1.5f);
    }

    @Override
    @NonNull
    protected T copyExtras(@NonNull T base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        AbstractBarrageAttack cast = (AbstractBarrageAttack)super.copyExtras(base);
        cast.inflictsSlowness = this.inflictsSlowness;
        return base;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isInflictsSlowness() {
        return this.inflictsSlowness;
    }

    public int getOriginalStun() {
        return this.originalStun;
    }

    public boolean isStunWindsUp() {
        return this.stunWindsUp;
    }

    protected static abstract class Type<M extends AbstractBarrageAttack<? extends M, ?>>
    extends AbstractSimpleAttack.Type<M> {
        protected Type() {
        }

        protected RecordCodecBuilder<M, Integer> interval() {
            return Codec.INT.fieldOf("interval").forGetter(AbstractBarrageAttack::getInterval);
        }

        protected RecordCodecBuilder<M, Boolean> inflictsSlowness() {
            return Codec.BOOL.optionalFieldOf("inflicts_slowness", (Object)true).forGetter(AbstractBarrageAttack::isInflictsSlowness);
        }

        protected Products.P13<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, Integer, Boolean> barrageDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.interval(), this.inflictsSlowness());
        }

        protected App<RecordCodecBuilder.Mu<M>, M> barrageDefault(RecordCodecBuilder.Instance<M> instance, Function10<Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, Integer, M> function) {
            return this.barrageDefault(instance).apply(instance, this.applyAttackExtras((cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval, inflictsSlowness) -> {
                AbstractBarrageAttack move = (AbstractBarrageAttack)function.apply(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
                if (!inflictsSlowness.booleanValue()) {
                    move.withoutSlowness();
                }
                return move;
            }));
        }
    }
}

