/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class AbstractChargeAttack<T extends AbstractChargeAttack<T, A, S>, A extends StandEntity<A, S>, S extends Enum<S>>
extends AbstractSimpleAttack<T, A> {
    protected final S hitAnimState;

    protected AbstractChargeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, S hitAnimState) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitAnimState = hitAnimState;
        this.charge = true;
        this.ranged = true;
        this.withBackstab(false);
    }

    @Override
    public boolean shouldPerform(A attacker, int moveStun) {
        return this.hasWindupPassed((IAttacker<?, ?>)attacker, moveStun);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (!targets.isEmpty()) {
            this.endCharge(attacker);
        }
        return targets;
    }

    protected void endCharge(A attacker) {
        ((StandEntity)attacker).setCurrentMove(null);
        ((StandEntity)attacker).setMoveStun(10);
        ((StandEntity)attacker).setState(this.hitAnimState);
    }

    @Override
    public void activeTick(A attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        this.tickChargeAttack((StandEntity<A, S>)attacker, this.shouldPerform(attacker, moveStun), this.getMoveDistance(), this.getWindupPoint());
    }

    protected Vec3 advanceChargePos(StandEntity<?, ?> attacker, float moveDistance, int windupPoint) {
        return attacker.m_20182_().m_82549_(AbstractChargeAttack.getRotVec(attacker).m_82490_((double)(moveDistance / (float)windupPoint)));
    }

    protected void tickChargeAttack(StandEntity<A, S> attacker, boolean shouldPerform, float moveDistance, int windupPoint) {
        if (shouldPerform) {
            Vec3 newPos = this.advanceChargePos(attacker, moveDistance, windupPoint);
            attacker.setFreePos(new Vector3f((float)newPos.f_82479_, (float)newPos.f_82480_, (float)newPos.f_82481_));
            attacker.setFree(true);
        } else {
            AbstractChargeAttack.prepDetachmentMove(attacker, attacker.getUserOrThrow());
        }
    }

    public static void prepDetachmentMove(StandEntity<?, ?> attacker, LivingEntity user) {
        attacker.m_146884_(user.m_20182_());
        attacker.m_5616_(user.m_6080_());
        attacker.m_5618_(user.m_6080_());
        attacker.setRotationOffset(90.0f);
    }

    @Override
    protected Vec3 getOffsetForwardPos(A attacker, Vec3 offsetHeightPos, Vec3 upVec, Vec3 rotVec) {
        return offsetHeightPos.m_82549_(rotVec);
    }

    public S getHitAnimState() {
        return this.hitAnimState;
    }
}

