/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.stand.StandEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractCounterAttack<T extends AbstractCounterAttack<T, A>, A extends IAttacker<? extends A, ?>>
extends AbstractMove<T, A> {
    protected AbstractCounterAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.counter = true;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        StandEntity stand;
        if (attacker instanceof StandEntity && (stand = (StandEntity)attacker).isFree()) {
            stand.setFree(false);
        }
        return Set.of();
    }

    public abstract void whiff(@NonNull A var1, @NonNull LivingEntity var2);

    public void counter(@NonNull A attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        attacker.setMoveStun(0);
        attacker.setCurrentMove(null);
    }
}

