/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function13;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.StateContainerHolder;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.core.data.AttackMoveExtras;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractGrabAttack<T extends AbstractGrabAttack<T, A, S>, A extends IAttacker<A, S>, S extends Enum<S>>
extends AbstractSimpleAttack<T, A>
implements StateContainerHolder<S> {
    private final AbstractMove<?, ? super A> hitMove;
    private final StateContainer<S> hitState;
    private final int grabDuration;
    private final double grabOffset;

    protected AbstractGrabAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super A> hitMove, StateContainer<S> hitState) {
        this(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMove, hitState, hitMove.getWindup() - 1, 1.0);
    }

    protected AbstractGrabAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super A> hitMove, StateContainer<S> hitState, int grabDuration, double grabOffset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.grab = true;
        this.hitMove = hitMove;
        this.hitState = hitState.copy();
        this.grabDuration = grabDuration;
        this.grabOffset = grabOffset;
        this.withHitAnimation(null);
        this.withStunType(StunType.UNBURSTABLE);
        this.withOverrideStun();
        this.withBlockableType(BlockableType.NON_BLOCKABLE);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            return targets;
        }
        boolean unblockable = this.getBlockableType() == BlockableType.NON_BLOCKABLE;
        boolean anyHit = false;
        for (LivingEntity target : targets) {
            if (JUtils.isBlocking(target) && !unblockable) continue;
            StandEntity<?, ?> stand = JUtils.getStand(target);
            if (stand != null) {
                stand.blocking = false;
            }
            JUtils.cancelMoves(target);
            JComponentPlatformUtils.getGrab(target).startGrab((Entity)attacker.getBaseEntity(), this.grabDuration, this.grabOffset);
            JUtils.setVelocity((Entity)target, 0.0, 0.0, 0.0);
            anyHit = true;
        }
        if (anyHit) {
            attacker.setMove(this.hitMove, this.hitState.getValue());
        }
        return targets;
    }

    @Override
    public void configureStateContainers(Class<S> stateClass) {
        this.hitState.configure(stateClass);
    }

    public AbstractMove<?, ? super A> getHitMove() {
        return this.hitMove;
    }

    public StateContainer<S> getHitState() {
        return this.hitState;
    }

    public int getGrabDuration() {
        return this.grabDuration;
    }

    public double getGrabOffset() {
        return this.grabOffset;
    }

    protected static abstract class Type<M extends AbstractGrabAttack<? extends M, ?, ?>>
    extends AbstractSimpleAttack.Type<M> {
        protected Type() {
        }

        protected <A extends IAttacker<? extends A, ?>> RecordCodecBuilder<M, AbstractMove<?, ? super A>> hitMove() {
            return JRegistries.MOVE_CODEC.fieldOf("hit_move").xmap(move -> move, move -> move).forGetter(atk -> atk.getHitMove());
        }

        protected <S extends Enum<S>> RecordCodecBuilder<M, StateContainer<S>> hitState() {
            return StateContainer.CODEC.xmap(s -> s, s -> s).fieldOf("hit_state").forGetter(atk -> atk.getHitState());
        }

        protected RecordCodecBuilder<M, Integer> grabDuration() {
            return Codec.INT.fieldOf("grab_duration").forGetter(AbstractGrabAttack::getGrabDuration);
        }

        protected RecordCodecBuilder<M, Double> grabOffset() {
            return Codec.DOUBLE.optionalFieldOf("grab_offset", (Object)1.0).forGetter(AbstractGrabAttack::getGrabOffset);
        }

        protected <A extends IAttacker<? extends A, ?>, S extends Enum<S>> Products.P15<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, AbstractMove<?, ? super A>, StateContainer<S>, Integer, Double> grabFullDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMove(), this.hitState(), this.grabDuration(), this.grabOffset());
        }

        protected <A extends IAttacker<? extends A, ?>, S extends Enum<S>> App<RecordCodecBuilder.Mu<M>, M> grabFullDefault(RecordCodecBuilder.Instance<M> instance, Function13<Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, AbstractMove<?, ? super A>, StateContainer<S>, Integer, Double, M> function) {
            return this.grabFullDefault(instance).apply(instance, this.applyAttackExtras(function));
        }

        protected <A extends IAttacker<? extends A, ?>, S extends Enum<S>> Products.P13<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, AbstractMove<?, ? super A>, StateContainer<S>> grabDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMove(), this.hitState());
        }

        protected <A extends IAttacker<? extends A, ?>, S extends Enum<S>> App<RecordCodecBuilder.Mu<M>, M> grabDefault(RecordCodecBuilder.Instance<M> instance, Function11<Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, AbstractMove<?, ? super A>, StateContainer<S>, M> function) {
            return this.grabDefault(instance).apply(instance, this.applyAttackExtras(function));
        }
    }
}

