/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractHoldableMove<T extends AbstractHoldableMove<T, A>, A extends IAttacker<A, ?>>
extends AbstractMove<T, A> {
    protected boolean setMoveStun = false;
    private final int minimumCharge;
    private int chargeTime = 0;

    protected AbstractHoldableMove(int cooldown, int windup, int duration, float moveDistance, int minimumCharge) {
        super(cooldown, windup, duration, moveDistance);
        this.minimumCharge = minimumCharge;
        this.withHoldable();
    }

    public T shouldSetMoveStun() {
        this.setMoveStun = true;
        return (T)((AbstractHoldableMove)this.getThis());
    }

    @Override
    public void onInitiate(A attacker) {
        super.onInitiate(attacker);
        this.chargeTime = 0;
    }

    private boolean sameMove(A attacker, MoveInputType type) {
        if (attacker instanceof StandEntity) {
            StandEntity stand = (StandEntity)attacker;
            return type.getMoveClass(stand.isStandby()) == this.getMoveClass();
        }
        return type.getMoveClass() == this.getMoveClass();
    }

    @Override
    public void activeTick(A attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        boolean charged = moveStun <= this.getDuration() - this.minimumCharge;
        ++this.chargeTime;
        if (moveStun == 1 || charged && (!attacker.isHolding() || !this.sameMove(attacker, attacker.getHoldingType()))) {
            this.followUp(attacker);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        return Set.of();
    }

    @Override
    public void onUserMoveInput(A attacker, MoveInputType type, boolean pressed, boolean moveInitiated) {
        if (!pressed && moveInitiated && this.sameMove(attacker, type)) {
            this.onRelease(attacker);
        }
    }

    protected void onRelease(A attacker) {
        if (attacker.getMoveStun() <= this.getDuration() - this.minimumCharge) {
            this.followUp(attacker);
        }
    }

    private void followUp(A attacker) {
        attacker.getMoveMap().initiateFollowup(attacker, (AbstractMove<?, A>)this.getThis(), this.setMoveStun, this.chargeTime);
    }

    public boolean isSetMoveStun() {
        return this.setMoveStun;
    }

    public int getMinimumCharge() {
        return this.minimumCharge;
    }

    @Override
    public int getChargeTime() {
        return this.chargeTime;
    }

    protected static abstract class Type<M extends AbstractHoldableMove<? extends M, ?>>
    extends AbstractMove.Type<M> {
        protected Type() {
        }

        protected RecordCodecBuilder<M, Integer> minimumCharge() {
            return Codec.INT.fieldOf("minimum_charge").forGetter(AbstractHoldableMove::getMinimumCharge);
        }

        protected RecordCodecBuilder<M, Boolean> setMoveStun() {
            return Codec.BOOL.optionalFieldOf("set_move_stun", (Object)true).forGetter(AbstractHoldableMove::isSetMoveStun);
        }

        protected Products.P7<RecordCodecBuilder.Mu<M>, BaseMoveExtras, Integer, Integer, Integer, Float, Integer, Boolean> holdableDefault(RecordCodecBuilder.Instance<M> instance) {
            return this.baseDefault(instance).and(instance.group(this.minimumCharge(), this.setMoveStun()));
        }

        protected App<RecordCodecBuilder.Mu<M>, M> holdableDefault(RecordCodecBuilder.Instance<M> instance, Function5<Integer, Integer, Integer, Float, Integer, M> function) {
            return this.holdableDefault(instance).apply(instance, this.applyExtras((cooldown, windup, duration, moveDistance, minimumCharge, setMoveStun) -> {
                AbstractHoldableMove move = (AbstractHoldableMove)function.apply(cooldown, windup, duration, moveDistance, minimumCharge);
                if (setMoveStun.booleanValue()) {
                    move.shouldSetMoveStun();
                }
                return move;
            }));
        }
    }
}

