/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function10;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function12;
import com.mojang.datafixers.util.Function13;
import com.mojang.datafixers.util.Function14;
import com.mojang.datafixers.util.Function15;
import com.mojang.datafixers.util.Function16;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveCondition;
import net.arna.jcraft.api.attack.core.RunMoment;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.actions.PlaySoundAction;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.ExtraProducts;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMove<T extends AbstractMove<T, A>, A extends IAttacker<? extends A, ?>> {
    private final List<MoveCondition<?, ? super A>> conditions = new ArrayList();
    private final List<MoveAction<?, ? super A>> actions = new ArrayList();
    private T originalMove = this.getThis();
    private MoveClass moveClass;
    private int cooldown;
    private int windup;
    private int duration;
    private float moveDistance;
    private Enum<?> animation;
    @NonNull
    private Component name = Component.m_237119_();
    @NonNull
    private Component description = Component.m_237119_();
    @Nullable
    private AbstractMove<?, ? super A> crouchingVariant;
    @Nullable
    private AbstractMove<?, ? super A> aerialVariant;
    @Nullable
    private AbstractMove<?, ? super A> followup;
    private boolean isCrouchingVariant;
    private boolean isAerialVariant;
    private boolean isFollowup;
    private int armor;
    private IntObjectPair<AbstractMove<?, ? super A>> finisher;
    protected MobilityType mobilityType;
    private Boolean isHoldable;
    private boolean loopPrevention = true;
    private OptionalInt followupFrame = OptionalInt.empty();
    protected boolean ranged;
    protected boolean barrage;
    protected boolean multiHit;
    protected boolean charge;
    protected boolean counter;
    protected boolean dash;
    protected boolean grab;
    protected boolean copyOnUse;
    protected boolean mayHitUser;
    protected boolean manualCooldown;
    private boolean copiedExtras;
    private int chargeTime = 0;

    protected AbstractMove(int cooldown, int windup, int duration, float moveDistance) {
        this.cooldown = cooldown;
        this.windup = windup;
        this.duration = duration;
        this.moveDistance = moveDistance;
    }

    public T withCooldown(int cooldown) {
        this.cooldown = cooldown;
        return this.getThis();
    }

    public T withWindup(int windup) {
        this.windup = windup;
        return this.getThis();
    }

    public T withAnim(Enum<?> state) {
        this.animation = state;
        return this.getThis();
    }

    public T withDuration(int duration) {
        this.duration = duration;
        return this.getThis();
    }

    public T withMoveDistance(float moveDistance) {
        this.moveDistance = moveDistance;
        return this.getThis();
    }

    public T withInfo(@NonNull Component name, @NonNull Component description) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        return this.getThis();
    }

    public T withCrouchingVariant(AbstractMove<?, ? super A> crouchingVariant) {
        if (this.isCrouchingVariant) {
            throw new IllegalStateException("Can't assign a crouching variant to a crouching variant.");
        }
        if (crouchingVariant.getCrouchingVariant() != null) {
            throw new IllegalArgumentException("Given move has a crouching variant. Crouching variants cannot have crouching variants.");
        }
        this.crouchingVariant = crouchingVariant.copy();
        this.crouchingVariant.isCrouchingVariant = true;
        return this.getThis();
    }

    public T withAerialVariant(AbstractMove<?, ? super A> aerialVariant) {
        if (this.isAerialVariant) {
            throw new IllegalStateException("Can't assign an aerial variant to an aerial variant.");
        }
        this.aerialVariant = aerialVariant.copy();
        this.aerialVariant.isAerialVariant = true;
        return this.getThis();
    }

    public T noLoopPrevention() {
        this.loopPrevention = false;
        return this.getThis();
    }

    public T markRanged() {
        this.ranged = true;
        return this.getThis();
    }

    public T allowHitUser() {
        this.mayHitUser = true;
        return this.getThis();
    }

    public T withFollowup(AbstractMove<?, ? super A> followup) {
        this.followup = followup.copy();
        this.followup.isFollowup = true;
        return this.getThis();
    }

    public T withArmor(int armor) {
        this.armor = armor;
        return this.getThis();
    }

    public T withHyperArmor() {
        return this.withArmor(Integer.MAX_VALUE);
    }

    public T withMobilityType(MobilityType mobilityType) {
        this.mobilityType = mobilityType;
        return this.getThis();
    }

    public T withHoldable() {
        return this.withHoldable(true);
    }

    public T withCondition(MoveCondition<?, ? super A> condition) {
        this.conditions.add(condition);
        return this.getThis();
    }

    public T withConditions(Collection<MoveCondition<?, ? super A>> conditions) {
        this.conditions.addAll(conditions);
        return this.getThis();
    }

    @ApiStatus.Internal
    public T withConditionsRaw(Collection<MoveCondition<?, ?>> conditions) {
        this.conditions.addAll(conditions);
        return this.getThis();
    }

    public T withAction(MoveAction<?, ? super A> action) {
        this.actions.add(action);
        return this.getThis();
    }

    public T withAction(MoveAction<?, ? super A> action, RunMoment runMoment) {
        action.setRunMoment(runMoment);
        this.actions.add(action);
        return this.getThis();
    }

    public T withActions(Collection<MoveAction<?, ? super A>> actions) {
        this.actions.addAll(actions);
        return this.getThis();
    }

    public T withActions(Collection<MoveAction<?, ? super A>> actions, RunMoment runMoment) {
        this.actions.addAll(actions.stream().peek(a -> a.setRunMoment(runMoment)).toList());
        return this.getThis();
    }

    @ApiStatus.Internal
    public T withActionsRaw(Collection<MoveAction<?, ?>> actions) {
        this.actions.addAll(actions);
        return this.getThis();
    }

    public T withInitAction(MoveAction<?, ? super A> action) {
        return this.withAction(action, RunMoment.AT_INIT);
    }

    public T withInitActions(Collection<MoveAction<?, ? super A>> actions) {
        return this.withActions(actions, RunMoment.AT_INIT);
    }

    @ApiStatus.Internal
    public T withInitActionsRaw(Collection<MoveAction<?, ?>> actions) {
        return this.withInitActions(actions);
    }

    public T withSound(RegistrySupplier<SoundEvent> sound) {
        return this.withInitAction(PlaySoundAction.playSound(sound));
    }

    public T withSound(SoundEvent sound) {
        return this.withInitAction(PlaySoundAction.playSound(sound));
    }

    public T withImpactSound(RegistrySupplier<SoundEvent> sound) {
        return this.withAction(PlaySoundAction.playImpactSound(sound));
    }

    public T withImpactSound(SoundEvent sound) {
        return this.withAction(PlaySoundAction.playImpactSound(sound));
    }

    public T withHoldable(Boolean holdable) {
        this.isHoldable = holdable;
        return this.getThis();
    }

    public T withFinisher(int tick, AbstractMove<?, ? super A> move) {
        this.finisher = IntObjectPair.of((int)tick, move);
        return this.getThis();
    }

    public T modifyFinisherTime(int tick) {
        if (this.finisher == null) {
            throw new IllegalStateException("modifyFinisherTime(" + tick + ") called without a pre-set finisher!");
        }
        this.finisher = IntObjectPair.of((int)tick, (Object)((AbstractMove)this.finisher.right()));
        return this.getThis();
    }

    public T withFollowupFrame(int frame) {
        return this.withFollowupFrame(OptionalInt.of(frame));
    }

    public T withFollowupFrame(OptionalInt frame) {
        this.followupFrame = frame;
        return this.getThis();
    }

    public boolean isCrouchingVariant() {
        return this.isCrouchingVariant;
    }

    public T markCrouchingVariant() {
        this.isCrouchingVariant = true;
        return this.getThis();
    }

    public boolean isAerialVariant() {
        return this.isAerialVariant;
    }

    public T markAerialVariant() {
        this.isAerialVariant = true;
        return this.getThis();
    }

    public boolean isFollowup() {
        return this.isFollowup;
    }

    public T markFollowup() {
        this.isFollowup = true;
        return this.getThis();
    }

    @ApiStatus.Internal
    public final void onRegister(MoveClass moveClass) {
        this.moveClass = moveClass;
        if (this.crouchingVariant != null) {
            this.crouchingVariant.onRegister(moveClass);
        }
        if (this.aerialVariant != null) {
            this.aerialVariant.onRegister(moveClass);
        }
        if (this.followup != null) {
            this.followup.onRegister(moveClass);
        }
        if (this.finisher != null) {
            ((AbstractMove)this.finisher.right()).onRegister(moveClass);
        }
        if (!Platform.isDevelopmentEnvironment()) {
            return;
        }
        this.testCopy();
        assert (this.getThis() == this);
        if (this.getMoveType() == null) {
            throw new IllegalStateException("MoveType not set for " + String.valueOf(this));
        }
    }

    public BaseMoveExtras getExtras() {
        return BaseMoveExtras.fromMove(this.getThis());
    }

    @NonNull
    public abstract MoveType<T> getMoveType();

    public final boolean canBeInitiated(A attacker) {
        return (this.isFollowup() || attacker.canAttack()) && this.conditionsMet(attacker);
    }

    public boolean conditionsMet(A attacker) {
        return this.conditions.stream().allMatch(condition -> condition.test(attacker));
    }

    public void onInitiate(A attacker) {
        LivingEntity user = attacker.getUser();
        Set<LivingEntity> targets = Set.of();
        for (MoveAction<?, A> action : this.actions) {
            if (action.getRunMoment() != RunMoment.AT_INIT) continue;
            action.perform(attacker, user, targets);
        }
    }

    public void onCancel(A attacker) {
    }

    public boolean canFinish(A attacker) {
        return true;
    }

    public boolean canBeQueued(A attacker) {
        return true;
    }

    public void activeTick(A attacker, int moveStun) {
        Set<LivingEntity> targets = Set.of();
        for (MoveAction<?, A> action : this.actions) {
            if (action.getRunMoment() != RunMoment.EVERY_TICK && (action.getRunMoment() != RunMoment.AT_END || moveStun != 0) && !action.getRunMoment().shouldRun((AbstractMove<?, ?>)this.getThis(), (IAttacker<?, ?>)attacker, attacker.getUser(), this.getDuration() - moveStun, targets)) continue;
            action.perform(attacker, attacker.getUserOrThrow(), targets);
        }
        if (this.finisher != null && this.canFinish(attacker) && this.finisher.leftInt() <= this.getDuration() - moveStun) {
            attacker.setCurrentMove((AbstractMove)this.finisher.right());
        }
        if (this.shouldPerform(attacker, moveStun)) {
            attacker.setPerformedThisTick(true);
            this.doPerform(attacker);
        }
    }

    public void tick(A attacker) {
    }

    public boolean shouldPerform(A attacker, int moveStun) {
        return moveStun == this.getWindupPoint() && attacker.hasUser();
    }

    public final void doPerform(A attacker) {
        LivingEntity user = attacker.getUserOrThrow();
        Set<LivingEntity> targets = this.perform(attacker, user);
        boolean hit = !targets.isEmpty();
        for (MoveAction<?, A> action : this.actions) {
            if (action.getRunMoment() != RunMoment.ON_STRIKE && (!hit || action.getRunMoment() != RunMoment.ON_HIT)) continue;
            action.perform(attacker, attacker.getUserOrThrow(), targets);
        }
        attacker.onPerform(this, targets);
    }

    @NonNull
    public abstract Set<LivingEntity> perform(A var1, LivingEntity var2);

    public int getBlow(A attacker) {
        return 0;
    }

    public int getWindupPoint() {
        return this.duration - this.windup;
    }

    public boolean hasWindupPassed(IAttacker<?, ?> attacker) {
        return attacker.getMoveStun() <= this.getWindupPoint();
    }

    public boolean hasWindupPassed(IAttacker<?, ?> attacker, int moveStun) {
        return moveStun <= this.getWindupPoint();
    }

    public static Vec3 getRotVec(IAttacker<?, ?> attacker) {
        Vec3 rotVec = attacker.getBaseEntity().m_20154_();
        if (GravityChangerAPI.getGravityDirection((Entity)attacker.getUserOrThrow()) == Direction.UP) {
            rotVec = new Vec3(rotVec.f_82479_, -rotVec.f_82480_, rotVec.f_82481_);
        }
        return rotVec;
    }

    protected Vec3 getOffsetHeightPos(A attacker) {
        Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)attacker.getUserOrThrow());
        Vec3 heightOffset = upVec.m_82490_(0.5);
        return attacker.getBaseEntity().m_20182_().m_82549_(heightOffset);
    }

    protected boolean mayGrief(LivingEntity user) {
        return (user instanceof Player || user.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) && user.m_9236_().m_46469_().m_46207_(JCraft.STAND_GRIEFING);
    }

    public void onUserMoveInput(A attacker, MoveInputType type, boolean pressed, boolean moveInitiated) {
    }

    public MoveSelectionResult specificMoveSelectionCriterion(A attacker, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        return MoveSelectionResult.PASS;
    }

    public boolean onInitMove(A attacker, MoveClass moveClass) {
        return false;
    }

    public boolean preventsMoves() {
        return true;
    }

    @NonNull
    protected abstract T getThis();

    @NonNull
    protected T copyExtras(@NonNull T base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        T cast = base;
        ((AbstractMove)cast).originalMove = this.originalMove;
        ((AbstractMove)cast).moveClass = this.moveClass;
        ((AbstractMove)cast).name = this.name;
        ((AbstractMove)cast).description = this.description;
        ((AbstractMove)cast).followup = this.followup == null ? null : this.followup.copy();
        ((AbstractMove)cast).crouchingVariant = this.crouchingVariant == null ? null : this.crouchingVariant.copy();
        ((AbstractMove)cast).aerialVariant = this.aerialVariant == null ? null : this.aerialVariant.copy();
        ((AbstractMove)cast).conditions.addAll(this.conditions);
        ((AbstractMove)cast).actions.addAll(this.actions);
        ((AbstractMove)cast).followupFrame = this.followupFrame;
        ((AbstractMove)cast).ranged = this.ranged;
        ((AbstractMove)cast).isCrouchingVariant = this.isCrouchingVariant;
        ((AbstractMove)cast).isAerialVariant = this.isAerialVariant;
        ((AbstractMove)cast).isFollowup = this.isFollowup;
        ((AbstractMove)cast).armor = this.armor;
        ((AbstractMove)cast).isHoldable = this.isHoldable;
        ((AbstractMove)cast).copyOnUse = this.copyOnUse;
        ((AbstractMove)cast).finisher = this.finisher == null ? null : IntObjectPair.of((int)this.finisher.leftInt(), ((AbstractMove)this.finisher.right()).copy());
        ((AbstractMove)cast).mobilityType = this.mobilityType;
        ((AbstractMove)cast).animation = this.animation;
        ((AbstractMove)cast).mayHitUser = this.mayHitUser;
        ((AbstractMove)cast).loopPrevention = this.loopPrevention;
        this.copiedExtras = true;
        return base;
    }

    @NonNull
    public abstract T copy();

    private void testCopy() {
        this.copiedExtras = false;
        T copy = this.copy();
        if (copy == null) {
            throw new NullPointerException(this.getClass().getSimpleName() + "#copy() returned null");
        }
        if (!this.copiedExtras) {
            throw new IllegalStateException(this.getClass().getSimpleName() + "#copy() does not call #copyExtras(AbstractMove).");
        }
        if (this.crouchingVariant != null) {
            this.crouchingVariant.testCopy();
        }
        if (this.aerialVariant != null) {
            this.aerialVariant.testCopy();
        }
        if (this.followup != null) {
            this.followup.testCopy();
        }
        if (this.finisher != null) {
            ((AbstractMove)this.finisher.right()).testCopy();
        }
    }

    public List<MoveCondition<?, ? super A>> getConditions() {
        return this.conditions;
    }

    public List<MoveAction<?, ? super A>> getActions() {
        return this.actions;
    }

    public T getOriginalMove() {
        return this.originalMove;
    }

    public MoveClass getMoveClass() {
        return this.moveClass;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getWindup() {
        return this.windup;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getMoveDistance() {
        return this.moveDistance;
    }

    public Enum<?> getAnimation() {
        return this.animation;
    }

    @NonNull
    public Component getName() {
        return this.name;
    }

    @NonNull
    public Component getDescription() {
        return this.description;
    }

    @Nullable
    public AbstractMove<?, ? super A> getCrouchingVariant() {
        return this.crouchingVariant;
    }

    @Nullable
    public AbstractMove<?, ? super A> getAerialVariant() {
        return this.aerialVariant;
    }

    @Nullable
    public AbstractMove<?, ? super A> getFollowup() {
        return this.followup;
    }

    public int getArmor() {
        return this.armor;
    }

    public IntObjectPair<AbstractMove<?, ? super A>> getFinisher() {
        return this.finisher;
    }

    public MobilityType getMobilityType() {
        return this.mobilityType;
    }

    public Boolean getIsHoldable() {
        return this.isHoldable;
    }

    public boolean isLoopPrevention() {
        return this.loopPrevention;
    }

    public OptionalInt getFollowupFrame() {
        return this.followupFrame;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public boolean isBarrage() {
        return this.barrage;
    }

    public boolean isMultiHit() {
        return this.multiHit;
    }

    public boolean isCharge() {
        return this.charge;
    }

    public boolean isCounter() {
        return this.counter;
    }

    public boolean isDash() {
        return this.dash;
    }

    public boolean isGrab() {
        return this.grab;
    }

    public boolean isCopyOnUse() {
        return this.copyOnUse;
    }

    public boolean isMayHitUser() {
        return this.mayHitUser;
    }

    public boolean isManualCooldown() {
        return this.manualCooldown;
    }

    public boolean isCopiedExtras() {
        return this.copiedExtras;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public void setChargeTime(int chargeTime) {
        this.chargeTime = chargeTime;
    }

    protected static abstract class Type<M extends AbstractMove<? extends M, ?>>
    implements MoveType<M> {
        private final AtomicReference<Object> codec = new AtomicReference();

        protected Type() {
        }

        protected RecordCodecBuilder<M, BaseMoveExtras> extras() {
            return BaseMoveExtras.CODEC.get().fieldOf("extras").forGetter(AbstractMove::getExtras);
        }

        protected RecordCodecBuilder<M, Integer> cooldown() {
            return Codec.INT.fieldOf("cooldown").forGetter(AbstractMove::getCooldown);
        }

        protected RecordCodecBuilder<M, Integer> windup() {
            return Codec.INT.fieldOf("windup").forGetter(AbstractMove::getWindup);
        }

        protected RecordCodecBuilder<M, Integer> duration() {
            return Codec.INT.fieldOf("duration").forGetter(AbstractMove::getDuration);
        }

        protected RecordCodecBuilder<M, Float> moveDistance() {
            return Codec.FLOAT.fieldOf("move_distance").forGetter(AbstractMove::getMoveDistance);
        }

        @NonNull
        protected abstract App<RecordCodecBuilder.Mu<M>, M> buildCodec(RecordCodecBuilder.Instance<M> var1);

        protected Function<BaseMoveExtras, M> applyExtras(Supplier<M> function) {
            return extras -> extras.apply((AbstractMove)function.get());
        }

        protected <T1> BiFunction<BaseMoveExtras, T1, M> applyExtras(Function<T1, M> function) {
            return (extras, t1) -> extras.apply((AbstractMove)function.apply(t1));
        }

        protected <T1, T2> Function3<BaseMoveExtras, T1, T2, M> applyExtras(BiFunction<T1, T2, M> function) {
            return (extras, t1, t2) -> extras.apply((AbstractMove)function.apply(t1, t2));
        }

        protected <T1, T2, T3> Function4<BaseMoveExtras, T1, T2, T3, M> applyExtras(Function3<T1, T2, T3, M> function) {
            return (extras, t1, t2, t3) -> extras.apply((AbstractMove)function.apply(t1, t2, t3));
        }

        protected <T1, T2, T3, T4> Function5<BaseMoveExtras, T1, T2, T3, T4, M> applyExtras(Function4<T1, T2, T3, T4, M> function) {
            return (extras, t1, t2, t3, t4) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4));
        }

        protected <T1, T2, T3, T4, T5> Function6<BaseMoveExtras, T1, T2, T3, T4, T5, M> applyExtras(Function5<T1, T2, T3, T4, T5, M> function) {
            return (extras, t1, t2, t3, t4, t5) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5));
        }

        protected <T1, T2, T3, T4, T5, T6> Function7<BaseMoveExtras, T1, T2, T3, T4, T5, T6, M> applyExtras(Function6<T1, T2, T3, T4, T5, T6, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6));
        }

        protected <T1, T2, T3, T4, T5, T6, T7> Function8<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, M> applyExtras(Function7<T1, T2, T3, T4, T5, T6, T7, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8> Function9<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, M> applyExtras(Function8<T1, T2, T3, T4, T5, T6, T7, T8, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9> Function10<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, M> applyExtras(Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Function11<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, M> applyExtras(Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Function12<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, M> applyExtras(Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Function13<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, M> applyExtras(Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Function14<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, M> applyExtras(Function13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Function15<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, M> applyExtras(Function14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Function16<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, M> applyExtras(Function15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ExtraProducts.P17.Function17<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, M> applyExtras(Function16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ExtraProducts.P18.Function18<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, M> applyExtras(ExtraProducts.P17.Function17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ExtraProducts.P19.Function19<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, M> applyExtras(ExtraProducts.P18.Function18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ExtraProducts.P20.Function20<BaseMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, M> applyExtras(ExtraProducts.P19.Function19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, M> function) {
            return (extras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19) -> extras.apply((AbstractMove)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19));
        }

        protected Products.P5<RecordCodecBuilder.Mu<M>, BaseMoveExtras, Integer, Integer, Integer, Float> baseDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance());
        }

        protected App<RecordCodecBuilder.Mu<M>, M> baseDefault(RecordCodecBuilder.Instance<M> instance, Function4<Integer, Integer, Integer, Float, M> function) {
            return this.baseDefault(instance).apply(instance, this.applyExtras(function));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Codec<M> getCodec() {
            Object $value = this.codec.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.codec;
                synchronized (atomicReference) {
                    $value = this.codec.get();
                    if ($value == null) {
                        Codec actualValue = RecordCodecBuilder.create(this::buildCodec);
                        $value = actualValue == null ? this.codec : actualValue;
                        this.codec.set($value);
                    }
                }
            }
            return (Codec)($value == this.codec ? null : $value);
        }
    }
}

