/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.attack.core.data.AttackMoveExtras;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;

public abstract class AbstractMultiHitAttack<T extends AbstractMultiHitAttack<T, A>, A extends IAttacker<? extends A, ?>>
extends AbstractSimpleAttack<T, A> {
    private IntSortedSet hitMoments;

    protected AbstractMultiHitAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, hitMoments.intStream().min().orElse(0), duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
        this.withHitMoments(hitMoments);
    }

    public T withHitMoments(IntCollection hitMoments) {
        IntLinkedOpenHashSet intermediary = new IntLinkedOpenHashSet();
        hitMoments.intStream().sorted().forEachOrdered(arg_0 -> ((IntSortedSet)intermediary).add(arg_0));
        this.hitMoments = IntSortedSets.unmodifiable((IntSortedSet)intermediary);
        return (T)((AbstractMultiHitAttack)this.getThis());
    }

    @Override
    public boolean shouldPerform(A attacker, int moveStun) {
        return attacker.hasUser() && this.hitMoments.contains(this.getDuration() - moveStun);
    }

    @Override
    public int getBlow(A attacker) {
        int tick = this.getDuration() - attacker.getMoveStun();
        AtomicInteger blow = new AtomicInteger(-1);
        this.hitMoments.forEach(i -> {
            if (tick >= i) {
                blow.getAndIncrement();
            }
        });
        return blow.get();
    }

    public IntSortedSet getHitMoments() {
        return this.hitMoments;
    }

    protected static abstract class Type<M extends AbstractMultiHitAttack<? extends M, ?>>
    extends AbstractSimpleAttack.Type<M> {
        protected Type() {
        }

        protected RecordCodecBuilder<M, IntSortedSet> hitMoments() {
            return Codec.INT.listOf().xmap(IntLinkedOpenHashSet::new, ArrayList::new).optionalFieldOf("hit_moments", (Object)IntSortedSets.EMPTY_SET).forGetter(AbstractMultiHitAttack::getHitMoments);
        }

        protected Products.P11<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Float, Float, Integer, Float, Float, Float, IntSortedSet> multiHitDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMoments());
        }

        protected App<RecordCodecBuilder.Mu<M>, M> multiHitDefault(RecordCodecBuilder.Instance<M> instance, Function9<Integer, Integer, Float, Float, Integer, Float, Float, Float, IntSortedSet, M> function) {
            return this.multiHitDefault(instance).apply(instance, this.applyAttackExtras(function));
        }
    }
}

