/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function10;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function12;
import com.mojang.datafixers.util.Function13;
import com.mojang.datafixers.util.Function14;
import com.mojang.datafixers.util.Function15;
import com.mojang.datafixers.util.Function16;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.AttackData;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.HitBoxData;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.core.data.AttackMoveExtras;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.ExtraProducts;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleAttack<T extends AbstractSimpleAttack<T, A>, A extends IAttacker<? extends A, ?>>
extends AbstractMove<T, A> {
    private final Set<HitBoxData> extraHitBoxes = new HashSet<HitBoxData>();
    private float damage;
    @NonNull
    private StunType stunType = StunType.BURSTABLE;
    private int stun;
    private float hitboxSize;
    private float knockback;
    private float offset;
    private boolean overrideStun;
    private boolean lift = true;
    private boolean canBackstab = true;
    private int blockStun = -1;
    private boolean staticY;
    private boolean doShockwaves = false;
    @Nullable
    private CommonHitPropertyComponent.HitAnimation hitAnimation = CommonHitPropertyComponent.HitAnimation.MID;
    @NonNull
    private BlockableType blockableType = BlockableType.BLOCKABLE;
    @Nullable
    protected JParticleType hitSpark = JParticleType.HIT_SPARK_1;

    protected AbstractSimpleAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance);
        this.damage = damage;
        this.stun = stun;
        this.hitboxSize = hitboxSize;
        this.knockback = knockback;
        this.offset = offset;
    }

    public T withDamage(float damage) {
        this.damage = damage;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withHitboxSize(float hitboxSize) {
        this.hitboxSize = hitboxSize;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withKnockback(float knockback) {
        this.knockback = knockback;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withOffset(float offset) {
        this.offset = offset;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withStun(int stun) {
        this.stun = stun;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withStunType(@NonNull StunType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.stunType = type;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withOverrideStun() {
        return this.withOverrideStun(true);
    }

    public T withOverrideStun(boolean overrideStun) {
        this.overrideStun = overrideStun;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withLift(boolean lift) {
        this.lift = lift;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withBackstab(boolean canBackstab) {
        this.canBackstab = canBackstab;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withBlockStun(int blockStun) {
        this.blockStun = blockStun;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withStaticY() {
        return this.withStaticY(true);
    }

    public T withStaticY(boolean staticHeight) {
        this.staticY = staticHeight;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withBlockableType(@NonNull BlockableType blockableType) {
        if (blockableType == null) {
            throw new NullPointerException("blockableType is marked non-null but is null");
        }
        this.blockableType = blockableType;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withHitAnimation(CommonHitPropertyComponent.HitAnimation hitAnimation) {
        this.hitAnimation = hitAnimation;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withExtraHitBox(double size) {
        return this.withExtraHitBox(new HitBoxData(size));
    }

    public T withExtraHitBox(double forwardOffset, double verticalOffset, double size) {
        return this.withExtraHitBox(new HitBoxData(forwardOffset, verticalOffset, size));
    }

    public T withExtraHitBox(HitBoxData hitBox) {
        this.extraHitBoxes.add(hitBox);
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withLaunch() {
        this.withLaunchNoShockwave();
        this.withShockwaves();
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withLaunchNoShockwave() {
        this.stunType = StunType.LAUNCH;
        this.overrideStun = true;
        this.hitAnimation = CommonHitPropertyComponent.HitAnimation.LAUNCH;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withShockwaves() {
        return this.withShockwaves(true);
    }

    public T withShockwaves(boolean shockwaves) {
        this.doShockwaves = shockwaves;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public T withHitSpark(JParticleType particle) {
        this.hitSpark = particle;
        return (T)((AbstractSimpleAttack)this.getThis());
    }

    public AttackMoveExtras getAttackExtras() {
        return AttackMoveExtras.fromMove((AbstractSimpleAttack)this.getThis());
    }

    public int getBlockStun() {
        return this.blockStun < 0 ? (int)(this.damage + 4.0f) : this.blockStun;
    }

    public static AABB createBox(Vec3 center, double size) {
        double axisSize = size / 2.0;
        Vec3 min = center.m_82492_(axisSize, axisSize, axisSize);
        Vec3 max = center.m_82520_(axisSize, axisSize, axisSize);
        return new AABB(min, max);
    }

    public static AABB createBox(Vec3 offsetHeightPos, Vec3 rotVec, Vec3 upVec, HitBoxData data) {
        return AbstractSimpleAttack.createBox(offsetHeightPos.m_82549_(rotVec.m_82490_(data.forwardOffset())).m_82549_(upVec.m_82490_(data.verticalOffset())), data.size());
    }

    public static Set<LivingEntity> findHits(IAttacker<?, ?> attacker, Vec3 boxCenter, double boxSize, @Nullable DamageSource damageSource) {
        return AbstractSimpleAttack.findHits(attacker, AbstractSimpleAttack.createBox(boxCenter, boxSize), damageSource);
    }

    public static Set<LivingEntity> findHits(IAttacker<?, ?> attacker, AABB box, @Nullable DamageSource damageSource) {
        return AbstractSimpleAttack.findHits(attacker, Set.of(box), damageSource);
    }

    public static Set<LivingEntity> findHits(IAttacker<?, ?> attacker, Set<AABB> boxes, @Nullable DamageSource damageSource) {
        return AbstractSimpleAttack.findHits(attacker, boxes, damageSource, LivingEntity.class);
    }

    public static Set<LivingEntity> findHits(IAttacker<?, ?> attacker, Set<AABB> boxes, @Nullable DamageSource damageSource, boolean mayHitUser) {
        return AbstractSimpleAttack.findHits(attacker, boxes, damageSource, LivingEntity.class, mayHitUser);
    }

    @NonNull
    public static <T extends Entity> Set<T> findHits(IAttacker<?, ?> attacker, @NonNull Set<AABB> boxes, @Nullable DamageSource damageSource, Class<T> type) {
        if (boxes == null) {
            throw new NullPointerException("boxes is marked non-null but is null");
        }
        return AbstractSimpleAttack.findHits(attacker, boxes, damageSource, type, false);
    }

    @NonNull
    public static <T extends Entity> Set<T> findHits(IAttacker<?, ?> attacker, @NonNull Set<AABB> boxes, @Nullable DamageSource damageSource, Class<T> type, boolean mayHitUser) {
        if (boxes == null) {
            throw new NullPointerException("boxes is marked non-null but is null");
        }
        LivingEntity user = attacker.getUser();
        HashSet<Entity> result = new HashSet<Entity>();
        Predicate<Entity> filter = e -> e != attacker && (mayHitUser || e != user && e != user.m_20202_() && e != JUtils.getStand(user));
        Predicate<Entity> isCreativeStand = e -> {
            Player player;
            StandEntity stand;
            LivingEntity patt0$temp;
            return e instanceof StandEntity && (patt0$temp = (stand = (StandEntity)e).getUser()) instanceof Player && ((player = (Player)patt0$temp).m_7500_() || player.m_5833_());
        };
        for (AABB box : boxes) {
            for (Entity entity : attacker.getEntityWorld().m_6443_(type, box, EntitySelector.f_20406_.and(filter).and(isCreativeStand.negate()))) {
                StandEntity hitStand;
                if (damageSource == null || JUtils.canDamage(damageSource, entity)) {
                    result.add(entity);
                }
                if (!(entity instanceof StandEntity) || (hitStand = (StandEntity)entity).isRemote() || !hitStand.hasUser() || !type.isInstance(hitStand.getUserOrThrow())) continue;
                Entity hitUser = (Entity)type.cast(hitStand.getUserOrThrow());
                if (damageSource != null && !JUtils.canDamage(damageSource, hitUser)) continue;
                result.add(hitUser);
            }
        }
        return result;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Vec3 userRotVec = user.m_20154_();
        Direction gravDir = GravityChangerAPI.getGravityDirection((Entity)user);
        if (gravDir == Direction.UP) {
            userRotVec = new Vec3(userRotVec.f_82479_, -userRotVec.f_82480_, userRotVec.f_82481_);
        }
        Vec3 hPos = this.getOffsetHeightPos(attacker);
        Vec3 rotVec = this.staticY || attacker.isRemote() ? AbstractSimpleAttack.getRotVec(attacker) : userRotVec;
        Vec3 upVec = new Vec3(gravDir.m_253071_()).m_82490_(-1.0);
        if (this.staticY) {
            rotVec = rotVec.m_193103_(gravDir.m_122434_(), 0.0);
        }
        Vec3 fPos = this.getOffsetForwardPos(attacker, hPos, upVec, rotVec);
        Set<AABB> boxes = this.calculateBoxes(attacker, user, rotVec, upVec, hPos, fPos);
        DamageSource damageSource = attacker.getDamageSource();
        Set<LivingEntity> targets = this.attackBoxes(attacker, boxes, damageSource, fPos);
        if (this.doShockwaves && !targets.isEmpty()) {
            this.createShockwaves(attacker, user);
        }
        this.performHook(attacker, targets, boxes, damageSource, fPos, rotVec);
        return targets;
    }

    protected void performHook(A attacker, Set<LivingEntity> targets, Set<AABB> boxes, DamageSource damageSource, Vec3 forwardPos, Vec3 rotationVector) {
    }

    protected void createShockwaves(A attacker, LivingEntity user) {
        LivingEntity attackerEntity = attacker.getBaseEntity();
        Vec3 shockwavePos = attackerEntity.m_20182_();
        shockwavePos = shockwavePos.m_82549_(attackerEntity.m_20154_());
        shockwavePos = shockwavePos.m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, (double)attackerEntity.m_20206_() / 2.0 - (double)this.offset, 0.0), GravityChangerAPI.getGravityDirection((Entity)user)));
        JComponentPlatformUtils.getShockwaveHandler(attacker.getEntityWorld()).addShockwave(shockwavePos, attackerEntity.m_20154_(), this.damage / 2.5f);
    }

    protected Set<AABB> calculateBoxes(A attacker, LivingEntity user, Vec3 rotVec, Vec3 upVec, Vec3 hPos, Vec3 fPos) {
        if (this.hitboxSize <= 0.0f && this.extraHitBoxes.isEmpty()) {
            return Set.of();
        }
        HashSet<AABB> boxes = new HashSet<AABB>();
        boxes.add(AbstractSimpleAttack.createBox(fPos, this.hitboxSize));
        this.extraHitBoxes.forEach(hitBox -> boxes.add(AbstractSimpleAttack.createBox(hPos, rotVec, upVec, hitBox)));
        return boxes;
    }

    protected final Set<LivingEntity> attackBoxes(A attacker, Set<AABB> boxes, DamageSource damageSource, Vec3 center) {
        JUtils.displayHitboxes(attacker.getEntityWorld(), boxes);
        Set<LivingEntity> targets = AbstractSimpleAttack.findHits(attacker, boxes, damageSource, this.mayHitUser);
        if (targets.isEmpty()) {
            return Set.of();
        }
        targets = this.validateTargets(attacker, targets);
        ServerLevel serverWorld = (ServerLevel)attacker.getEntityWorld();
        RandomSource random = RandomSource.m_216327_();
        boolean anyHit = false;
        Vec3 rotVec = AbstractSimpleAttack.getRotVec(attacker);
        Vec3 kbVec = rotVec.m_82490_((double)this.knockback).m_82549_(new Vec3(0.0, (double)(Math.abs(this.knockback) / 4.0f), 0.0));
        for (LivingEntity target : targets) {
            Vec3 pos = target.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)target).m_82490_(0.65)).m_82546_(rotVec.m_82490_(0.65));
            boolean blocking = JUtils.isBlocking(target);
            if (blocking) {
                JCraft.createHitsparks(serverWorld, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), JParticleType.BLOCK_SPARK, 3, 0.0);
            } else {
                JCraft.createHitsparks(serverWorld, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), JParticleType.PIXEL, 2 + (int)this.damage * 2, 0.5);
                JCraft.createParticle(serverWorld, pos.f_82479_ + random.m_188583_() * 0.25, pos.f_82480_ + random.m_188583_() * 0.25, pos.f_82481_ + random.m_188583_() * 0.25, this.hitSpark);
            }
            this.processTarget(attacker, target, kbVec, damageSource);
        }
        return targets;
    }

    protected void processTarget(A attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        Attacks.damageLogic(attacker.getEntityWorld(), target, new AttackData(kbVec, this.stun, this.stunType.ordinal(), this.overrideStun, this.damage, this.lift, this.getBlockStun(), damageSource, (Entity)attacker.getUserOrThrow(), this.hitAnimation, attacker.getMoveUsage(), this.canBackstab, this.blockableType.isNonBlockable()));
    }

    protected Set<LivingEntity> validateTargets(A attacker, Set<LivingEntity> targets) {
        targets.removeIf(target -> !target.m_6084_());
        return targets;
    }

    protected Vec3 getOffsetForwardPos(A attacker, Vec3 offsetHeightPos, Vec3 upVec, Vec3 rotVec) {
        return offsetHeightPos.m_82549_(rotVec.m_82490_((double)this.getMoveDistance())).m_82549_(upVec.m_82490_((double)(-this.offset)));
    }

    @Override
    @NonNull
    protected T copyExtras(@NonNull T base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        AbstractSimpleAttack cast = (AbstractSimpleAttack)super.copyExtras(base);
        cast.extraHitBoxes.addAll(this.extraHitBoxes);
        cast.stunType = this.stunType;
        cast.overrideStun = this.overrideStun;
        cast.lift = this.lift;
        cast.canBackstab = this.canBackstab;
        cast.doShockwaves = this.doShockwaves;
        cast.blockStun = this.blockStun;
        cast.staticY = this.staticY;
        cast.blockableType = this.blockableType;
        cast.hitSpark = this.hitSpark;
        cast.hitAnimation = this.hitAnimation;
        return base;
    }

    public Set<HitBoxData> getExtraHitBoxes() {
        return this.extraHitBoxes;
    }

    public float getDamage() {
        return this.damage;
    }

    @NonNull
    public StunType getStunType() {
        return this.stunType;
    }

    public int getStun() {
        return this.stun;
    }

    public float getHitboxSize() {
        return this.hitboxSize;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean isOverrideStun() {
        return this.overrideStun;
    }

    public boolean isLift() {
        return this.lift;
    }

    public boolean isCanBackstab() {
        return this.canBackstab;
    }

    public boolean isStaticY() {
        return this.staticY;
    }

    public boolean isDoShockwaves() {
        return this.doShockwaves;
    }

    @Nullable
    public CommonHitPropertyComponent.HitAnimation getHitAnimation() {
        return this.hitAnimation;
    }

    @NonNull
    public BlockableType getBlockableType() {
        return this.blockableType;
    }

    @Nullable
    public JParticleType getHitSpark() {
        return this.hitSpark;
    }

    protected static abstract class Type<M extends AbstractSimpleAttack<? extends M, ?>>
    extends AbstractMove.Type<M> {
        protected Type() {
        }

        protected RecordCodecBuilder<M, AttackMoveExtras> attackExtras() {
            return AttackMoveExtras.CODEC.fieldOf("attack_extras").forGetter(AbstractSimpleAttack::getAttackExtras);
        }

        protected RecordCodecBuilder<M, Float> damage() {
            return Codec.FLOAT.fieldOf("damage").forGetter(AbstractSimpleAttack::getDamage);
        }

        protected RecordCodecBuilder<M, Integer> stun() {
            return Codec.INT.fieldOf("stun").forGetter(AbstractSimpleAttack::getStun);
        }

        protected RecordCodecBuilder<M, Float> hitboxSize() {
            return Codec.FLOAT.fieldOf("hitbox_size").forGetter(AbstractSimpleAttack::getHitboxSize);
        }

        protected RecordCodecBuilder<M, Float> knockback() {
            return Codec.FLOAT.fieldOf("knockback").forGetter(AbstractSimpleAttack::getKnockback);
        }

        protected RecordCodecBuilder<M, Float> offset() {
            return Codec.FLOAT.fieldOf("offset").forGetter(AbstractSimpleAttack::getOffset);
        }

        protected BiFunction<BaseMoveExtras, AttackMoveExtras, M> applyAttackExtras(Supplier<M> function) {
            return (extras, attackExtras) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.get()));
        }

        protected <T1> Function3<BaseMoveExtras, AttackMoveExtras, T1, M> applyAttackExtras(Function<T1, M> function) {
            return (extras, attackExtras, t1) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1)));
        }

        protected <T1, T2> Function4<BaseMoveExtras, AttackMoveExtras, T1, T2, M> applyAttackExtras(BiFunction<T1, T2, M> function) {
            return (extras, attackExtras, t1, t2) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2)));
        }

        protected <T1, T2, T3> Function5<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, M> applyAttackExtras(Function3<T1, T2, T3, M> function) {
            return (extras, attackExtras, t1, t2, t3) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3)));
        }

        protected <T1, T2, T3, T4> Function6<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, M> applyAttackExtras(Function4<T1, T2, T3, T4, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4)));
        }

        protected <T1, T2, T3, T4, T5> Function7<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, M> applyAttackExtras(Function5<T1, T2, T3, T4, T5, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5)));
        }

        protected <T1, T2, T3, T4, T5, T6> Function8<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, M> applyAttackExtras(Function6<T1, T2, T3, T4, T5, T6, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7> Function9<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, M> applyAttackExtras(Function7<T1, T2, T3, T4, T5, T6, T7, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8> Function10<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, M> applyAttackExtras(Function8<T1, T2, T3, T4, T5, T6, T7, T8, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9> Function11<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, M> applyAttackExtras(Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Function12<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, M> applyAttackExtras(Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Function13<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, M> applyAttackExtras(Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Function14<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, M> applyAttackExtras(Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Function15<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, M> applyAttackExtras(Function13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Function16<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, M> applyAttackExtras(Function14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ExtraProducts.P17.Function17<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, M> applyAttackExtras(Function15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ExtraProducts.P18.Function18<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, M> applyAttackExtras(Function16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ExtraProducts.P19.Function19<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, M> applyAttackExtras(ExtraProducts.P17.Function17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17)));
        }

        protected <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ExtraProducts.P20.Function20<BaseMoveExtras, AttackMoveExtras, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, M> applyAttackExtras(ExtraProducts.P18.Function18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, M> function) {
            return (extras, attackExtras, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18) -> attackExtras.apply(extras.apply((AbstractSimpleAttack)function.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18)));
        }

        protected Products.P11<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float> attackDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset());
        }

        protected App<RecordCodecBuilder.Mu<M>, M> attackDefault(RecordCodecBuilder.Instance<M> instance, Function9<Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, M> function) {
            return this.attackDefault(instance).apply(instance, this.applyAttackExtras(function));
        }
    }

    @FunctionalInterface
    public static interface TargetProcessor<A extends IAttacker<? extends A, ?>> {
        public void processTarget(A var1, LivingEntity var2, Vec3 var3, DamageSource var4, boolean var5);
    }
}

