/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function12;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.core.data.AttackMoveExtras;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.SpecAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractSpecGrabAttack<T extends AbstractSpecGrabAttack<T, A, S>, A extends JSpec<A, S>, S extends Enum<S>>
extends AbstractSimpleAttack<T, A> {
    private final AbstractMove<?, ? super A> hitMove;
    private final S hitState;
    private final int grabDuration;
    private final double grabOffset;

    protected AbstractSpecGrabAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super A> hitMove, S hitState) {
        this(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMove, hitState, hitMove.getWindup() - 1, 1.0);
    }

    protected AbstractSpecGrabAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super A> hitMove, S hitState, int grabDuration, double grabOffset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.grab = true;
        this.hitMove = hitMove;
        this.hitState = hitState;
        this.grabDuration = grabDuration;
        this.grabOffset = grabOffset;
        this.withHitAnimation(null);
        this.withStunType(StunType.UNBURSTABLE);
        this.withOverrideStun();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            return targets;
        }
        boolean anyHit = false;
        for (LivingEntity target : targets) {
            StandEntity<?, ?> stand = JUtils.getStand(target);
            if (stand != null && stand.blocking) continue;
            anyHit = true;
            JUtils.cancelMoves(target);
            JComponentPlatformUtils.getGrab(target).startGrab((Entity)((JSpec)attacker).getBaseEntity(), this.grabDuration, this.grabOffset);
            JUtils.setVelocity((Entity)target, 0.0, 0.0, 0.0);
        }
        if (anyHit) {
            attacker.setMove(this.hitMove, this.hitState);
            ((JSpec)attacker).setMoveStun(this.grabDuration);
            ((JSpec)attacker).setAnimation(((SpecAnimationState)this.hitState).getKey(attacker), this.grabDuration, 1.0f);
        }
        return targets;
    }

    public AbstractMove<?, ? super A> getHitMove() {
        return this.hitMove;
    }

    public S getHitState() {
        return this.hitState;
    }

    public int getGrabDuration() {
        return this.grabDuration;
    }

    public double getGrabOffset() {
        return this.grabOffset;
    }

    protected static abstract class Type<M extends AbstractSpecGrabAttack<? extends M, ?, ?>>
    extends AbstractSimpleAttack.Type<M> {
        protected Type() {
        }

        protected <A extends IAttacker<? extends A, ?>> RecordCodecBuilder<M, AbstractMove<?, A>> hitMove() {
            return JRegistries.MOVE_CODEC.fieldOf("hit_move").xmap(m -> m, m -> m).forGetter(m -> m.getHitMove());
        }

        protected RecordCodecBuilder<M, Integer> grabDuration() {
            return Codec.INT.fieldOf("grab_duration").forGetter(AbstractSpecGrabAttack::getGrabDuration);
        }

        protected RecordCodecBuilder<M, Double> grabOffset() {
            return Codec.DOUBLE.optionalFieldOf("grab_offset", (Object)1.0).forGetter(AbstractSpecGrabAttack::getGrabOffset);
        }

        protected <A extends IAttacker<? extends A, ?>> Products.P14<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, AbstractMove<?, A>, Integer, Double> grabDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMove(), this.grabDuration(), this.grabOffset());
        }

        protected <A extends IAttacker<? extends A, ?>> App<RecordCodecBuilder.Mu<M>, M> grabDefault(RecordCodecBuilder.Instance<M> instance, Function12<Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, AbstractMove<?, A>, Integer, Double, M> function) {
            return this.grabDefault(instance).apply(instance, this.applyAttackExtras(function));
        }
    }
}

