/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractTimeStopMove<T extends AbstractTimeStopMove<T, A>, A extends StandEntity<? extends A, ?>>
extends AbstractMove<T, A> {
    protected Either<Integer, IntOption> timeStopDuration;
    private static final MobEffectInstance tsBlind = new MobEffectInstance(MobEffects.f_19610_, 19, 0, true, false, false);

    protected AbstractTimeStopMove(int cooldown, int windup, int duration, float moveDistance, Either<Integer, IntOption> timeStopDuration) {
        super(cooldown, windup, duration, moveDistance);
        this.timeStopDuration = timeStopDuration;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Player player;
        int duration = (Integer)this.timeStopDuration.map(Function.identity(), IntOption::getValue);
        ((StandEntity)attacker).setTsTime(duration);
        if (user instanceof Player && !(player = (Player)user).m_9236_().m_5776_()) {
            player.m_36220_((ResourceLocation)JStatRegistry.TIME_STOPPED.get());
        }
        user.m_7292_(new MobEffectInstance(tsBlind));
        JCraft.beginTimestop(user, attacker.m_20182_(), (ServerLevel)attacker.m_9236_(), duration);
        return Set.of();
    }

    public void setTimeStopDuration(Either<Integer, IntOption> timeStopDuration) {
        this.timeStopDuration = timeStopDuration;
    }

    public Either<Integer, IntOption> getTimeStopDuration() {
        return this.timeStopDuration;
    }

    protected static abstract class Type<M extends AbstractTimeStopMove<? extends M, ?>>
    extends AbstractMove.Type<M> {
        protected Type() {
        }

        protected RecordCodecBuilder<M, Either<Integer, IntOption>> timeStopDuration() {
            return Codec.either((Codec)ExtraCodecs.f_144629_, JServerConfig.INT_OPTION_CODEC).fieldOf("time_stop_duration").forGetter(AbstractTimeStopMove::getTimeStopDuration);
        }
    }
}

