/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.attack.moves;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Function10;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.attack.core.data.AttackMoveExtras;
import net.arna.jcraft.common.attack.core.data.BaseMoveExtras;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractUppercutAttack<T extends AbstractUppercutAttack<T, A>, A extends IAttacker<? extends A, ?>>
extends AbstractSimpleAttack<T, A> {
    private final float strength;

    protected AbstractUppercutAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, float strength) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.strength = strength;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        for (LivingEntity target : targets) {
            Vec3 upDir = new Vec3(GravityChangerAPI.getGravityDirection((Entity)user).m_253071_()).m_82490_((double)(-this.strength));
            JUtils.addVelocity((Entity)target, upDir);
        }
        return targets;
    }

    public float getStrength() {
        return this.strength;
    }

    public static abstract class Type<M extends AbstractUppercutAttack<? extends M, ?>>
    extends AbstractSimpleAttack.Type<M> {
        protected RecordCodecBuilder<M, Float> strength() {
            return Codec.FLOAT.fieldOf("strength").forGetter(AbstractUppercutAttack::getStrength);
        }

        protected Products.P12<RecordCodecBuilder.Mu<M>, BaseMoveExtras, AttackMoveExtras, Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, Float> uppercutDefault(RecordCodecBuilder.Instance<M> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.strength());
        }

        protected App<RecordCodecBuilder.Mu<M>, M> uppercutDefault(RecordCodecBuilder.Instance<M> instance, Function10<Integer, Integer, Integer, Float, Float, Integer, Float, Float, Float, Float, M> function) {
            return this.uppercutDefault(instance).apply(instance, this.applyAttackExtras(function));
        }
    }
}

