/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.component.living;

import net.arna.jcraft.api.component.JComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface CommonBombTrackerComponent
extends JComponent {
    public BombData getMainBomb();

    public BombData getBTD();

    public static class BombData {
        public boolean dirty = false;
        public boolean isEntity = false;
        public boolean isBlock = false;
        public boolean isItem = false;
        public Entity bombEntity;
        public BlockPos bombBlock;
        public ItemStack bombItem;
        public int bombEntityID = -1;

        public void reset() {
            this.isItem = false;
            this.isBlock = false;
            this.isEntity = false;
            this.bombEntity = null;
            this.bombEntityID = -1;
            this.bombBlock = null;
            this.bombItem = null;
            this.dirty = true;
        }

        @Nullable
        public Vec3 getBombPos() {
            if (this.bombEntity == null) {
                this.isEntity = false;
            }
            if (this.isEntity) {
                return this.bombEntity.m_20182_();
            }
            if (this.isBlock) {
                return Vec3.m_82528_((Vec3i)this.bombBlock);
            }
            if (this.isItem && this.bombItem.m_41609_() != null) {
                return this.bombItem.m_41609_().m_20182_();
            }
            return null;
        }

        public void setBomb(@Nullable Entity entity) {
            this.isItem = false;
            this.isBlock = false;
            this.isEntity = false;
            if (entity != null) {
                this.isEntity = true;
                this.bombEntityID = entity.m_19879_();
                this.bombEntity = entity;
            }
            this.dirty = true;
        }

        public void setBomb(BlockPos blockPos) {
            this.isItem = false;
            this.isEntity = false;
            this.isBlock = true;
            this.bombBlock = blockPos;
            this.bombEntityID = -1;
            this.dirty = true;
        }

        public void setBomb(@Nullable ItemStack itemStack) {
            this.isItem = false;
            this.isBlock = false;
            this.isEntity = false;
            if (itemStack != null) {
                this.isItem = true;
                this.bombItem = itemStack;
            }
            this.bombEntityID = -1;
            this.dirty = true;
        }
    }
}

