/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.component.world;

import java.util.List;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public interface CommonShockwaveHandlerComponent {
    public void addShockwave(double var1, double var3, double var5, float var7, float var8, float var9, Shockwave.Type var10);

    default public void addShockwave(double x, double y, double z, float pitch, float yaw) {
        this.addShockwave(x, y, z, pitch, yaw, 1.0f, Shockwave.Type.DEFAULT);
    }

    default public void addShockwave(Vec3 pos, float pitch, float yaw, float scale) {
        this.addShockwave(pos.f_82479_, pos.f_82480_, pos.f_82481_, pitch, yaw, scale, Shockwave.Type.DEFAULT);
    }

    default public void addShockwave(Vec3 pos, float pitch, float yaw) {
        this.addShockwave(pos.f_82479_, pos.f_82480_, pos.f_82481_, pitch, yaw);
    }

    default public void addShockwave(Vec3 pos, Vec3 rotation, float scale, Shockwave.Type type) {
        Vec2 polarRot = JUtils.rotationVectorToPolar(rotation);
        this.addShockwave(pos.f_82479_, pos.f_82480_, pos.f_82481_, polarRot.f_82470_, polarRot.f_82471_, scale, type);
    }

    default public void addShockwave(Vec3 pos, Vec3 rotation) {
        Vec2 polarRot = JUtils.rotationVectorToPolar(rotation);
        this.addShockwave(pos.f_82479_, pos.f_82480_, pos.f_82481_, polarRot.f_82470_, polarRot.f_82471_);
    }

    default public void addShockwave(Vec3 pos, Vec3 rotation, float scale) {
        Vec2 polarRot = JUtils.rotationVectorToPolar(rotation);
        this.addShockwave(pos.f_82479_, pos.f_82480_, pos.f_82481_, polarRot.f_82470_, polarRot.f_82471_, scale, Shockwave.Type.DEFAULT);
    }

    public List<Shockwave> getShockwaves();

    public static class Shockwave {
        public static final int MAX_AGE = 6;
        public final double x;
        public final double y;
        public final double z;
        public final BlockPos blockPos;
        public final float pitch;
        public final float yaw;
        public final float scale;
        private final Type type;
        private int age;

        public Shockwave(double x, double y, double z, float pitch, float yaw, float scale, int age, Type type) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            this.pitch = pitch;
            this.yaw = yaw;
            this.scale = scale;
            this.age = age;
            this.type = type;
        }

        public Shockwave(double x, double y, double z, float pitch, float yaw, float scale, Type type) {
            this(x, y, z, pitch, yaw, scale, 0, type);
        }

        public void tick() {
            ++this.age;
        }

        public int getFrame() {
            return Math.min(this.age, 5);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getScale() {
            return this.scale;
        }

        public Type getType() {
            return this.type;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shockwave)) {
                return false;
            }
            Shockwave other = (Shockwave)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            if (Double.compare(this.getY(), other.getY()) != 0) {
                return false;
            }
            if (Double.compare(this.getZ(), other.getZ()) != 0) {
                return false;
            }
            if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
                return false;
            }
            if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
                return false;
            }
            if (Float.compare(this.getScale(), other.getScale()) != 0) {
                return false;
            }
            if (this.getAge() != other.getAge()) {
                return false;
            }
            BlockPos this$blockPos = this.getBlockPos();
            BlockPos other$blockPos = other.getBlockPos();
            if (this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Shockwave;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $x = Double.doubleToLongBits(this.getX());
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $y = Double.doubleToLongBits(this.getY());
            result = result * 59 + (int)($y >>> 32 ^ $y);
            long $z = Double.doubleToLongBits(this.getZ());
            result = result * 59 + (int)($z >>> 32 ^ $z);
            result = result * 59 + Float.floatToIntBits(this.getPitch());
            result = result * 59 + Float.floatToIntBits(this.getYaw());
            result = result * 59 + Float.floatToIntBits(this.getScale());
            result = result * 59 + this.getAge();
            BlockPos $blockPos = this.getBlockPos();
            result = result * 59 + ($blockPos == null ? 43 : $blockPos.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "CommonShockwaveHandlerComponent.Shockwave(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", blockPos=" + String.valueOf(this.getBlockPos()) + ", pitch=" + this.getPitch() + ", yaw=" + this.getYaw() + ", scale=" + this.getScale() + ", type=" + String.valueOf((Object)this.getType()) + ", age=" + this.getAge() + ")";
        }

        public static enum Type {
            DEFAULT(0, ""),
            PUSHBLOCK(1, "pb");

            private final int id;
            private final String name;

            private Type(int id, String name) {
                this.id = id;
                this.name = name;
            }

            public static Type of(int id) {
                if (id > Type.values().length) {
                    throw new IllegalArgumentException("Index out of bounds");
                }
                return Type.values()[id];
            }

            public int getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

