/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.pose;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class ModelType<T extends Model> {
    private static final Map<String, ModelType<?>> FROM_NAME = new HashMap();
    private static final Map<Class<? extends Model>, ModelType<?>> FROM_CLASS = new HashMap();
    public static final ModelType<HumanoidModel<?>> HUMANOID = new ModelType("humanoid", ModelType.castClass(HumanoidModel.class), Map.of("head", m -> m.f_102808_, "hat", m -> m.f_102809_, "body", m -> m.f_102810_, "rightArm", m -> m.f_102811_, "leftArm", m -> m.f_102812_, "rightLeg", m -> m.f_102813_, "leftLeg", m -> m.f_102814_));
    public static final Codec<ModelType<?>> CODEC = Codec.STRING.comapFlatMap(name -> {
        ModelType<?> modelType = FROM_NAME.get(name);
        if (modelType != null) {
            return DataResult.success(modelType);
        }
        return DataResult.error(() -> "Model type " + name + " not found");
    }, ModelType::getName);
    private final String name;
    private final Class<T> modelClass;
    private final Map<String, Function<T, ModelPart>> parts;

    private ModelType(String name, Class<T> modelClass, Map<String, Function<T, ModelPart>> parts) {
        FROM_NAME.put(name.toLowerCase(Locale.ROOT), this);
        FROM_CLASS.put(modelClass, this);
        this.name = name;
        this.modelClass = modelClass;
        this.parts = ImmutableMap.copyOf(parts);
    }

    private static <T extends Model> Class<T> castClass(Class<?> clazz) {
        return clazz;
    }

    public static boolean isSupported(LivingEntity entity) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (!(renderer instanceof LivingEntityRenderer)) {
            return false;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
        ModelType<?> modelType = ModelType.fromClassRaw(livingRenderer.m_7200_().getClass());
        return modelType != null;
    }

    public static Map<String, ModelType<?>> getAllModelTypes() {
        return ImmutableMap.copyOf(FROM_NAME);
    }

    @Nullable
    public static ModelType<?> fromName(String name) {
        return FROM_NAME.get(name.toLowerCase(Locale.ROOT));
    }

    private static <T extends Model> ModelType<T> fromClassRaw(Class<? extends T> modelClass) {
        ModelType<?> modelType = FROM_CLASS.get(modelClass);
        if (modelType != null) {
            return modelType;
        }
        for (Map.Entry<Class<Model>, ModelType<?>> entry : FROM_CLASS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(modelClass)) continue;
            FROM_CLASS.put(modelClass, entry.getValue());
            return entry.getValue();
        }
        return null;
    }

    public static <T extends Model> ModelType<T> fromClass(Class<? extends T> modelClass) {
        ModelType<? extends T> modelType = ModelType.fromClassRaw(modelClass);
        if (modelType == null) {
            throw new IllegalArgumentException("Model type for class " + modelClass.getSimpleName() + " not found");
        }
        return modelType;
    }

    public boolean hasPart(String partName) {
        return this.parts.containsKey(partName);
    }

    public ModelPart getPart(T model, String partName) {
        Function<T, ModelPart> partFunction = this.parts.get(partName);
        if (partFunction != null) {
            return partFunction.apply(model);
        }
        throw new IllegalArgumentException("Part " + partName + " not found in model " + this.modelClass.getSimpleName());
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getModelClass() {
        return this.modelClass;
    }
}

