/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.pose;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import net.arna.jcraft.common.util.JCodecUtils;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public enum ModifierCondition {
    LEFT_ARM_EMPTY((model, user) -> {
        if (!(model instanceof HumanoidModel)) return false;
        HumanoidModel hModel = (HumanoidModel)model;
        if (hModel.f_102815_ != HumanoidModel.ArmPose.EMPTY) return false;
        return true;
    }),
    RIGHT_ARM_EMPTY((model, user) -> {
        if (!(model instanceof HumanoidModel)) return false;
        HumanoidModel hModel = (HumanoidModel)model;
        if (hModel.f_102816_ != HumanoidModel.ArmPose.EMPTY) return false;
        return true;
    }),
    LEFT_ARM_EMPTY_OR_ITEM((model, user) -> {
        if (!(model instanceof HumanoidModel)) return false;
        HumanoidModel hModel = (HumanoidModel)model;
        if (hModel.f_102815_ == HumanoidModel.ArmPose.EMPTY) return true;
        if (hModel.f_102815_ != HumanoidModel.ArmPose.ITEM) return false;
        return true;
    }),
    RIGHT_ARM_EMPTY_OR_ITEM((model, user) -> {
        if (!(model instanceof HumanoidModel)) return false;
        HumanoidModel hModel = (HumanoidModel)model;
        if (hModel.f_102816_ == HumanoidModel.ArmPose.EMPTY) return true;
        if (hModel.f_102816_ != HumanoidModel.ArmPose.ITEM) return false;
        return true;
    }),
    USER_NOT_MOVING((model, user) -> JUtils.deltaPos((Entity)user).m_165925_() <= 0.0),
    USER_NOT_SPRINTING((model, user) -> !user.m_20142_());

    public static final Codec<ModifierCondition> CODEC;
    private final BiPredicate<Model, LivingEntity> condition;

    private ModifierCondition(BiPredicate<Model, LivingEntity> condition) {
        this.condition = condition;
    }

    public static boolean anyFails(List<ModifierCondition> conditions, Model model, LivingEntity user) {
        return conditions.stream().anyMatch(condition -> !condition.test(model, user));
    }

    public boolean test(Model model, LivingEntity user) {
        return this.condition.test(model, user);
    }

    static {
        CODEC = JCodecUtils.createEnumCodec(ModifierCondition.class);
    }
}

