/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.pose;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.arna.jcraft.api.pose.ModelPartGetter;
import net.arna.jcraft.api.pose.ModelPartProperty;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.ModifierOperation;
import net.arna.jcraft.api.pose.modifier.CustomPoseModifier;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.LevitationPoseModifier;
import net.arna.jcraft.api.pose.modifier.PoseModifierGroup;

public class PoseModifiers {
    private static final Pattern MODIFIER_PATTERN = Pattern.compile("([a-zA-Z_\\d]+)\\.(x|y|z|x_?Rot|y_?Rot|z_?Rot|x_?Scale|y_?Scale|z_?Scale)\\s*(=|\\+=|-=|\\*=|/=)\\s*((?:-?|\\+?)\\d+(?:\\.\\d+)?)\\s*(deg)?$", 2);
    private static final Map<String, Codec<? extends IPoseModifier>> MODIFIERS = new HashMap<String, Codec<? extends IPoseModifier>>();
    public static Codec<IPoseModifier> CODEC = Codec.STRING.dispatch(IPoseModifier::getId, MODIFIERS::get);

    private PoseModifiers() {
    }

    public static void register(String id, Codec<? extends IPoseModifier> codec) {
        if (MODIFIERS.containsKey(id)) {
            throw new IllegalArgumentException("Modifier with id " + id + " is already registered.");
        }
        MODIFIERS.put(id, codec);
    }

    public static IPoseModifier parse(String modifiers, ModifierCondition ... conditions) {
        if (modifiers.isEmpty()) {
            return IPoseModifier.EMPTY;
        }
        String[] parts = modifiers.split(";");
        if (parts.length == 1) {
            return PoseModifiers.parseSingle(parts[0], conditions);
        }
        List<IPoseModifier> parsedModifiers = Arrays.stream(parts).map(x$0 -> PoseModifiers.parseSingle(x$0, new ModifierCondition[0])).filter(Objects::nonNull).toList();
        if (parsedModifiers.isEmpty()) {
            return IPoseModifier.EMPTY;
        }
        return PoseModifierGroup.builder().conditions(List.of(conditions)).modifiers(parsedModifiers).build();
    }

    private static IPoseModifier parseSingle(String modifier, ModifierCondition ... conditions) {
        if ((modifier = modifier.split("//")[0].trim()).isEmpty()) {
            return IPoseModifier.EMPTY;
        }
        Matcher matcher = MODIFIER_PATTERN.matcher(modifier);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid modifier format: " + modifier);
        }
        String rawPart = matcher.group(1);
        String rawProp = matcher.group(2);
        String rawOp = matcher.group(3);
        String valueStr = matcher.group(4);
        boolean isDeg = matcher.group(5) != null;
        ModelPartGetter part = new ModelPartGetter(rawPart);
        ModelPartProperty prop = switch (rawProp.toLowerCase(Locale.ROOT)) {
            case "x" -> ModelPartProperty.X;
            case "y" -> ModelPartProperty.Y;
            case "z" -> ModelPartProperty.Z;
            case "xrot", "x_rot" -> ModelPartProperty.X_ROT;
            case "yrot", "y_rot" -> ModelPartProperty.Y_ROT;
            case "zrot", "z_rot" -> ModelPartProperty.Z_ROT;
            case "xscale", "x_scale" -> ModelPartProperty.X_SCALE;
            case "yscale", "y_scale" -> ModelPartProperty.Y_SCALE;
            case "zscale", "z_scale" -> ModelPartProperty.Z_SCALE;
            default -> throw new IllegalArgumentException("Unknown property: " + rawProp);
        };
        ModifierOperation operation = switch (rawOp) {
            case "=" -> ModifierOperation.SET;
            case "+=", "-=" -> ModifierOperation.ADD;
            case "*=", "/=" -> ModifierOperation.MULTIPLY;
            default -> throw new IllegalArgumentException("Unknown operation: " + rawOp);
        };
        boolean invertOp = "-=".equals(rawOp) || "/=".equals(rawOp);
        float value = Float.parseFloat(valueStr);
        if (isDeg) {
            value *= (float)Math.PI / 180;
        }
        if (invertOp) {
            value = operation == ModifierOperation.ADD ? -value : 1.0f / value;
        }
        return new CustomPoseModifier(List.of(conditions), operation, part, prop, value);
    }

    public static void register() {
        PoseModifiers.register("empty", (Codec<? extends IPoseModifier>)Codec.unit((Object)IPoseModifier.EMPTY));
        PoseModifiers.register("group", PoseModifierGroup.CODEC);
        PoseModifiers.register("custom", CustomPoseModifier.CODEC);
        PoseModifiers.register("levitation", LevitationPoseModifier.CODEC);
    }
}

