/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.pose.modifier;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.arna.jcraft.api.pose.ModelPartGetter;
import net.arna.jcraft.api.pose.ModelPartProperty;
import net.arna.jcraft.api.pose.ModelType;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.ModifierOperation;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.minecraft.client.model.Model;
import net.minecraft.world.entity.LivingEntity;

public record CustomPoseModifier(List<ModifierCondition> conditions, ModifierOperation operation, ModelPartGetter part, ModelPartProperty property, float value) implements IPoseModifier
{
    public static final String ID = "custom";
    public static final Codec<CustomPoseModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModifierCondition.CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(CustomPoseModifier::conditions), (App)ModifierOperation.CODEC.fieldOf("operation").forGetter(CustomPoseModifier::operation), (App)ModelPartGetter.CODEC.fieldOf("part").forGetter(CustomPoseModifier::part), (App)ModelPartProperty.CODEC.fieldOf("property").forGetter(CustomPoseModifier::property), (App)Codec.FLOAT.fieldOf("value").forGetter(CustomPoseModifier::value)).apply((Applicative)instance, CustomPoseModifier::new));

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isModelSupported(ModelType<?> modelType) {
        return modelType.hasPart(this.part.partName());
    }

    @Override
    public void apply(Model model, LivingEntity user, float age) {
        if (ModifierCondition.anyFails(this.conditions, model, user)) {
            return;
        }
        this.operation.apply(this.part.getPart(model), this.property, this.value);
    }

    public static CustomPoseModifierBuilder builder() {
        return new CustomPoseModifierBuilder();
    }

    public static class CustomPoseModifierBuilder {
        private ImmutableList.Builder<ModifierCondition> conditions;
        private ModifierOperation operation;
        private ModelPartGetter part;
        private ModelPartProperty property;
        private float value;

        CustomPoseModifierBuilder() {
        }

        public CustomPoseModifierBuilder condition(ModifierCondition condition) {
            if (this.conditions == null) {
                this.conditions = ImmutableList.builder();
            }
            this.conditions.add((Object)condition);
            return this;
        }

        public CustomPoseModifierBuilder conditions(Iterable<? extends ModifierCondition> conditions) {
            if (conditions == null) {
                throw new NullPointerException("conditions cannot be null");
            }
            if (this.conditions == null) {
                this.conditions = ImmutableList.builder();
            }
            this.conditions.addAll(conditions);
            return this;
        }

        public CustomPoseModifierBuilder clearConditions() {
            this.conditions = null;
            return this;
        }

        public CustomPoseModifierBuilder operation(ModifierOperation operation) {
            this.operation = operation;
            return this;
        }

        public CustomPoseModifierBuilder part(ModelPartGetter part) {
            this.part = part;
            return this;
        }

        public CustomPoseModifierBuilder property(ModelPartProperty property) {
            this.property = property;
            return this;
        }

        public CustomPoseModifierBuilder value(float value) {
            this.value = value;
            return this;
        }

        public CustomPoseModifier build() {
            ImmutableList conditions = this.conditions == null ? ImmutableList.of() : this.conditions.build();
            return new CustomPoseModifier((List<ModifierCondition>)conditions, this.operation, this.part, this.property, this.value);
        }

        public String toString() {
            return "CustomPoseModifier.CustomPoseModifierBuilder(conditions=" + String.valueOf(this.conditions) + ", operation=" + String.valueOf((Object)this.operation) + ", part=" + String.valueOf(this.part) + ", property=" + String.valueOf((Object)this.property) + ", value=" + this.value + ")";
        }
    }
}

