/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.pose.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.atomic.AtomicReference;
import net.arna.jcraft.api.pose.ModelType;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LevitationPoseModifier
implements IPoseModifier {
    public static final String ID = "levitation";
    public static final Codec<LevitationPoseModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("amplitude", (Object)Float.valueOf(1.0f)).forGetter(LevitationPoseModifier::getAmplitude), (App)Codec.FLOAT.optionalFieldOf("verticalShift", (Object)Float.valueOf(1.0f)).forGetter(LevitationPoseModifier::getVerticalShift), (App)Codec.FLOAT.optionalFieldOf("period", (Object)Float.valueOf(62.831856f)).forGetter(LevitationPoseModifier::getPeriod)).apply((Applicative)instance, LevitationPoseModifier::new));
    private float amplitude;
    private float verticalShift;
    private float period;
    private final AtomicReference<Object> multiplier = new AtomicReference();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isModelSupported(ModelType<?> modelType) {
        return modelType == ModelType.HUMANOID;
    }

    @Override
    public void apply(Model model, LivingEntity user, float age) {
        HumanoidModel hModel = (HumanoidModel)model;
        float wave = Mth.m_14031_((float)(age * this.getMultiplier() - (float)user.m_19879_()));
        float heightOffset = this.verticalShift + wave * this.amplitude;
        hModel.f_102808_.f_104201_ -= heightOffset;
        hModel.f_102810_.f_104201_ -= heightOffset;
        hModel.f_102812_.f_104201_ -= heightOffset;
        hModel.f_102811_.f_104201_ -= heightOffset;
        hModel.f_102814_.f_104201_ -= heightOffset;
        hModel.f_102813_.f_104201_ -= heightOffset;
        double velocity = JUtils.deltaPos((Entity)user).m_165924_();
        float speedInfluence = (float)(Math.tanh(velocity) * 90.0 * 0.01745329238474369);
        hModel.f_102810_.f_104203_ += speedInfluence;
        hModel.f_102814_.f_104201_ -= 1.0f + Mth.m_14031_((float)speedInfluence) * 6.0f;
        hModel.f_102814_.f_104202_ += Mth.m_14031_((float)speedInfluence) * 12.0f - 2.0f;
        hModel.f_102813_.f_104201_ -= Mth.m_14031_((float)speedInfluence) * 6.0f;
        hModel.f_102813_.f_104202_ += Mth.m_14031_((float)speedInfluence) * 12.0f;
        hModel.f_102813_.f_104203_ = speedInfluence;
        hModel.f_102814_.f_104203_ = 0.2617994f + speedInfluence;
        hModel.f_102812_.f_104203_ *= 0.25f;
        hModel.f_102811_.f_104203_ *= 0.25f;
        if (hModel.f_102815_ == HumanoidModel.ArmPose.EMPTY) {
            hModel.f_102812_.f_104205_ = -0.7853982f + wave * this.amplitude / 8.0f;
            hModel.f_102812_.f_104203_ = speedInfluence;
        }
        if (hModel.f_102816_ == HumanoidModel.ArmPose.EMPTY) {
            hModel.f_102811_.f_104203_ = speedInfluence;
        }
    }

    private static float $default$amplitude() {
        return 1.0f;
    }

    private static float $default$verticalShift() {
        return 1.0f;
    }

    private static float $default$period() {
        return 62.831856f;
    }

    public static LevitationPoseModifierBuilder builder() {
        return new LevitationPoseModifierBuilder();
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getVerticalShift() {
        return this.verticalShift;
    }

    public float getPeriod() {
        return this.period;
    }

    public LevitationPoseModifier() {
        this.amplitude = LevitationPoseModifier.$default$amplitude();
        this.verticalShift = LevitationPoseModifier.$default$verticalShift();
        this.period = LevitationPoseModifier.$default$period();
    }

    private LevitationPoseModifier(float amplitude, float verticalShift, float period) {
        this.amplitude = amplitude;
        this.verticalShift = verticalShift;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getMultiplier() {
        Object $value = this.multiplier.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.multiplier;
            synchronized (atomicReference) {
                $value = this.multiplier.get();
                if ($value == null) {
                    float actualValue = (float)Math.PI * 2 / this.period;
                    $value = Float.valueOf(actualValue);
                    this.multiplier.set($value);
                }
            }
        }
        return ((Float)$value).floatValue();
    }

    public static class LevitationPoseModifierBuilder {
        private boolean amplitude$set;
        private float amplitude$value;
        private boolean verticalShift$set;
        private float verticalShift$value;
        private boolean period$set;
        private float period$value;

        LevitationPoseModifierBuilder() {
        }

        public LevitationPoseModifierBuilder amplitude(float amplitude) {
            this.amplitude$value = amplitude;
            this.amplitude$set = true;
            return this;
        }

        public LevitationPoseModifierBuilder verticalShift(float verticalShift) {
            this.verticalShift$value = verticalShift;
            this.verticalShift$set = true;
            return this;
        }

        public LevitationPoseModifierBuilder period(float period) {
            this.period$value = period;
            this.period$set = true;
            return this;
        }

        public LevitationPoseModifier build() {
            float amplitude$value = this.amplitude$value;
            if (!this.amplitude$set) {
                amplitude$value = LevitationPoseModifier.$default$amplitude();
            }
            float verticalShift$value = this.verticalShift$value;
            if (!this.verticalShift$set) {
                verticalShift$value = LevitationPoseModifier.$default$verticalShift();
            }
            float period$value = this.period$value;
            if (!this.period$set) {
                period$value = LevitationPoseModifier.$default$period();
            }
            return new LevitationPoseModifier(amplitude$value, verticalShift$value, period$value);
        }

        public String toString() {
            return "LevitationPoseModifier.LevitationPoseModifierBuilder(amplitude$value=" + this.amplitude$value + ", verticalShift$value=" + this.verticalShift$value + ", period$value=" + this.period$value + ")";
        }
    }
}

