/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.pose.modifier;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.arna.jcraft.api.pose.ModelType;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.minecraft.client.model.Model;
import net.minecraft.world.entity.LivingEntity;

public record PoseModifierGroup(List<ModifierCondition> conditions, List<IPoseModifier> modifiers) implements IPoseModifier
{
    public static final String ID = "group";
    public static final Codec<PoseModifierGroup> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModifierCondition.CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(PoseModifierGroup::conditions), (App)PoseModifiers.CODEC.listOf().fieldOf("modifiers").forGetter(PoseModifierGroup::modifiers)).apply((Applicative)instance, PoseModifierGroup::new));

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isModelSupported(ModelType<?> modelType) {
        return this.modifiers.stream().allMatch(modifier -> modifier.isModelSupported(modelType));
    }

    @Override
    public void apply(Model model, LivingEntity user, float age) {
        if (ModifierCondition.anyFails(this.conditions, model, user)) {
            return;
        }
        for (IPoseModifier modifier : this.modifiers) {
            modifier.apply(model, user, age);
        }
    }

    public static PoseModifierGroupBuilder builder() {
        return new PoseModifierGroupBuilder();
    }

    public static class PoseModifierGroupBuilder {
        private ImmutableList.Builder<ModifierCondition> conditions;
        private ImmutableList.Builder<IPoseModifier> modifiers;

        PoseModifierGroupBuilder() {
        }

        public PoseModifierGroupBuilder condition(ModifierCondition condition) {
            if (this.conditions == null) {
                this.conditions = ImmutableList.builder();
            }
            this.conditions.add((Object)condition);
            return this;
        }

        public PoseModifierGroupBuilder conditions(Iterable<? extends ModifierCondition> conditions) {
            if (conditions == null) {
                throw new NullPointerException("conditions cannot be null");
            }
            if (this.conditions == null) {
                this.conditions = ImmutableList.builder();
            }
            this.conditions.addAll(conditions);
            return this;
        }

        public PoseModifierGroupBuilder clearConditions() {
            this.conditions = null;
            return this;
        }

        public PoseModifierGroupBuilder modifier(IPoseModifier modifier) {
            if (this.modifiers == null) {
                this.modifiers = ImmutableList.builder();
            }
            this.modifiers.add((Object)modifier);
            return this;
        }

        public PoseModifierGroupBuilder modifiers(Iterable<? extends IPoseModifier> modifiers) {
            if (modifiers == null) {
                throw new NullPointerException("modifiers cannot be null");
            }
            if (this.modifiers == null) {
                this.modifiers = ImmutableList.builder();
            }
            this.modifiers.addAll(modifiers);
            return this;
        }

        public PoseModifierGroupBuilder clearModifiers() {
            this.modifiers = null;
            return this;
        }

        public PoseModifierGroup build() {
            ImmutableList conditions = this.conditions == null ? ImmutableList.of() : this.conditions.build();
            ImmutableList modifiers = this.modifiers == null ? ImmutableList.of() : this.modifiers.build();
            return new PoseModifierGroup((List<ModifierCondition>)conditions, (List<IPoseModifier>)modifiers);
        }

        public String toString() {
            return "PoseModifierGroup.PoseModifierGroupBuilder(conditions=" + String.valueOf(this.conditions) + ", modifiers=" + String.valueOf(this.modifiers) + ")";
        }
    }
}

