/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.registry;

import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import net.arna.jcraft.common.config.ConfigOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.events.JBlockEvents;
import net.arna.jcraft.common.events.JEntityEvents;
import net.arna.jcraft.common.events.JServerEvents;
import net.arna.jcraft.common.network.c2s.ConfigUpdatePacket;
import net.arna.jcraft.common.network.s2c.AttackerDataPacket;

public interface JEventsRegistry {
    public static void registerEvents() {
        EntityEvent.LIVING_HURT.register(JServerEvents::hurt);
        JEntityEvents.POST_ADD.register(JServerEvents::entityLoad);
        EntityEvent.LIVING_DEATH.register(JServerEvents::death);
        TickEvent.SERVER_POST.register(JServerEvents::serverPostTick);
        TickEvent.SERVER_LEVEL_POST.register(JServerEvents::serverLevelPostTick);
        JBlockEvents.BEFORE_SET.register(JServerEvents::beforeBlockSet);
        InteractionEvent.RIGHT_CLICK_ITEM.register(JServerEvents::rightClick);
        InteractionEvent.LEFT_CLICK_BLOCK.register(JServerEvents::leftClickBlock);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(JServerEvents::rightClickBlock);
        PlayerEvent.PLAYER_JOIN.register(player -> {
            ConfigUpdatePacket.sendOptionsToClient(player, ConfigOption.getImmutableOptions().values());
            AttackerDataPacket.send(List.of(player));
        });
        LifecycleEvent.SERVER_BEFORE_START.register(JServerConfig::load);
        LifecycleEvent.SERVER_STARTED.register(JServerEvents::finishLoading);
        LifecycleEvent.SERVER_STOPPED.register(JServerEvents::saveExclusives);
    }
}

