/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Function;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.arna.jcraft.common.spec.BrawlerSpec;
import net.arna.jcraft.common.spec.VampireSpec;
import net.minecraft.Util;
import net.minecraft.world.entity.LivingEntity;

public interface JSpecTypeRegistry {
    public static final DeferredRegister<SpecType> SPEC_TYPE_REGISTRY = DeferredRegister.create((String)"jcraft", JRegistries.SPEC_TYPE_REGISTRY_KEY);
    public static final RegistrySupplier<SpecType> NONE = JSpecTypeRegistry.register("none", user -> null);
    public static final RegistrySupplier<SpecType> BRAWLER = JSpecTypeRegistry.register("brawler", BrawlerSpec::new);
    public static final RegistrySupplier<SpecType> ANUBIS = JSpecTypeRegistry.register("anubis", AnubisSpec::new);
    public static final RegistrySupplier<SpecType> VAMPIRE = JSpecTypeRegistry.register("vampire", VampireSpec::new);
    public static final Int2ObjectMap<RegistrySupplier<SpecType>> LEGACY_ORDINALS = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectArrayMap(), map -> {
        map.put(0, NONE);
        map.put(1, BRAWLER);
        map.put(2, ANUBIS);
        map.put(3, VAMPIRE);
    });

    private static RegistrySupplier<SpecType> register(String name, Function<LivingEntity, JSpec<?, ?>> factory) {
        return SPEC_TYPE_REGISTRY.register(name, () -> SpecType.of(JCraft.id(name), factory));
    }
}

