/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.function.Supplier;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public interface JStandTypeRegistry {
    public static final DeferredRegister<StandType> STAND_TYPE_REGISTRY = DeferredRegister.create((String)"jcraft", JRegistries.STAND_TYPE_REGISTRY_KEY);
    public static final RegistrySupplier<StandType> NONE = JStandTypeRegistry.register("none", () -> null);
    public static final RegistrySupplier<StandType> STAR_PLATINUM = JStandTypeRegistry.register("star_platinum", JEntityTypeRegistry.STAR_PLATINUM);
    public static final RegistrySupplier<StandType> THE_WORLD = JStandTypeRegistry.register("the_world", JEntityTypeRegistry.THE_WORLD);
    public static final RegistrySupplier<StandType> KING_CRIMSON = JStandTypeRegistry.register("king_crimson", JEntityTypeRegistry.KING_CRIMSON);
    public static final RegistrySupplier<StandType> D4C = JStandTypeRegistry.register("d4c", JEntityTypeRegistry.D4C);
    public static final RegistrySupplier<StandType> CREAM = JStandTypeRegistry.register("cream", JEntityTypeRegistry.CREAM);
    public static final RegistrySupplier<StandType> KILLER_QUEEN = JStandTypeRegistry.register("killer_queen", JEntityTypeRegistry.KILLER_QUEEN);
    public static final RegistrySupplier<StandType> WHITE_SNAKE = JStandTypeRegistry.register("white_snake", JEntityTypeRegistry.WHITE_SNAKE);
    public static final RegistrySupplier<StandType> SILVER_CHARIOT = JStandTypeRegistry.register("silver_chariot", JEntityTypeRegistry.SILVER_CHARIOT);
    public static final RegistrySupplier<StandType> MAGICIANS_RED = JStandTypeRegistry.register("magicians_red", JEntityTypeRegistry.MAGICIANS_RED);
    public static final RegistrySupplier<StandType> THE_FOOL = JStandTypeRegistry.register("the_fool", JEntityTypeRegistry.THE_FOOL);
    public static final RegistrySupplier<StandType> GOLD_EXPERIENCE = JStandTypeRegistry.register("gold_experience", JEntityTypeRegistry.GOLD_EXPERIENCE);
    public static final RegistrySupplier<StandType> HIEROPHANT_GREEN = JStandTypeRegistry.register("hierophant_green", JEntityTypeRegistry.HIEROPHANT_GREEN);
    public static final RegistrySupplier<StandType> THE_SUN = JStandTypeRegistry.register("the_sun", JEntityTypeRegistry.THE_SUN);
    public static final RegistrySupplier<StandType> PURPLE_HAZE = JStandTypeRegistry.register("purple_haze", JEntityTypeRegistry.PURPLE_HAZE);
    public static final RegistrySupplier<StandType> C_MOON = JStandTypeRegistry.register("c_moon", JEntityTypeRegistry.C_MOON);
    public static final RegistrySupplier<StandType> MADE_IN_HEAVEN = JStandTypeRegistry.register("made_in_heaven", JEntityTypeRegistry.MADE_IN_HEAVEN);
    public static final RegistrySupplier<StandType> THE_WORLD_OVER_HEAVEN = JStandTypeRegistry.register("the_world_over_heaven", JEntityTypeRegistry.THE_WORLD_OVER_HEAVEN);
    public static final RegistrySupplier<StandType> KILLER_QUEEN_BITES_THE_DUST = JStandTypeRegistry.register("killer_queen_bites_the_dust", JEntityTypeRegistry.KILLER_QUEEN_BITES_THE_DUST);
    public static final RegistrySupplier<StandType> GOLD_EXPERIENCE_REQUIEM = JStandTypeRegistry.register("gold_experience_requiem", JEntityTypeRegistry.GER);
    public static final RegistrySupplier<StandType> STAR_PLATINUM_THE_WORLD = JStandTypeRegistry.register("star_platinum_the_world", JEntityTypeRegistry.SPTW);
    public static final RegistrySupplier<StandType> PURPLE_HAZE_DISTORTION = JStandTypeRegistry.register("purple_haze_distortion", JEntityTypeRegistry.PURPLE_HAZE_DISTORTION);
    public static final RegistrySupplier<StandType> HORUS = JStandTypeRegistry.register("horus", JEntityTypeRegistry.HORUS);
    public static final RegistrySupplier<StandType> CINDERELLA = JStandTypeRegistry.register("cinderella", JEntityTypeRegistry.CINDERELLA);
    public static final RegistrySupplier<StandType> OSIRIS = JStandTypeRegistry.register("osiris", JEntityTypeRegistry.OSIRIS);
    public static final RegistrySupplier<StandType> ATUM = JStandTypeRegistry.register("atum", JEntityTypeRegistry.ATUM);
    public static final RegistrySupplier<StandType> CHARIOT_REQUIEM = JStandTypeRegistry.register("chariot_requiem", JEntityTypeRegistry.CHARIOT_REQUIEM);
    public static final RegistrySupplier<StandType> DIVER_DOWN = JStandTypeRegistry.register("diver_down", JEntityTypeRegistry.DIVER_DOWN);
    public static final RegistrySupplier<StandType> DRAGONS_DREAM = JStandTypeRegistry.register("dragons_dream", JEntityTypeRegistry.DRAGONS_DREAM);
    public static final RegistrySupplier<StandType> FOO_FIGHTERS = JStandTypeRegistry.register("foo_fighters", JEntityTypeRegistry.FOO_FIGHTERS);
    public static final RegistrySupplier<StandType> GOO_GOO_DOLLS = JStandTypeRegistry.register("goo_goo_dolls", JEntityTypeRegistry.GOO_GOO_DOLLS);
    public static final RegistrySupplier<StandType> SHADOW_THE_WORLD = JStandTypeRegistry.register("shadow_the_world", JEntityTypeRegistry.SHADOW_THE_WORLD);
    public static final RegistrySupplier<StandType> METALLICA = JStandTypeRegistry.register("metallica", JEntityTypeRegistry.METALLICA);
    public static final RegistrySupplier<StandType> THE_HAND = JStandTypeRegistry.register("the_hand", JEntityTypeRegistry.THE_HAND);
    public static final RegistrySupplier<StandType> MANDOM = JStandTypeRegistry.register("mandom", JEntityTypeRegistry.MANDOM);
    public static final Int2ObjectMap<RegistrySupplier<StandType>> LEGACY_ORDINALS = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectArrayMap(), map -> {
        List<RegistrySupplier> entries = List.of(NONE, STAR_PLATINUM, THE_WORLD, KING_CRIMSON, D4C, CREAM, KILLER_QUEEN, WHITE_SNAKE, SILVER_CHARIOT, MAGICIANS_RED, THE_FOOL, GOLD_EXPERIENCE, HIEROPHANT_GREEN, THE_SUN, PURPLE_HAZE, C_MOON, MADE_IN_HEAVEN, THE_WORLD_OVER_HEAVEN, KILLER_QUEEN_BITES_THE_DUST, GOLD_EXPERIENCE_REQUIEM, STAR_PLATINUM_THE_WORLD, PURPLE_HAZE_DISTORTION, HORUS, CINDERELLA, OSIRIS, ATUM, CHARIOT_REQUIEM, DIVER_DOWN, DRAGONS_DREAM, FOO_FIGHTERS, GOO_GOO_DOLLS, SHADOW_THE_WORLD, METALLICA, THE_HAND);
        for (int i = 0; i < entries.size(); ++i) {
            map.put(i, (Object)entries.get(i));
        }
    });

    public static <E extends StandEntity<?, ?>> RegistrySupplier<StandType> register(String name, Supplier<EntityType<E>> entityTypeSupplier) {
        ResourceLocation id = JCraft.id(name);
        return STAND_TYPE_REGISTRY.register(name, () -> StandType.of(id, entityTypeSupplier));
    }
}

