/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.spec;

import com.google.common.base.MoreObjects;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpecHolder;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.CombatEntityContext;
import net.arna.jcraft.common.ai.CombatInstantContext;
import net.arna.jcraft.common.attack.core.MoveMapImpl;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.network.s2c.PlayerAnimPacket;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.tickable.MoveTickQueue;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.DashData;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.SpecAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class JSpec<A extends JSpec<A, S>, S extends Enum<S>>
implements IAttacker<A, S>,
MoveSet.ReloadListener<A, S> {
    private MoveSet<A, S> moveSet;
    private final MoveMap<A, S> moveMap = new MoveMapImpl();
    private final SpecType type;
    public final LivingEntity user;
    public final Player player;
    public int moveStun = 0;
    private boolean performedThisTick;
    private S state;
    private MoveUsage moveUsage;
    public AbstractMove<?, ? super A> curMove;
    public AbstractMove<?, ? super A> previousAttack;
    public MoveInputType queuedMove;
    public int armorPoints = 0;
    private boolean holding = false;
    private MoveInputType holdingType = null;

    protected JSpec(SpecType type, LivingEntity livingEntity) {
        Player playerEntity;
        this.type = type;
        LivingEntity livingEntity2 = this.user = livingEntity;
        this.player = livingEntity2 instanceof Player ? (playerEntity = (Player)livingEntity2) : null;
        this.moveSet = MoveSetManager.get(type, "default");
        if (this.moveSet == null) {
            throw new NoSuchElementException("No 'default' move set found for spec " + String.valueOf(type));
        }
        this.moveSet.registerListener(this);
    }

    public SpecData getSpecData() {
        return this.type.getData();
    }

    @Override
    public LivingEntity getUser() {
        return this.user;
    }

    @Override
    public LivingEntity getBaseEntity() {
        return this.user;
    }

    @Override
    public DamageSource getDamageSource() {
        return JDamageSources.create(this.user.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268464_);
    }

    @Override
    public boolean hasUser() {
        return this.user != null;
    }

    @Override
    public LivingEntity getUserOrThrow() {
        return Objects.requireNonNull(this.user, "Player must not be null");
    }

    @Override
    public AbstractMove<?, ? super A> getCurrentMove() {
        return this.curMove;
    }

    @Override
    public void setCurrentMove(@Nullable AbstractMove<?, ? super A> move) {
        this.previousAttack = this.curMove;
        this.curMove = move;
        if (this.curMove != null) {
            this.moveUsage = new MoveUsage(this.user.f_19797_, move);
        }
    }

    @Override
    public void queueMove(MoveInputType type) {
        if (this.user == null) {
            return;
        }
        this.queuedMove = type;
    }

    @Override
    public void setState(S state) {
        this.state = state;
        this.setAnimation(((SpecAnimationState)state).getKey(this.getThis()), this.moveStun, 1.0f);
    }

    @Override
    public void playAttackerSound(SoundEvent sound, float volume, float pitch) {
        this.user.m_9236_().m_6263_(null, this.user.m_20185_(), this.user.m_20186_(), this.user.m_20189_(), sound, SoundSource.PLAYERS, volume, pitch);
    }

    @Override
    public void onMoveSetReload(MoveSet<A, S> moveSet) {
        if (!this.moveSet.getName().equals(moveSet.getName())) {
            return;
        }
        this.switchMoveSet(moveSet);
    }

    public void switchMoveSet(String name) {
        MoveSet moveSet = MoveSetManager.get(this.getType(), name);
        if (moveSet == null) {
            JCraft.LOGGER.error("Move set '{}' not found for {}", (Object)name, (Object)this.getType());
            return;
        }
        this.switchMoveSet(moveSet);
    }

    private void switchMoveSet(MoveSet<A, S> moveSet) {
        this.moveSet = moveSet;
        moveSet.registerListener(this);
        this.moveMap.copyFrom(moveSet.getMoveMap());
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.getCurrentMove() != null) {
            if (this.getCurrentMove().onInitMove(this.getThis(), moveClass)) {
                return true;
            }
            if (this.getCurrentMove().getFollowup() != null && this.getCurrentMove().getFollowupFrame().isPresent() && this.getCurrentMove().getMoveClass() == moveClass && this.getMoveStun() <= this.getCurrentMove().getFollowupFrame().getAsInt()) {
                this.moveMap.initiateFollowup(this.getThis(), this.getCurrentMove(), false, 0);
            }
        }
        return this.handleMove(moveClass);
    }

    @Override
    public boolean canHoldMove(@Nullable MoveInputType type) {
        if (type == null || type.getMoveClass() == null) {
            return false;
        }
        boolean crouching = this.hasUser() && this.user.m_6144_();
        boolean aerial = this.hasUser() && !this.user.m_20096_();
        MoveMap.Entry<IAttacker, S> entry = this.moveMap.getFirstValidEntry(type.getMoveClass(), this.getThis(), crouching, aerial);
        return entry == null ? type.isHoldable() : ((Boolean)MoreObjects.firstNonNull((Object)entry.getMove().getIsHoldable(), (Object)type.isHoldable())).booleanValue();
    }

    public final void onUserMoveInput(MoveInputType type, boolean pressed, boolean moveInitiated) {
        this.onUserMoveInput(this.curMove, type, pressed, moveInitiated);
    }

    @Override
    public boolean canAttack() {
        return this.moveStun <= 0 && !JUtils.isAffectedByTimeStop((Entity)this.user) && !this.user.m_21023_((MobEffect)JStatusRegistry.DAZED.get());
    }

    public boolean handleMove(MoveClass moveClass) {
        return this.handleMove(moveClass, 1.0f);
    }

    public boolean handleMove(MoveClass moveClass, float animationSpeed) {
        boolean crouching = this.hasUser() && this.user.m_6144_();
        boolean aerial = this.hasUser() && !this.user.m_20096_();
        MoveMap.Entry<IAttacker, S> entry = this.moveMap.getFirstValidEntry(moveClass, this.getThis(), crouching, aerial);
        if (entry == null) {
            return false;
        }
        if (this.user.m_6144_()) {
            if (entry.getCrouchingVariant() != null) {
                entry = entry.getCrouchingVariant();
            }
        } else if (!this.user.m_20096_() && entry.getAerialVariant() != null) {
            entry = entry.getAerialVariant();
        }
        return this.handleMove(entry.getMove(), entry.getCooldownType(), entry.getAnimState(), animationSpeed);
    }

    public boolean handleMove(AbstractMove<?, ? super A> move, CooldownType cooldownType, S state) {
        return this.handleMove(move, cooldownType, state, 1.0f);
    }

    public boolean handleMove(AbstractMove<?, ? super A> move, CooldownType cooldownType, @Nullable S state, float animationSpeed) {
        IntObjectPair<AbstractMove<?, ? super A>> finisher;
        if (!move.canBeInitiated(this.getThis())) {
            return false;
        }
        if (cooldownType != null && move.getCooldown() > 0) {
            CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(this.user);
            int cd = cooldowns.getCooldown(cooldownType);
            if (cd > 0) {
                return false;
            }
            if (!move.isManualCooldown()) {
                cooldowns.setCooldown(cooldownType, move.getCooldown());
            }
        }
        move = animationSpeed == 1.0f ? move : ((AbstractMove)((AbstractMove)move.copy()).withDuration((int)((float)move.getDuration() / animationSpeed))).withWindup((int)((float)move.getWindup() / animationSpeed));
        move.onInitiate(this.getThis());
        if (move.getDuration() == 0) {
            move.perform(this.getThis(), this.getUserOrThrow());
            return true;
        }
        this.setCurrentMove(move);
        this.moveStun = move.getDuration();
        AbstractMove<?, ? super A> cd = this.curMove;
        if (cd instanceof AbstractMultiHitAttack) {
            AbstractMultiHitAttack multiHitAttack = (AbstractMultiHitAttack)cd;
            multiHitAttack.withHitMoments((IntCollection)IntSet.of((int[])multiHitAttack.getHitMoments().intStream().map(i -> (int)((float)i / animationSpeed)).toArray()));
        }
        if ((finisher = move.getFinisher()) != null) {
            int finisherSwapTick = (int)((float)finisher.leftInt() / animationSpeed);
            move.modifyFinisherTime(finisherSwapTick);
            int finisherWindupTime = ((AbstractMove)finisher.right()).getWindup() + 1;
            if (this.moveStun < finisherWindupTime) {
                this.moveStun = finisherWindupTime;
            }
        }
        this.armorPoints = move.getArmor();
        if (state != null) {
            this.state = state;
            this.setAnimation(((SpecAnimationState)this.state).getKey(this.getThis()), this.moveStun, animationSpeed);
        }
        return true;
    }

    public void setAnimation(String animationID, int duration, float animationSpeed) {
        if (this.player == null) {
            LivingEntity livingEntity = this.user;
            if (livingEntity instanceof JSpecHolder) {
                JSpecHolder specHolder = (JSpecHolder)livingEntity;
                specHolder.setAnimation(animationID, animationSpeed);
            } else {
                JCraft.LOGGER.error("Tried to set animation for non-player entity with JSpec that does not implement JSpecHolder!");
            }
        } else {
            PlayerAnimPacket.sendSpec(this.player, JUtils.around((ServerLevel)this.user.m_9236_(), this.user.m_20182_(), JUtils.PLAYER_ANIMATION_DIST), animationID, duration, animationSpeed);
        }
    }

    @Override
    public void cancelMove() {
        this.cancelMove(false);
    }

    public void cancelMove(boolean offensiveCancel) {
        if (this.curMove != null) {
            if (offensiveCancel && !this.performedThisTick && this.curMove.shouldPerform(this.getThis(), this.getMoveStun() - 1)) {
                this.setPerformedThisTick(true);
                this.curMove.perform(this.getThis(), this.getUserOrThrow());
            }
            if (this.curMove != null) {
                this.curMove.onCancel(this.getThis());
            }
        }
        this.curMove = null;
        this.queuedMove = null;
        this.armorPoints = 0;
        this.moveStun = 0;
        if (this.user == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(13);
        buf.writeInt(this.user.m_19879_());
        ServerChannelFeedbackPacket.send(JUtils.around((ServerLevel)this.user.m_9236_(), this.user.m_20182_(), JUtils.PLAYER_ANIMATION_DIST), buf);
    }

    public boolean shouldSneak() {
        return false;
    }

    public void processAttackClient() {
    }

    public void tickSpec() {
        if (this.user.m_5833_()) {
            return;
        }
        Level world = this.user.m_9236_();
        if (world.m_5776_()) {
            if (this.moveStun > 0) {
                --this.moveStun;
                this.processAttackClient();
            }
            return;
        }
        this.moveMap.tickMoves(this.getThis());
        if (this.moveStun <= 0) {
            this.armorPoints = 0;
            if (this.queuedMove != null) {
                this.initMove(this.queuedMove.getMoveClass());
                this.queuedMove = null;
            }
            if (this.curMove != this.previousAttack && this.curMove != null) {
                this.previousAttack = this.curMove;
            }
            return;
        }
        AbstractMove<?, A> move = this.curMove;
        --this.moveStun;
        if (move != null) {
            MoveInputType curMoveInputType = MoveInputType.fromMoveClass(move.getMoveClass());
            if (this.canHoldMove(curMoveInputType) && this.getHoldingType() != curMoveInputType) {
                this.setHoldingType(curMoveInputType);
            }
            MoveTickQueue.queueTick(this.getThis(), move, this.getMoveStun());
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isHolding() {
        return this.holding;
    }

    @Override
    public void setHolding(boolean holding) {
        this.holding = holding;
    }

    @Override
    public MoveInputType getHoldingType() {
        return this.holdingType;
    }

    @Override
    public void setHoldingType(MoveInputType holdingType) {
        this.holdingType = holdingType;
    }

    @Override
    public void setPerformedThisTick(boolean b) {
        this.performedThisTick = b;
    }

    @Override
    public boolean performedThisTick() {
        return this.performedThisTick;
    }

    @Override
    public abstract A getThis();

    @Override
    public void executePlan(int aiLevel, AttackerBrainInfo info, CombatInstantContext combatCtx) {
        PathfinderMob pathfinderMob;
        CombatEntityContext attackerCtx = combatCtx.getAttackerCtx();
        CombatEntityContext targetCtx = combatCtx.getTargetCtx();
        Mob mob = (Mob)attackerCtx.entity();
        PathfinderMob pathfinder = mob instanceof PathfinderMob ? (pathfinderMob = (PathfinderMob)mob) : null;
        LivingEntity target = targetCtx.entity();
        LookControl lookControl = mob.m_21563_();
        JumpControl jumpControl = mob.m_21569_();
        AttackerBrainInfo.State state = info.getState();
        RandomSource random = this.getBaseEntity().m_217043_();
        switch (state) {
            case IDLE: {
                break;
            }
            case APPROACH: {
                PathNavigation navigation = mob.m_21573_();
                navigation.m_5624_((Entity)target, 1.0);
                lookControl.m_148051_((Entity)target);
                if (aiLevel < 3 || !(random.m_188501_() > 0.2f)) break;
                DashData.tryDash(random.m_188499_() ? -1 : 1, random.m_188499_() ? -1 : 1, this.user);
                if (!random.m_188499_()) break;
                jumpControl.m_24901_();
                break;
            }
            case PRESSURE: 
            case COMBOING: {
                PathNavigation navigation = mob.m_21573_();
                Path path = navigation.m_6570_((Entity)target, 1);
                if (path != null) {
                    navigation.m_26536_(path, 1.0);
                }
                lookControl.m_148051_((Entity)target);
                if (info.desiresNoAttack()) break;
                this.doMoveSelection(info, mob, target, mob.m_21569_(), targetCtx.stand(), targetCtx.standAttack() != null ? targetCtx.standAttack() : targetCtx.specAttack(), combatCtx.getDistanceBetween(), targetCtx.moveStun(), targetCtx.stun() != null ? targetCtx.stun().m_19557_() : 0);
                if (aiLevel < 3 || !(random.m_188501_() > 0.1f)) break;
                DashData.tryDash(1, random.m_188499_() ? -1 : 1, this.user);
                break;
            }
            case DISENGAGE: 
            case KEEPAWAY: 
            case DEFENSE: {
                Vec3 away;
                if (pathfinder == null) break;
                if (info.getAwayPos() == null || pathfinder.m_20238_(info.getAwayPos()) < 3.0) {
                    info.setAwayPos(DefaultRandomPos.m_148407_((PathfinderMob)pathfinder, (int)(state == AttackerBrainInfo.State.DISENGAGE ? 16 : 8), (int)7, (Vec3)target.m_20182_()));
                }
                if ((away = info.getAwayPos()) != null) {
                    mob.m_21573_().m_26519_(away.f_82479_, away.f_82480_, away.f_82481_, 1.0);
                }
                lookControl.m_148051_((Entity)target);
                if (info.desiresNoAttack()) break;
                this.doMoveSelection(info, mob, target, mob.m_21569_(), targetCtx.stand(), targetCtx.standAttack() != null ? targetCtx.standAttack() : targetCtx.specAttack(), combatCtx.getDistanceBetween(), targetCtx.moveStun(), targetCtx.stun() != null ? targetCtx.stun().m_19557_() : 0);
                if (aiLevel < 3 || !(random.m_188501_() > 0.1f)) break;
                DashData.tryDash(1, random.m_188499_() ? -1 : 1, this.user);
                break;
            }
            case COMBOED: {
                boolean burstCondition;
                boolean enemyIsActing;
                if (aiLevel <= 3) {
                    return;
                }
                MobEffectInstance stun = combatCtx.getAttackerCtx().stun();
                if (stun == null) {
                    return;
                }
                boolean lowHP = this.user.m_21223_() < this.user.m_21233_() / 2.0f || this.user.m_21223_() < 5.0f;
                boolean bl = enemyIsActing = targetCtx.standAttack() != null || targetCtx.specAttack() != null;
                if (aiLevel >= 15) {
                    burstCondition = lowHP && enemyIsActing || random.m_188501_() < 0.02f;
                } else if (aiLevel >= 10) {
                    burstCondition = lowHP || enemyIsActing || random.m_188501_() < 0.05f;
                } else {
                    boolean bl2 = burstCondition = random.m_188501_() < 0.1f;
                }
                if (!burstCondition) break;
                JCraft.comboBreak((ServerLevel)this.user.m_9236_(), this.user, stun);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)info.getState()));
            }
        }
    }

    @Override
    public AbstractMove<?, ? super A> doMoveSelection(AttackerBrainInfo info, Mob mob, LivingEntity target, JumpControl mobJumpControl, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack, double distance, int enemyMoveStun, int stunTicks) {
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)mob);
        if (stand != null && stand.allowMoveHandling()) {
            return null;
        }
        return IAttacker.super.doMoveSelection(info, mob, target, mobJumpControl, enemyStand, enemyAttack, distance, enemyMoveStun, stunTicks);
    }

    public MoveSet<A, S> getMoveSet() {
        return this.moveSet;
    }

    @Override
    public MoveMap<A, S> getMoveMap() {
        return this.moveMap;
    }

    public SpecType getType() {
        return this.type;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getMoveStun() {
        return this.moveStun;
    }

    public boolean isPerformedThisTick() {
        return this.performedThisTick;
    }

    @Override
    public S getState() {
        return this.state;
    }

    public AbstractMove<?, ? super A> getCurMove() {
        return this.curMove;
    }

    public AbstractMove<?, ? super A> getPreviousAttack() {
        return this.previousAttack;
    }

    public MoveInputType getQueuedMove() {
        return this.queuedMove;
    }

    public int getArmorPoints() {
        return this.armorPoints;
    }

    @Override
    public void setMoveStun(int moveStun) {
        this.moveStun = moveStun;
    }

    @Override
    public MoveUsage getMoveUsage() {
        return this.moveUsage;
    }
}

