/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.spec;

import java.util.function.Function;
import lombok.NonNull;
import net.arna.jcraft.api.IAttackerType;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.common.data.AttackerDataLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SpecType
implements IAttackerType {
    private final ResourceLocation id;
    private final Function<LivingEntity, JSpec<?, ?>> factory;

    public JSpec<?, ?> createSpec(@NonNull LivingEntity user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.factory.apply(user);
    }

    public SpecData getData() {
        return AttackerDataLoader.getSpecData(this.getId());
    }

    @Override
    public final String kind() {
        return "spec";
    }

    public String toString() {
        return "SpecType(id=" + String.valueOf(this.getId()) + ", factory=" + String.valueOf(this.factory) + ")";
    }

    private SpecType(ResourceLocation id, Function<LivingEntity, JSpec<?, ?>> factory) {
        this.id = id;
        this.factory = factory;
    }

    public static SpecType of(ResourceLocation id, Function<LivingEntity, JSpec<?, ?>> factory) {
        return new SpecType(id, factory);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }
}

