/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.spec;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.SpecType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class SpecTypeUtil {
    public static boolean isNone(SpecType type) {
        return type == null || type == JSpecTypeRegistry.NONE.get();
    }

    public static Stream<SpecType> streamAll() {
        return StreamSupport.stream(JRegistries.SPEC_TYPE_REGISTRY.spliterator(), false);
    }

    public static Stream<SpecType> streamAllRegular() {
        return SpecTypeUtil.streamAll().filter(type -> type != JSpecTypeRegistry.NONE.get());
    }

    @Nullable
    public static SpecType readFromNBT(CompoundTag nbt, String key) {
        if (nbt.m_128425_(key, 3)) {
            int ordinal = nbt.m_128451_(key);
            return Optional.ofNullable((RegistrySupplier)JSpecTypeRegistry.LEGACY_ORDINALS.get(ordinal)).map(Supplier::get).orElse(null);
        }
        if (nbt.m_128425_(key, 8)) {
            String id = nbt.m_128461_(key);
            return (SpecType)JRegistries.SPEC_TYPE_REGISTRY.get(new ResourceLocation(id));
        }
        return null;
    }

    private SpecTypeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

