/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.spec;

import java.util.HashMap;
import java.util.Map;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.constant.DefaultAnimations;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.component.player.CommonSpecComponent;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.JSpecHolder;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.tickable.JEnemies;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpecUserMob
extends PathfinderMob
implements JSpecHolder,
GeoEntity {
    protected final CommonSpecComponent component;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> ANIMATION_RESET = SynchedEntityData.m_135353_(SpecUserMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SpecUserMob.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> ANIMATION_SPEED = SynchedEntityData.m_135353_(SpecUserMob.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Map<String, RawAnimation> cachedAnimations = new HashMap<String, RawAnimation>();

    public SpecUserMob(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.component = JComponentPlatformUtils.getSpecData((LivingEntity)this);
        if (level.m_5776_()) {
            return;
        }
        JEnemies.add((Mob)this);
    }

    public void m_8119_() {
        this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_());
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(ANIMATION_RESET, (Object)false);
        JSpec<?, ?> spec = this.getSpec();
        if (spec != null) {
            LivingEntity target = this.m_5448_();
            if (target != null) {
                Vec3 posTowards;
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                if (target.m_20280_((Entity)this) > 1.0 && (posTowards = DefaultRandomPos.m_148412_((PathfinderMob)this, (int)2, (int)7, (Vec3)target.m_20182_(), (double)1.5707963705062866)) != null) {
                    this.m_21573_().m_26519_(posTowards.f_82479_, posTowards.f_82480_, posTowards.f_82481_, 1.0);
                }
            }
            spec.tickSpec();
            if (spec.getMoveStun() <= 0) {
                this.setAnimation("", 1.0f);
            }
        } else {
            this.setAnimation("", 1.0f);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)"");
        this.f_19804_.m_135372_(ANIMATION_SPEED, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(ANIMATION_RESET, (Object)false);
    }

    @Override
    public void setSpecType(SpecType type) {
        this.component.setType(type);
    }

    @Override
    public JSpec<?, ?> getSpec() {
        return this.component.getSpec();
    }

    @Override
    public void setAnimation(String animationID, float animationSpeed) {
        this.f_19804_.m_135381_(ANIMATION_RESET, (Object)((String)this.f_19804_.m_135370_(ANIMATION)).equals(animationID));
        this.f_19804_.m_135381_(ANIMATION, (Object)animationID);
        this.f_19804_.m_135381_(ANIMATION_SPEED, (Object)Float.valueOf(animationSpeed));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        String animation;
        if (((Boolean)this.f_19804_.m_135370_(ANIMATION_RESET)).booleanValue()) {
            state.resetCurrentAnimation();
        }
        if ((animation = (String)this.f_19804_.m_135370_(ANIMATION)).isEmpty()) {
            return PlayState.STOP;
        }
        if (!cachedAnimations.containsKey(animation)) {
            cachedAnimations.put(animation, RawAnimation.begin().thenLoop(animation));
        }
        float speed = ((Float)this.f_19804_.m_135370_(ANIMATION_SPEED)).floatValue();
        state.setControllerSpeed(speed);
        return state.setAndContinue(cachedAnimations.get(animation));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

