/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.stand;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.SummonData;
import net.minecraft.network.chat.Component;

public class StandData {
    public static final StandData EMPTY = StandData.of(StandInfo.of((Component)Component.m_237115_((String)"entity.jcraft.nostand"))).withObtainable(false);
    public static final Codec<StandData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("idle_distance", (Object)Float.valueOf(1.25f)).forGetter(StandData::getIdleDistance), (App)Codec.FLOAT.fieldOf("idle_rotation").forGetter(StandData::getIdleRotation), (App)Codec.FLOAT.optionalFieldOf("block_distance", (Object)Float.valueOf(0.75f)).forGetter(StandData::getBlockDistance), (App)Codec.BOOL.optionalFieldOf("evolution", (Object)false).forGetter(StandData::isEvolution), (App)Codec.BOOL.optionalFieldOf("obtainable", (Object)true).forGetter(StandData::isObtainable), (App)StandInfo.CODEC.fieldOf("info").forGetter(StandData::getInfo), (App)SummonData.CODEC.optionalFieldOf("summon_data", (Object)SummonData.of(() -> null)).forGetter(StandData::getSummonData)).apply((Applicative)instance, StandData::new));
    private float idleDistance;
    private float idleRotation;
    private float blockDistance;
    private boolean evolution;
    private boolean obtainable;
    @NonNull
    private final StandInfo info;
    @NonNull
    private SummonData summonData;

    public static StandData of(@NonNull StandInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return StandData.builder().info(info).build();
    }

    public StandData withInfo(UnaryOperator<StandInfo.Builder> newInfo) {
        return this.withInfo(((StandInfo.Builder)newInfo.apply(this.info.toBuilder())).build());
    }

    private static float $default$idleDistance() {
        return 1.25f;
    }

    private static float $default$idleRotation() {
        return -45.0f;
    }

    private static float $default$blockDistance() {
        return 0.75f;
    }

    private static boolean $default$obtainable() {
        return true;
    }

    private static SummonData $default$summonData() {
        return SummonData.of(() -> null);
    }

    StandData(float idleDistance, float idleRotation, float blockDistance, boolean evolution, boolean obtainable, @NonNull StandInfo info, @NonNull SummonData summonData) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (summonData == null) {
            throw new NullPointerException("summonData is marked non-null but is null");
        }
        this.idleDistance = idleDistance;
        this.idleRotation = idleRotation;
        this.blockDistance = blockDistance;
        this.evolution = evolution;
        this.obtainable = obtainable;
        this.info = info;
        this.summonData = summonData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().idleDistance(this.idleDistance).idleRotation(this.idleRotation).blockDistance(this.blockDistance).evolution(this.evolution).obtainable(this.obtainable).info(this.info).summonData(this.summonData);
    }

    public float getIdleDistance() {
        return this.idleDistance;
    }

    public float getIdleRotation() {
        return this.idleRotation;
    }

    public float getBlockDistance() {
        return this.blockDistance;
    }

    public boolean isEvolution() {
        return this.evolution;
    }

    public boolean isObtainable() {
        return this.obtainable;
    }

    @NonNull
    public StandInfo getInfo() {
        return this.info;
    }

    @NonNull
    public SummonData getSummonData() {
        return this.summonData;
    }

    public StandData withIdleDistance(float idleDistance) {
        return this.idleDistance == idleDistance ? this : new StandData(idleDistance, this.idleRotation, this.blockDistance, this.evolution, this.obtainable, this.info, this.summonData);
    }

    public StandData withIdleRotation(float idleRotation) {
        return this.idleRotation == idleRotation ? this : new StandData(this.idleDistance, idleRotation, this.blockDistance, this.evolution, this.obtainable, this.info, this.summonData);
    }

    public StandData withBlockDistance(float blockDistance) {
        return this.blockDistance == blockDistance ? this : new StandData(this.idleDistance, this.idleRotation, blockDistance, this.evolution, this.obtainable, this.info, this.summonData);
    }

    public StandData withEvolution(boolean evolution) {
        return this.evolution == evolution ? this : new StandData(this.idleDistance, this.idleRotation, this.blockDistance, evolution, this.obtainable, this.info, this.summonData);
    }

    public StandData withObtainable(boolean obtainable) {
        return this.obtainable == obtainable ? this : new StandData(this.idleDistance, this.idleRotation, this.blockDistance, this.evolution, obtainable, this.info, this.summonData);
    }

    public StandData withInfo(@NonNull StandInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.info == info ? this : new StandData(this.idleDistance, this.idleRotation, this.blockDistance, this.evolution, this.obtainable, info, this.summonData);
    }

    public StandData withSummonData(@NonNull SummonData summonData) {
        if (summonData == null) {
            throw new NullPointerException("summonData is marked non-null but is null");
        }
        return this.summonData == summonData ? this : new StandData(this.idleDistance, this.idleRotation, this.blockDistance, this.evolution, this.obtainable, this.info, summonData);
    }

    public String toString() {
        return "StandData(idleDistance=" + this.getIdleDistance() + ", idleRotation=" + this.getIdleRotation() + ", blockDistance=" + this.getBlockDistance() + ", evolution=" + this.isEvolution() + ", obtainable=" + this.isObtainable() + ", info=" + String.valueOf(this.getInfo()) + ", summonData=" + String.valueOf(this.getSummonData()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandData)) {
            return false;
        }
        StandData other = (StandData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getIdleDistance(), other.getIdleDistance()) != 0) {
            return false;
        }
        if (Float.compare(this.getIdleRotation(), other.getIdleRotation()) != 0) {
            return false;
        }
        if (Float.compare(this.getBlockDistance(), other.getBlockDistance()) != 0) {
            return false;
        }
        if (this.isEvolution() != other.isEvolution()) {
            return false;
        }
        if (this.isObtainable() != other.isObtainable()) {
            return false;
        }
        StandInfo this$info = this.getInfo();
        StandInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        SummonData this$summonData = this.getSummonData();
        SummonData other$summonData = other.getSummonData();
        return !(this$summonData == null ? other$summonData != null : !((Object)this$summonData).equals(other$summonData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getIdleDistance());
        result = result * 59 + Float.floatToIntBits(this.getIdleRotation());
        result = result * 59 + Float.floatToIntBits(this.getBlockDistance());
        result = result * 59 + (this.isEvolution() ? 79 : 97);
        result = result * 59 + (this.isObtainable() ? 79 : 97);
        StandInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        SummonData $summonData = this.getSummonData();
        result = result * 59 + ($summonData == null ? 43 : ((Object)$summonData).hashCode());
        return result;
    }

    public static class Builder {
        private boolean idleDistance$set;
        private float idleDistance$value;
        private boolean idleRotation$set;
        private float idleRotation$value;
        private boolean blockDistance$set;
        private float blockDistance$value;
        private boolean evolution;
        private boolean obtainable$set;
        private boolean obtainable$value;
        private StandInfo info;
        private boolean summonData$set;
        private SummonData summonData$value;

        Builder() {
        }

        public Builder idleDistance(float idleDistance) {
            this.idleDistance$value = idleDistance;
            this.idleDistance$set = true;
            return this;
        }

        public Builder idleRotation(float idleRotation) {
            this.idleRotation$value = idleRotation;
            this.idleRotation$set = true;
            return this;
        }

        public Builder blockDistance(float blockDistance) {
            this.blockDistance$value = blockDistance;
            this.blockDistance$set = true;
            return this;
        }

        public Builder evolution(boolean evolution) {
            this.evolution = evolution;
            return this;
        }

        public Builder obtainable(boolean obtainable) {
            this.obtainable$value = obtainable;
            this.obtainable$set = true;
            return this;
        }

        public Builder info(@NonNull StandInfo info) {
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            this.info = info;
            return this;
        }

        public Builder summonData(@NonNull SummonData summonData) {
            if (summonData == null) {
                throw new NullPointerException("summonData is marked non-null but is null");
            }
            this.summonData$value = summonData;
            this.summonData$set = true;
            return this;
        }

        public StandData build() {
            float idleDistance$value = this.idleDistance$value;
            if (!this.idleDistance$set) {
                idleDistance$value = StandData.$default$idleDistance();
            }
            float idleRotation$value = this.idleRotation$value;
            if (!this.idleRotation$set) {
                idleRotation$value = StandData.$default$idleRotation();
            }
            float blockDistance$value = this.blockDistance$value;
            if (!this.blockDistance$set) {
                blockDistance$value = StandData.$default$blockDistance();
            }
            boolean obtainable$value = this.obtainable$value;
            if (!this.obtainable$set) {
                obtainable$value = StandData.$default$obtainable();
            }
            SummonData summonData$value = this.summonData$value;
            if (!this.summonData$set) {
                summonData$value = StandData.$default$summonData();
            }
            return new StandData(idleDistance$value, idleRotation$value, blockDistance$value, this.evolution, obtainable$value, this.info, summonData$value);
        }

        public String toString() {
            return "StandData.Builder(idleDistance$value=" + this.idleDistance$value + ", idleRotation$value=" + this.idleRotation$value + ", blockDistance$value=" + this.blockDistance$value + ", evolution=" + this.evolution + ", obtainable$value=" + this.obtainable$value + ", info=" + String.valueOf(this.info) + ", summonData$value=" + String.valueOf(this.summonData$value) + ")";
        }
    }
}

