/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.stand;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.AttackData;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.CombatEntityContext;
import net.arna.jcraft.common.ai.CombatInstantContext;
import net.arna.jcraft.common.attack.core.MoveMapImpl;
import net.arna.jcraft.common.attack.core.itfs.AttackRotationOffsetOverride;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.marker.BlockMarkerMoves;
import net.arna.jcraft.common.network.c2s.PlayerInputPacket;
import net.arna.jcraft.common.tickable.MoveTickQueue;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.DashData;
import net.arna.jcraft.common.util.ICustomDamageHandler;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class StandEntity<E extends StandEntity<E, S>, S extends Enum<S>>
extends Mob
implements GeoEntity,
IAttacker<E, S>,
ICustomDamageHandler,
MoveSet.ReloadListener<E, S> {
    private MoveSet<E, S> moveSet;
    @NonNull
    private final MoveMap<E, S> moveMap = new MoveMapImpl<E, S>();
    private static final EntityDataAccessor<String> MOVE_SET = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SAMESTATE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RESET = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MOVESTUN = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> ROTATIONOFFSET = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DISTANCEOFFSET = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA_OVERRIDE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STANDGAUGE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> FREEX;
    private static final EntityDataAccessor<Float> FREEY;
    private static final EntityDataAccessor<Float> FREEZ;
    private static final EntityDataAccessor<Boolean> FREE;
    private static final EntityDataAccessor<Boolean> REMOTE;
    private static final EntityDataAccessor<String> USER_POSE;
    protected int tsTime = 0;
    private float prevAlpha = 1.0f;
    @Nullable
    private LivingEntity user = null;
    public boolean wantToBlock = false;
    public boolean blocking = false;
    private boolean holding = false;
    protected boolean idleOverride = false;
    protected boolean standby = false;
    public static final float ATTACK_ROTATION = 90.0f;
    protected float maxStandGauge = 90.0f;
    protected MoveInputType queuedMove;
    private MoveInputType holdingType;
    private AbstractMove<?, ? super E> curMove;
    private MoveUsage moveUsage;
    public AbstractMove<?, ? super E> prevMove;
    public int armorPoints;
    private boolean performedThisTick;
    public int lastRemoteInputTime;
    public Vec3 remoteSpeed = Vec3.f_82478_;
    private double remoteForwardInput = 0.0;
    private double remoteSideInput = 0.0;
    private boolean remoteJumpInput = false;
    private boolean remoteSneakInput = false;
    private boolean playSummonAnim = true;
    private boolean playSummonSound = true;
    private boolean playDesummonSound = true;
    private final StandType standType;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    protected Vector3f[] auraColors = new Vector3f[]{new Vector3f(), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};

    protected StandEntity(StandType type, Level world) {
        super(type.getEntityType(), world);
        this.moveSet = MoveSetManager.get(type, "default");
        if (this.moveSet == null) {
            throw new NoSuchElementException("No 'default' move set found for stand" + String.valueOf(type));
        }
        this.moveSet.registerListener(this);
        this.f_19794_ = true;
        this.standType = type;
        this.f_19811_ = true;
        assert (this.getThis() == this);
    }

    public boolean allowMoveHandling() {
        return true;
    }

    @Override
    @NonNull
    public LivingEntity getUserOrThrow() {
        if (this.user == null) {
            throw new NullPointerException("No user set");
        }
        return this.user;
    }

    public StandData getStandData() {
        return this.getStandType().getData();
    }

    @Override
    public boolean hasUser() {
        return this.user != null;
    }

    public int getModeOrdinal() {
        return 0;
    }

    @Override
    public S getState() {
        return this.boxState(this.getRawState());
    }

    public int getRawState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    private boolean isReset() {
        return (Boolean)this.f_19804_.m_135370_(RESET);
    }

    protected void setReset(boolean reset) {
        this.f_19804_.m_135381_(RESET, (Object)reset);
    }

    public void setStateNoReset(@Nullable S state) {
        if (state == null) {
            return;
        }
        this.setRawStateNoReset(((Enum)state).ordinal());
    }

    public void setRawStateNoReset(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    @Override
    public void setState(S state) {
        this.setRawState(((Enum)state).ordinal());
    }

    public void setRawState(int state) {
        int oldState = this.getRawState();
        boolean sameState = oldState == state || oldState <= 1;
        this.f_19804_.m_135381_(STATE, (Object)state);
        this.f_19804_.m_135381_(SAMESTATE, (Object)sameState);
        this.setReset(!sameState && state == ((Enum)this.getIdleState()).ordinal());
    }

    public boolean isSameState() {
        return (Boolean)this.f_19804_.m_135370_(SAMESTATE);
    }

    public void setSameState(boolean sameState) {
        this.f_19804_.m_135381_(SAMESTATE, (Object)sameState);
    }

    @Override
    public int getMoveStun() {
        return (Integer)this.f_19804_.m_135370_(MOVESTUN);
    }

    @Override
    public void setMoveStun(int moveStun) {
        this.f_19804_.m_135381_(MOVESTUN, (Object)moveStun);
    }

    public int getSkin() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(SKIN)), (int)0, (int)this.getStandData().getInfo().getSkinCount());
    }

    public void setSkin(int skin) {
        if (skin < 0 || skin >= this.getStandData().getInfo().getSkinCount()) {
            skin = 0;
        }
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public float getRotationOffset() {
        return ((Float)this.f_19804_.m_135370_(ROTATIONOFFSET)).floatValue();
    }

    public void setRotationOffset(float rotationOffset) {
        this.f_19804_.m_135381_(ROTATIONOFFSET, (Object)Float.valueOf(rotationOffset));
    }

    public float getDistanceOffset() {
        return ((Float)this.f_19804_.m_135370_(DISTANCEOFFSET)).floatValue();
    }

    public void setDistanceOffset(float distanceOffset) {
        this.f_19804_.m_135381_(DISTANCEOFFSET, (Object)Float.valueOf(distanceOffset));
    }

    public boolean hasAlphaOverride() {
        return this.getAlphaOverride() >= 0.0f;
    }

    public float getAlphaOverride() {
        return ((Float)this.f_19804_.m_135370_(ALPHA_OVERRIDE)).floatValue();
    }

    public void setAlphaOverride(float alpha) {
        this.f_19804_.m_135381_(ALPHA_OVERRIDE, (Object)Float.valueOf(alpha));
    }

    public void resetAlphaOverride() {
        this.setAlphaOverride(-1.0f);
    }

    public float getStandGauge() {
        return ((Float)this.f_19804_.m_135370_(STANDGAUGE)).floatValue();
    }

    public void setStandGauge(float standGauge) {
        this.f_19804_.m_135381_(STANDGAUGE, (Object)Float.valueOf(standGauge));
    }

    public boolean isFree() {
        return (Boolean)this.f_19804_.m_135370_(FREE);
    }

    public void setFree(boolean free) {
        this.f_19804_.m_135381_(FREE, (Object)free);
    }

    @Override
    public void onMoveSetReload(MoveSet<E, S> moveSet) {
        if (!this.moveSet.getName().equals(moveSet.getName())) {
            return;
        }
        this.moveMap.copyFrom(moveSet.getMoveMap());
    }

    protected void switchMoveSet(String name) {
        MoveSet moveSet = MoveSetManager.get(this.getStandType(), name);
        if (moveSet == null) {
            JCraft.LOGGER.error("Move set '{}' not found for {}", (Object)name, (Object)this.getStandType());
            return;
        }
        this.switchMoveSet(moveSet);
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_276349_(MOVE_SET, (Object)name, true);
        }
    }

    private void switchMoveSet(MoveSet<E, S> moveSet) {
        this.moveSet = moveSet;
        moveSet.registerListener(this);
        this.moveMap.copyFrom(moveSet.getMoveMap());
    }

    public void updateRemoteInputs(int f, int s, boolean j, boolean c) {
        Vec3 v = new Vec3((double)f, 0.0, (double)s).m_82541_();
        this.remoteForwardInput = v.f_82479_;
        this.remoteSideInput = v.f_82481_;
        this.remoteJumpInput = j;
        this.remoteSneakInput = c;
        this.lastRemoteInputTime = this.f_19797_;
    }

    public boolean getRemoteJumpInput() {
        return this.remoteJumpInput;
    }

    public boolean getRemoteSneakInput() {
        return this.remoteSneakInput;
    }

    @Override
    public boolean isRemote() {
        return (Boolean)this.f_19804_.m_135370_(REMOTE);
    }

    public boolean remoteControllable() {
        return true;
    }

    public boolean isRemoteAndControllable() {
        return this.isRemote() && this.remoteControllable();
    }

    public void setRemote(boolean r) {
        this.f_19804_.m_135381_(REMOTE, (Object)r);
        if (r) {
            this.beginRemote();
        } else {
            this.endRemote();
        }
    }

    public void togglePilotMode() {
        this.setRemote(!this.isRemote());
    }

    protected void beginRemote() {
        if (this.user == null) {
            return;
        }
        this.setFree(true);
        Vec3 fPos = this.user.m_20182_().m_82549_(this.user.m_20154_());
        this.remoteSpeed = this.user.m_20184_().m_82490_(2.0);
        this.setAlphaOverride(0.1f);
        this.m_19877_();
        this.f_19794_ = false;
        this.f_19812_ = true;
        this.m_20343_(fPos.f_82479_, this.user.m_20186_() + 0.5, fPos.f_82481_);
    }

    protected void endRemote() {
        this.setFree(false);
        this.resetAlphaOverride();
        if (this.user != null) {
            this.m_20329_((Entity)this.user);
        }
        this.f_19794_ = true;
    }

    public Vector3f getFreePos() {
        return new Vector3f(((Float)this.f_19804_.m_135370_(FREEX)).floatValue(), ((Float)this.f_19804_.m_135370_(FREEY)).floatValue(), ((Float)this.f_19804_.m_135370_(FREEZ)).floatValue());
    }

    public void setFreePos(Vector3f freePos) {
        this.f_19804_.m_135381_(FREEX, (Object)Float.valueOf(freePos.x()));
        this.f_19804_.m_135381_(FREEY, (Object)Float.valueOf(freePos.y()));
        this.f_19804_.m_135381_(FREEZ, (Object)Float.valueOf(freePos.z()));
    }

    public void setUserPose(@NonNull ResourceLocation poseId) {
        if (poseId == null) {
            throw new NullPointerException("poseId is marked non-null but is null");
        }
        this.f_19804_.m_135381_(USER_POSE, (Object)poseId.toString());
    }

    @NotNull
    public ResourceLocation getUserPose() {
        String pose = (String)this.f_19804_.m_135370_(USER_POSE);
        return pose.isEmpty() ? this.standType.getId() : new ResourceLocation(pose);
    }

    @Override
    public LivingEntity getBaseEntity() {
        return this;
    }

    @Override
    public DamageSource getDamageSource() {
        return JDamageSources.stand(this);
    }

    @Override
    @Nullable
    public AbstractMove<?, ? super E> getCurrentMove() {
        return this.curMove;
    }

    public boolean tryFollowUp(MoveClass in, MoveClass followupType) {
        AbstractMove<?, E> followup;
        if (in == followupType && this.curMove != null && this.curMove.getMoveClass() == followupType && this.getMoveStun() < this.curMove.getWindupPoint() && (followup = this.curMove.getFollowup()) != null) {
            this.setMove((AbstractMove<?, ? super E>)followup, (S)followup.getAnimation());
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentMove(@Nullable AbstractMove<?, ? super E> move) {
        this.prevMove = this.curMove;
        this.curMove = move;
        if (this.curMove != null) {
            this.moveUsage = new MoveUsage(this.f_19797_, this.curMove);
        }
    }

    @Override
    public void queueMove(@Nullable MoveInputType type) {
        if (this.user == null) {
            return;
        }
        if (type == null) {
            this.queuedMove = null;
            return;
        }
        MoveClass moveClass = type.getMoveClass(this.standby);
        if (moveClass != null) {
            for (MoveMap.Entry<E, S> entry : this.moveMap.getEntries(moveClass)) {
                if (entry.getMove().canBeQueued(this.getThis())) continue;
                return;
            }
        }
        if (type != MoveInputType.LIGHT || JComponentPlatformUtils.getCooldowns(this.user).getCooldown(CooldownType.STAND_LIGHT) <= 0) {
            this.queuedMove = type;
        }
    }

    @NotNull
    public Vec3 m_20154_() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVE_SET, (Object)"default");
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(SAMESTATE, (Object)false);
        this.f_19804_.m_135372_(RESET, (Object)true);
        this.f_19804_.m_135372_(MOVESTUN, (Object)0);
        this.f_19804_.m_135372_(SKIN, (Object)0);
        this.f_19804_.m_135372_(ROTATIONOFFSET, (Object)Float.valueOf(-90.0f));
        this.f_19804_.m_135372_(DISTANCEOFFSET, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(ALPHA_OVERRIDE, (Object)Float.valueOf(-1.0f));
        this.f_19804_.m_135372_(STANDGAUGE, (Object)Float.valueOf(45.0f));
        this.f_19804_.m_135372_(FREE, (Object)false);
        this.f_19804_.m_135372_(REMOTE, (Object)false);
        this.f_19804_.m_135372_(FREEX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FREEY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FREEZ, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(USER_POSE, (Object)"");
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (!MOVE_SET.equals(key) || !this.m_9236_().m_5776_()) {
            return;
        }
        this.switchMoveSet((String)this.f_19804_.m_135370_(MOVE_SET));
    }

    @Override
    public boolean canAttack() {
        if (this.user == null || JUtils.isAffectedByTimeStop((Entity)this.user) || this.user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return false;
        }
        if (this.isRemote() && this.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return false;
        }
        if (this.getCurrentMove() != null && !this.getCurrentMove().preventsMoves()) {
            return true;
        }
        return this.getMoveStun() <= 0;
    }

    public boolean shouldOffsetHeight() {
        return ((Enum)this.getState()).ordinal() > 0;
    }

    public boolean handleMove(MoveClass moveClass) {
        MoveMap.Entry entry = this.getFirstValidEntry(moveClass);
        if (entry == null) {
            return false;
        }
        AbstractMove move = entry.getMove();
        return this.handleMove((AbstractMove<?, ? super E>)(move.isCopyOnUse() ? move.copy() : move), entry.getCooldownType(), entry.getAnimState());
    }

    public boolean handleMove(AbstractMove<?, ? super E> move, CooldownType cooldownType, @Nullable S animState) {
        if (!move.canBeInitiated(this.getThis())) {
            return false;
        }
        if (cooldownType != null && move.getCooldown() > 0) {
            CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(this.getUser());
            int cooldown = cooldowns.getCooldown(cooldownType);
            if (cooldown > 0) {
                return false;
            }
            if (!move.isManualCooldown()) {
                cooldowns.setCooldown(cooldownType, move.getCooldown());
            }
        }
        this.setMove((AbstractMove<?, ? super E>)move, animState);
        return true;
    }

    @Override
    public void setMove(AbstractMove<?, ? super E> move, @Nullable S animState) {
        move.onInitiate(this.getThis());
        if (move.getDuration() == 0) {
            move.doPerform(this.getThis());
            return;
        }
        this.setCurrentMove((AbstractMove<?, ? super E>)move);
        this.setMoveStun(move.getDuration());
        if (animState != null) {
            this.setState(animState);
        }
        this.armorPoints = move.getArmor();
    }

    public final void onUserMoveInput(MoveInputType type, boolean pressed, boolean moveInitiated) {
        this.onUserMoveInput(this.getCurrentMove(), type, pressed, moveInitiated);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.getCurrentMove() != null) {
            if (this.getCurrentMove().onInitMove(this.getThis(), moveClass)) {
                return true;
            }
            if (this.getCurrentMove().getFollowup() != null && this.getCurrentMove().getFollowupFrame().isPresent() && this.getCurrentMove().getMoveClass() == moveClass && this.getMoveStun() <= this.getCurrentMove().getFollowupFrame().getAsInt()) {
                this.moveMap.initiateFollowup(this.getThis(), this.getCurrentMove(), false, 0);
            }
        }
        return this.handleMove(moveClass);
    }

    @Override
    public boolean canHoldMove(@Nullable MoveInputType type) {
        if (type == null || type.getMoveClass(this.standby) == null) {
            return false;
        }
        MoveMap.Entry entry = this.getFirstValidEntry(type.getMoveClass(this.standby));
        return entry == null ? type.isHoldable(this.standby) : ((Boolean)MoreObjects.firstNonNull((Object)entry.getMove().getIsHoldable(), (Object)type.isHoldable(this.standby))).booleanValue();
    }

    public void standBlock() {
        if (!this.hasUser()) {
            return;
        }
        List toDeflect = this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(0.75), EntitySelector.f_20402_);
        for (Projectile projectile : toDeflect) {
            if (projectile.m_19749_() == this.user) continue;
            projectile.m_20256_(projectile.m_20184_().m_82490_(-0.5).m_82520_(0.0, -0.1, 0.0));
            projectile.f_19864_ = true;
        }
        JCraft.stun(this.user, 2, 2);
        this.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 3, false, false, true));
    }

    public void tryUnblock() {
        if (this.getMoveStun() < 1) {
            this.blocking = false;
        }
    }

    public void desummon() {
        this.desummon(true);
    }

    public void desummon(boolean playSound) {
        if (this.getCurrentMove() != null || this.getMoveStun() > 0) {
            return;
        }
        this.playDesummonSound = playSound;
        BlockMarkerMoves.remove(this);
        this.m_146870_();
    }

    public void idleOverride() {
    }

    @Override
    public void cancelMove() {
        this.cancelMove(false);
    }

    public void cancelMove(boolean offensiveCancel) {
        if (this.curMove != null) {
            if (offensiveCancel && !this.performedThisTick && this.curMove.shouldPerform(this.getThis(), this.getMoveStun() - 1)) {
                this.setPerformedThisTick(true);
                this.curMove.perform(this.getThis(), this.getUserOrThrow());
            }
            if (this.curMove != null) {
                this.curMove.onCancel(this.getThis());
            }
        }
        this.setCurrentMove((AbstractMove<?, ? super E>)null);
        this.setMoveStun(0);
        this.setState(this.getIdleState());
        this.setReset(true);
    }

    public boolean defaultToNear() {
        return !this.isRemote();
    }

    public boolean m_20068_() {
        if (this.isFree() && !this.isRemote()) {
            return true;
        }
        return super.m_20068_();
    }

    public boolean m_21222_() {
        if (this.user != null) {
            return this.user.m_21222_();
        }
        return super.m_21222_();
    }

    public void m_8119_() {
        boolean isRemoteAndControllable;
        Entity entity;
        if (this.user == null && (entity = this.m_20202_()) instanceof LivingEntity) {
            LivingEntity vehicle;
            this.user = vehicle = (LivingEntity)entity;
        }
        super.m_8119_();
        if (this.m_21224_()) {
            return;
        }
        boolean client = this.m_9236_().f_46443_;
        if (this.f_19797_ == 1) {
            LivingEntity livingEntity;
            this.playSummonSound();
            if (!client && (livingEntity = this.getUser()) instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_36220_((ResourceLocation)JStatRegistry.STAND_SUMMONED.get());
            }
        }
        this.prevAlpha = this.getAlphaOverride();
        int moveStun = this.getMoveStun();
        if (!(moveStun <= 0 || this.blocking && this.wantToBlock && moveStun == 1)) {
            this.setMoveStun(--moveStun);
        }
        if (this.playSummonAnim && (moveStun > 0 || this.f_19797_ > this.getStandData().getSummonData().getAnimDuration() || this.getState() == this.getBlockState())) {
            this.playSummonAnim = false;
        }
        boolean isFree = this.isFree();
        boolean isRemote = this.isRemote();
        if (!this.hasUser()) {
            if (!(client || isFree || isRemote)) {
                this.m_146870_();
            }
            return;
        }
        if (isRemote) {
            if (this.m_20159_()) {
                this.m_19877_();
            }
            if (Objects.requireNonNull(this.user).m_6084_()) {
                if (this.remoteControllable()) {
                    this.user.m_5618_(this.user.m_6080_());
                    this.m_5616_(this.user.m_6080_());
                    this.m_19915_(this.user.m_146908_(), this.user.m_146909_());
                }
            } else {
                this.m_146870_();
            }
        } else if (!this.m_20159_() && !this.isFree()) {
            this.m_7998_((Entity)Objects.requireNonNull(this.user), true);
        }
        if (client) {
            JCraft.getClientEntityHandler().standEntityClientTick(this);
            return;
        }
        ServerPlayer userPlayer = null;
        LivingEntity livingEntity = this.user;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity;
            userPlayer = serverPlayerEntity = (ServerPlayer)livingEntity;
        }
        if (this.isSameState()) {
            this.setSameState(false);
        }
        if (JUtils.getStand(this.user) != this) {
            this.m_146870_();
        }
        this.moveMap.tickMoves(this.getThis());
        if (this.getStandGauge() < 1.0f) {
            this.user.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.DAZED.get(), 40, 2));
            this.m_5496_(SoundEvents.f_12513_, 1.0f, 0.5f);
            this.blocking = false;
            this.m_6074_();
        }
        AbstractMove<?, E> move = this.getCurrentMove();
        if (this.defaultToNear() && moveStun <= 0) {
            if (move == null) {
                if (this.queuedMove == null) {
                    this.setFree(false);
                }
            } else if (move.isCounter()) {
                ((AbstractCounterAttack)move).whiff(this.getThis(), this.user);
                moveStun = 1;
            }
        }
        boolean bl = isRemoteAndControllable = isRemote && this.remoteControllable();
        if (!isFree || isRemoteAndControllable) {
            this.m_5616_(this.user.m_6080_());
            this.m_19915_(this.user.m_146908_(), this.user.m_146909_());
        }
        if (isRemoteAndControllable) {
            this.user.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 9, true, false));
        }
        if (move != null) {
            MoveTickQueue.queueTick(this.getThis(), move, this.getMoveStun());
            MoveInputType curMoveInputType = MoveInputType.fromMoveClass(move.getMoveClass());
            if (this.canHoldMove(curMoveInputType) && this.getHoldingType() != curMoveInputType) {
                this.setHoldingType(curMoveInputType);
            }
            if (moveStun >= 0 && !this.blocking) {
                float attackDist = move.getMoveDistance();
                if (!move.isCharge()) {
                    if (!isRemote) {
                        this.user.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 5, 4, true, false));
                    }
                    this.setAttackRotationOffset();
                    this.setDistanceOffset(attackDist);
                }
            }
        }
        if (this.wantToBlock && this.canBlock()) {
            if (this.isFree() && !this.isRemote()) {
                this.setFree(false);
            }
            this.tryBlock();
        }
        if (moveStun <= 0 && !this.blocking) {
            if (this.queuedMove != null) {
                this.doQueuedMove(userPlayer);
            } else if (!this.idleOverride) {
                if (this.curMove != null) {
                    this.setCurrentMove((AbstractMove<?, ? super E>)null);
                }
                this.setStandGauge(Mth.m_14036_((float)(this.getStandGauge() + 0.5f), (float)0.0f, (float)this.maxStandGauge));
                if (this.getRawState() != 0 || this.isReset()) {
                    this.setRawState(0);
                    this.setReset(false);
                    this.setDistanceOffset(this.getStandData().getIdleDistance());
                    this.setRotationOffset(this.getStandData().getIdleRotation());
                }
            } else {
                this.idleOverride();
            }
        } else if (this.blocking) {
            if (this.wantToBlock) {
                if (this.curMove != null) {
                    this.setCurrentMove((AbstractMove<?, ? super E>)null);
                }
                if (moveStun < 1) {
                    this.setMoveStun(1);
                }
                this.setDistanceOffset(this.getStandData().getBlockDistance());
                this.setRotationOffset(90.0f);
                this.standBlock();
                this.setStateNoReset(this.getBlockState());
            } else {
                this.tryUnblock();
            }
        }
        --this.tsTime;
        if (this.getCurrentMove() != this.prevMove && this.getCurrentMove() != null) {
            this.prevMove = this.getCurrentMove();
        }
    }

    public boolean canBlock() {
        return !this.blocking && (this.user == null || !DashData.isDashing(this.user)) && this.canAttack();
    }

    protected void doQueuedMove(@Nullable ServerPlayer userPlayer) {
        if (this.queuedMove == MoveInputType.STAND_SUMMON) {
            this.setCurrentMove((AbstractMove<?, ? super E>)null);
            this.desummon();
        } else {
            if (userPlayer != null && this.canHoldMove(this.queuedMove)) {
                this.setHolding(PlayerInputPacket.getInputStateManager((ServerPlayer)userPlayer).heldInputs.containsKey((Object)this.queuedMove));
                if (this.isHolding()) {
                    this.setHoldingType(this.queuedMove);
                }
            }
            this.initMove(this.queuedMove.getMoveClass(this.standby));
        }
        this.queuedMove = null;
    }

    public void tryBlock() {
        this.blocking = true;
    }

    private void setAttackRotationOffset() {
        float f;
        AbstractMove<?, E> abstractMove = this.getCurrentMove();
        if (abstractMove instanceof AttackRotationOffsetOverride) {
            AttackRotationOffsetOverride override = (AttackRotationOffsetOverride)((Object)abstractMove);
            f = override.getAttackRotationOffset((StandEntity<?, ?>)this.getThis());
        } else {
            f = 90.0f;
        }
        float rotation = f;
        this.setRotationOffset(rotation);
    }

    protected boolean shouldNotPlaySummonSound() {
        return this.user instanceof ArmorStand || !this.playSummonSound;
    }

    protected void playSummonSound() {
        if (this.shouldNotPlaySummonSound()) {
            return;
        }
        SummonData summonData = this.getStandData().getSummonData();
        SoundEvent summonSound = summonData.getSound();
        if (summonSound != null) {
            this.m_5496_(summonSound, 1.0f, 1.0f);
        }
        if (summonSound == null || summonData.isPlayGenericSound()) {
            this.m_5496_((SoundEvent)JSoundRegistry.STAND_SUMMON.get(), 1.0f, 1.0f);
        }
    }

    public void m_8127_() {
        if (this.f_19797_ == 0 && this.m_146911_() == null) {
            return;
        }
        if (this.m_20202_() == null) {
            return;
        }
        super.m_8127_();
        if (this.isRemote() || this.m_9236_().f_46443_) {
            return;
        }
        if (this.playDesummonSound) {
            this.m_5496_((SoundEvent)JSoundRegistry.STAND_DESUMMON.get(), 1.0f, 1.0f);
        }
        this.m_146870_();
    }

    public void m_7378_(@NonNull CompoundTag nbt) {
        LivingEntity livingEntity;
        CommonStandComponent standComp;
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        super.m_7378_(nbt);
        this.setSkin(nbt.m_128451_("Skin"));
        Entity entity = this.m_20202_();
        if (entity instanceof LivingEntity && (standComp = JComponentPlatformUtils.getStandComponent(livingEntity = (LivingEntity)entity)).getType() == this.standType) {
            standComp.setStand(this);
        }
    }

    public void m_7380_(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        super.m_7380_(nbt);
        nbt.m_128405_("Skin", this.getSkin());
    }

    public boolean m_6469_(@NonNull DamageSource source, float amount) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (this.user == null || source.m_7639_() == this.user || this.user.m_6673_(source) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (this.blocking && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268739_))) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268565_)) {
            amount /= 2.0f;
        }
        if (this.getStandGauge() <= 0.0f || source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) {
            return super.m_6469_(source, amount);
        }
        return this.user.m_6469_(source, amount);
    }

    @Nullable
    public <T extends AbstractMove<T, ?>> T getMove(Class<T> clazz) {
        for (AbstractMove<?, E> move : this.getMoveMap().asMovesList()) {
            if (!move.getClass().isAssignableFrom(clazz)) continue;
            return (T)move;
        }
        return null;
    }

    @Override
    public boolean isHolding() {
        return this.holding;
    }

    @Override
    public void setHolding(boolean holding) {
        this.holding = holding;
    }

    @Override
    public MoveInputType getHoldingType() {
        return this.holdingType;
    }

    @Override
    public void setHoldingType(MoveInputType holdingType) {
        this.holdingType = holdingType;
    }

    @Override
    public void setPerformedThisTick(boolean b) {
        this.performedThisTick = b;
    }

    @Override
    public boolean performedThisTick() {
        return this.performedThisTick;
    }

    @Override
    @NonNull
    public abstract E getThis();

    void randomlyDesireStandOff(int aiLevel, float baseChance, float subtraction, int maxAILevel, AttackerBrainInfo info, CombatEntityContext attackerCtx, AbstractMove<?, ?> selectedAttack) {
        if (info.getDesiredStandOffTime() > 0) {
            if (this.f_19796_.m_188499_()) {
                this.queueMove(null);
            }
            return;
        }
        float chanceToDesireStandOff = baseChance;
        if (aiLevel < maxAILevel) {
            chanceToDesireStandOff -= (float)(maxAILevel - aiLevel) * subtraction;
        }
        if (attackerCtx.spec() != null && (selectedAttack == null || this.f_19796_.m_188501_() <= chanceToDesireStandOff)) {
            int maxStandOffDuration;
            int attackDuration = selectedAttack == null ? 0 : selectedAttack.getDuration();
            int n = maxStandOffDuration = aiLevel < 15 ? 20 : 10;
            if (this.f_19796_.m_188501_() <= 0.1f) {
                maxStandOffDuration *= 4;
            }
            info.setDesiredStandOffTime(attackDuration + this.f_19796_.m_188503_(maxStandOffDuration));
        }
    }

    @Override
    public void executePlan(int aiLevel, AttackerBrainInfo info, CombatInstantContext combatCtx) {
        PathfinderMob pathfinderMob;
        CombatEntityContext attackerCtx = combatCtx.getAttackerCtx();
        CombatEntityContext targetCtx = combatCtx.getTargetCtx();
        Mob mob = (Mob)attackerCtx.entity();
        PathfinderMob pathfinder = mob instanceof PathfinderMob ? (pathfinderMob = (PathfinderMob)mob) : null;
        LivingEntity target = targetCtx.entity();
        LookControl lookControl = mob.m_21563_();
        JumpControl jumpControl = mob.m_21569_();
        boolean wantToBlock = this.doAutoBlocking(mob, info.getAiLevel(), info.getReactionTime(), targetCtx, combatCtx.getDistanceBetween());
        AttackerBrainInfo.State state = info.getState();
        switch (state) {
            case IDLE: {
                break;
            }
            case APPROACH: {
                PathNavigation navigation = mob.m_21573_();
                navigation.m_5624_((Entity)target, 1.0);
                lookControl.m_148051_((Entity)target);
                if (aiLevel < 3 || !(this.f_19796_.m_188501_() > 0.2f)) break;
                DashData.tryDash(this.f_19796_.m_188499_() ? -1 : 1, this.f_19796_.m_188499_() ? -1 : 1, (LivingEntity)(this.isRemote() ? this : this.user));
                if (!this.f_19796_.m_188499_()) break;
                jumpControl.m_24901_();
                break;
            }
            case PRESSURE: 
            case COMBOING: {
                PathNavigation navigation = mob.m_21573_();
                Path path = navigation.m_6570_((Entity)target, 2);
                if (path != null) {
                    navigation.m_26536_(path, 1.0);
                }
                lookControl.m_148051_((Entity)target);
                if (this.isFree() && !this.isRemote() || info.desiresNoAttack()) break;
                AbstractMove selectedAttack = this.doMoveSelection(info, mob, target, mob.m_21569_(), targetCtx.stand(), targetCtx.standAttack() != null ? targetCtx.standAttack() : targetCtx.specAttack(), combatCtx.getDistanceBetween(), targetCtx.moveStun(), targetCtx.stun() != null ? targetCtx.stun().m_19557_() : 0);
                this.randomlyDesireStandOff(aiLevel, 0.2f, 0.009f, 15, info, attackerCtx, selectedAttack);
                if (aiLevel < 3 || !(this.f_19796_.m_188501_() > 0.1f)) break;
                DashData.tryDash(1, this.f_19796_.m_188499_() ? -1 : 1, (LivingEntity)(this.isRemote() ? this : this.user));
                break;
            }
            case DISENGAGE: 
            case KEEPAWAY: {
                Vec3 away;
                if (pathfinder == null) break;
                if (info.getAwayPos() == null || pathfinder.m_20238_(info.getAwayPos()) < 3.0) {
                    info.setAwayPos(DefaultRandomPos.m_148407_((PathfinderMob)pathfinder, (int)(state == AttackerBrainInfo.State.DISENGAGE ? 16 : 8), (int)7, (Vec3)target.m_20182_()));
                }
                if ((away = info.getAwayPos()) != null) {
                    mob.m_21573_().m_26519_(away.f_82479_, away.f_82480_, away.f_82481_, 1.0);
                }
                lookControl.m_148051_((Entity)target);
                if (this.isFree() && !this.isRemote() || info.desiresNoAttack()) break;
                AbstractMove selectedAttack = this.doMoveSelection(info, mob, target, mob.m_21569_(), targetCtx.stand(), targetCtx.standAttack() != null ? targetCtx.standAttack() : targetCtx.specAttack(), combatCtx.getDistanceBetween(), targetCtx.moveStun(), targetCtx.stun() != null ? targetCtx.stun().m_19557_() : 0);
                this.randomlyDesireStandOff(aiLevel, 0.05f, 0.003f, 15, info, attackerCtx, selectedAttack);
                if (aiLevel < 3 || !(this.f_19796_.m_188501_() > 0.1f)) break;
                DashData.tryDash(1, this.f_19796_.m_188499_() ? -1 : 1, (LivingEntity)(this.isRemote() ? this : this.user));
                break;
            }
            case DEFENSE: {
                lookControl.m_148051_((Entity)target);
                if (aiLevel <= 3) break;
                float chanceToPushblock = 0.03f;
                if (aiLevel >= 10) {
                    chanceToPushblock += 0.01f * (float)aiLevel / 10.0f;
                }
                float chanceToStrikeBack = 0.1f;
                if (!this.blocking) break;
                if (this.getMoveStun() > 1) {
                    if (!(this.f_19796_.m_188501_() <= chanceToPushblock)) break;
                    JCraft.tryPushBlock((ServerLevel)this.m_9236_(), this.user, this);
                    break;
                }
                if (this.f_19796_.m_188501_() <= chanceToStrikeBack && targetCtx.noWindupsPassed()) {
                    wantToBlock = false;
                    this.tryUnblock();
                    if (this.isFree() && !this.isRemote() || info.desiresNoAttack()) break;
                    this.doMoveSelection(info, mob, target, mob.m_21569_(), targetCtx.stand(), targetCtx.standAttack() != null ? targetCtx.standAttack() : targetCtx.specAttack(), combatCtx.getDistanceBetween(), targetCtx.moveStun(), targetCtx.stun() != null ? targetCtx.stun().m_19557_() : 0);
                    break;
                }
                if (aiLevel < 15 || !(this.getStandGauge() < this.getMaxStandGauge() / 3.0f)) break;
                info.setDesiredStandOffTime(1 + this.f_19796_.m_188503_(5));
                break;
            }
            case COMBOED: {
                boolean burstCondition;
                boolean enemyIsActing;
                if (aiLevel <= 3) {
                    return;
                }
                MobEffectInstance stun = combatCtx.getAttackerCtx().stun();
                if (stun == null) {
                    return;
                }
                wantToBlock = true;
                boolean lowHP = this.user.m_21223_() < this.user.m_21233_() / 2.0f || this.user.m_21223_() < 5.0f;
                boolean bl = enemyIsActing = targetCtx.standAttack() != null || targetCtx.specAttack() != null;
                if (aiLevel >= 15) {
                    burstCondition = lowHP && enemyIsActing || this.f_19796_.m_188501_() < 0.02f;
                } else if (aiLevel >= 10) {
                    burstCondition = lowHP || enemyIsActing || this.f_19796_.m_188501_() < 0.05f;
                } else {
                    boolean bl2 = burstCondition = this.f_19796_.m_188501_() < 0.1f;
                }
                if (!burstCondition) break;
                JCraft.comboBreak((ServerLevel)this.m_9236_(), this.user, stun);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)info.getState()));
            }
        }
        this.wantToBlock = wantToBlock;
        if (wantToBlock) {
            if (!this.blocking && this.canAttack() && !DashData.isDashing((LivingEntity)mob)) {
                this.tryBlock();
            }
        } else {
            this.tryUnblock();
        }
    }

    @Nullable
    public Mob standUserPassiveAI() {
        Mob user = (Mob)this.getUser();
        if (user == null) {
            JCraft.LOGGER.error("standUserPassiveAI() called with no Stand user for {}", (Object)this);
        } else {
            boolean bl = this.wantToBlock = user.f_19789_ >= 3.0f;
            if (user.m_21573_().m_26572_() && this.f_19796_.m_188501_() < 0.01f) {
                DashData.tryDash(1, 0, (LivingEntity)user);
            }
        }
        return user;
    }

    private boolean doAutoBlocking(Mob mob, int aiLevel, int reactionTime, CombatEntityContext enemyCtx, double distance) {
        if (this.tsTime > 0) {
            return false;
        }
        boolean wantToBlock = this.wantToBlock;
        wantToBlock = this.doCombatBlocking(mob, reactionTime, enemyCtx, distance, wantToBlock);
        wantToBlock = this.doEnvironmentalBlocking(mob, aiLevel, wantToBlock);
        return wantToBlock;
    }

    protected boolean doEnvironmentalBlocking(Mob mob, int aiLevel, boolean wantToBlock) {
        if (mob.f_19789_ > 3.0f) {
            return true;
        }
        if (aiLevel <= 3) {
            return wantToBlock;
        }
        if (aiLevel > 10 || this.f_19797_ % 2 == 0) {
            List nearbyProjectiles = this.m_9236_().m_6443_(Projectile.class, mob.m_20191_().m_82400_(3.0), EntitySelector.f_20402_);
            Vec3 pos = this.m_20182_();
            boolean anyInAir = false;
            for (Projectile projectile : nearbyProjectiles) {
                if (projectile.m_19749_() == mob) continue;
                Vec3 vec3 = new Vec3(projectile.f_19854_, projectile.f_19855_, projectile.f_19856_);
                if (!(projectile.m_20238_(pos) < vec3.m_82557_(pos))) continue;
                anyInAir = true;
                break;
            }
            if (anyInAir) {
                wantToBlock = true;
            }
        }
        return wantToBlock;
    }

    private DesiredBlocking doAttackBlocking(Mob mob, int reactionTime, CombatEntityContext enemyCtx, double distance, @Nullable AbstractMove<?, ?> move) {
        if (move == null) {
            return DesiredBlocking.PASS;
        }
        if (move instanceof AbstractSimpleAttack) {
            AbstractSimpleAttack simpleEnemyAttack = (AbstractSimpleAttack)move;
            if (enemyCtx.moveStun() <= move.getDuration() - reactionTime) {
                return DesiredBlocking.PASS;
            }
            if (simpleEnemyAttack.getBlockableType().isNonBlockableEffects()) {
                return DesiredBlocking.FORCE_DONT_BLOCK;
            }
            if ((double)move.getMoveDistance() * 1.5 + (double)simpleEnemyAttack.getHitboxSize() * 0.66 >= distance && simpleEnemyAttack.getDamage() * 2.0f < this.getStandGauge() && !simpleEnemyAttack.getBlockableType().isNonBlockable()) {
                return DesiredBlocking.BLOCK;
            }
        }
        if (move.isRanged()) {
            return DesiredBlocking.BLOCK;
        }
        return DesiredBlocking.PASS;
    }

    protected boolean doCombatBlocking(Mob mob, int reactionTime, CombatEntityContext enemyCtx, double distance, boolean wantToBlock) {
        StandEntity<?, ?> enemyStand = enemyCtx.stand();
        JSpec<?, ?> enemySpec = enemyCtx.spec();
        AbstractMove<?, ?> enemyStandAttack = enemyCtx.standAttack();
        AbstractMove<?, ?> enemySpecAttack = enemyCtx.specAttack();
        if (enemyCtx.moveStun() > 0) {
            DesiredBlocking desiredBlocking = this.doAttackBlocking(mob, reactionTime, enemyCtx, distance, enemyStandAttack);
            if (desiredBlocking.modify) {
                wantToBlock = desiredBlocking.newValue;
            }
            if (desiredBlocking.force) {
                return desiredBlocking.newValue;
            }
            desiredBlocking = this.doAttackBlocking(mob, reactionTime, enemyCtx, distance, enemySpecAttack);
            if (desiredBlocking.modify) {
                wantToBlock = desiredBlocking.newValue;
            }
            if (desiredBlocking.force) {
                return desiredBlocking.newValue;
            }
        } else {
            wantToBlock = false;
        }
        if (enemyStand == null && enemySpec == null) {
            CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns((LivingEntity)mob);
            wantToBlock = cooldowns.getCooldown(CooldownType.DASH) > 0 ? distance > 2.0 && distance < 5.0 : false;
        }
        return wantToBlock;
    }

    public void m_7334_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
    }

    public boolean m_7337_(@NonNull Entity other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return false;
    }

    public boolean m_147207_(@NotNull MobEffectInstance effect, @Nullable Entity source) {
        if (this.m_9236_().f_46443_ || this.user == null) {
            return false;
        }
        return this.user.m_147207_(effect, source);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_7639_() == this) {
            return true;
        }
        return !this.isRemote() && !damageSource.m_276093_(DamageTypes.f_268724_) && !damageSource.m_276093_(DamageTypes.f_286979_);
    }

    public Vector3f getAuraColor() {
        return this.auraColors[this.getSkin()];
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this.getThis(), "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<E> state) {
        AnimationController controller = state.getController();
        String summonAnimation = this.getSummonAnimation();
        if (this.playSummonAnim && summonAnimation != null) {
            return state.setAndContinue(RawAnimation.begin().thenPlay(summonAnimation));
        }
        if (this.isSameState()) {
            controller.forceAnimationReset();
        }
        S superState = this.getState();
        ((StandAnimationState)superState).playAnimation(this.getThis(), state);
        ((StandAnimationState)superState).configureController(this.getThis(), controller);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_20067_() {
        return super.m_20067_() || this.user != null && this.user.m_20067_();
    }

    @Override
    public boolean reflectsDamage() {
        return false;
    }

    @Override
    public boolean handleDamage(Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation, MoveUsage moveUsage, boolean canBackstab, boolean unblockable) {
        if (!this.hasUser()) {
            return false;
        }
        boolean hit = true;
        if (this.isRemote()) {
            if (this.blocking) {
                boolean backstabbed = false;
                if (attacker != null) {
                    double delta = Math.abs((this.f_20885_ + 90.0f) % 360.0f - (attacker.m_6080_() + 90.0f) % 360.0f);
                    if (canBackstab && (360.0 - delta % 360.0 < 45.0 || delta % 360.0 < 45.0) && this.m_20238_(attacker.m_20182_()) >= 1.5625) {
                        JCraft.createParticle((ServerLevel)attacker.m_9236_(), this.m_20185_(), attacker.m_20188_(), this.m_20189_(), JParticleType.BACK_STAB);
                        this.m_5496_((SoundEvent)JSoundRegistry.BACKSTAB.get(), 1.0f, 1.0f);
                        this.blocking = false;
                        overrideStun = true;
                        backstabbed = true;
                    }
                }
                if (!backstabbed && !unblockable) {
                    this.setMoveStun(blockstun);
                    this.setStandGauge(this.getStandGauge() - 2.0f * damage);
                    this.m_5496_((SoundEvent)JSoundRegistry.STAND_BLOCK.get(), 1.0f, 1.0f);
                    hit = false;
                    overrideStun = false;
                } else {
                    this.blocking = false;
                }
                if (!backstabbed) {
                    hit = false;
                }
            } else {
                this.setStandGauge(this.getStandGauge() - damage * 2.0f);
            }
        }
        if (hit) {
            Attacks.damageLogic(this.m_9236_(), this.user, new AttackData(kbVec, stunTicks, stunLevel, overrideStun, damage, lift, blockstun, source, attacker, hitAnimation, moveUsage, canBackstab, unblockable));
        }
        return false;
    }

    protected abstract S[] getStateValues();

    public S boxState(int rawState) {
        return (S)this.getStateValues()[rawState];
    }

    public S getIdleState() {
        return this.boxState(0);
    }

    public abstract S getBlockState();

    public boolean isIdle() {
        return this.getRawState() == 0;
    }

    public boolean m_21254_() {
        return this.getState() == this.getBlockState();
    }

    @Nullable
    protected abstract String getSummonAnimation();

    public void freshKill(@Nullable LivingEntity entity) {
    }

    @Override
    @NonNull
    public MoveMap<E, S> getMoveMap() {
        return this.moveMap;
    }

    public void setTsTime(int tsTime) {
        this.tsTime = tsTime;
    }

    public float getPrevAlpha() {
        return this.prevAlpha;
    }

    @Override
    @Nullable
    public LivingEntity getUser() {
        return this.user;
    }

    public void setUser(@Nullable LivingEntity user) {
        this.user = user;
    }

    public boolean isStandby() {
        return this.standby;
    }

    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    public float getMaxStandGauge() {
        return this.maxStandGauge;
    }

    public MoveInputType getQueuedMove() {
        return this.queuedMove;
    }

    public void setQueuedMove(MoveInputType queuedMove) {
        this.queuedMove = queuedMove;
    }

    @Override
    public MoveUsage getMoveUsage() {
        return this.moveUsage;
    }

    public double getRemoteForwardInput() {
        return this.remoteForwardInput;
    }

    public double getRemoteSideInput() {
        return this.remoteSideInput;
    }

    public void setRemoteJumpInput(boolean remoteJumpInput) {
        this.remoteJumpInput = remoteJumpInput;
    }

    public void setRemoteSneakInput(boolean remoteSneakInput) {
        this.remoteSneakInput = remoteSneakInput;
    }

    public void setPlaySummonSound(boolean playSummonSound) {
        this.playSummonSound = playSummonSound;
    }

    public void setPlayDesummonSound(boolean playDesummonSound) {
        this.playDesummonSound = playDesummonSound;
    }

    public StandType getStandType() {
        return this.standType;
    }

    static {
        FREE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        REMOTE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        FREEX = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        FREEY = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        FREEZ = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        USER_POSE = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }

    public static enum DesiredBlocking {
        PASS(false, false, false),
        BLOCK(true, false, true),
        DONT_BLOCK(true, false, false),
        FORCE_DONT_BLOCK(true, true, false),
        FORCE_BLOCK(true, true, true);

        public final boolean force;
        public final boolean modify;
        public final boolean newValue;

        private DesiredBlocking(boolean modify, boolean force, boolean newValue) {
            this.modify = modify;
            this.force = force;
            this.newValue = newValue;
        }
    }
}

