/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.stand;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.ExtraCodecs;

public class StandInfo {
    public static final Codec<StandInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.fieldOf("name").forGetter(StandInfo::getName), (App)ExtraCodecs.f_252442_.listOf().fieldOf("skin_names").forGetter(StandInfo::getSkinNames), (App)ExtraCodecs.f_144628_.fieldOf("pro_count").forGetter(StandInfo::getProCount), (App)ExtraCodecs.f_144628_.fieldOf("con_count").forGetter(StandInfo::getConCount), (App)ExtraCodecs.f_252442_.optionalFieldOf("free_space", (Object)Component.m_237119_()).forGetter(StandInfo::getFreeSpace)).apply((Applicative)instance, StandInfo::new));
    @NonNull
    private final Component name;
    private final AtomicReference<Object> nameKey = new AtomicReference();
    private final AtomicReference<Object> reducedNameKey = new AtomicReference();
    @NonNull
    private List<Component> skinNames;
    private int proCount;
    private int conCount;
    @NonNull
    private Component freeSpace;

    public static StandInfo of(@NonNull Component name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return StandInfo.builder().name(name).build();
    }

    public int getSkinCount() {
        return this.skinNames.size() + 1;
    }

    private static Component $default$freeSpace() {
        return Component.m_237119_();
    }

    StandInfo(@NonNull Component name, @NonNull List<Component> skinNames, int proCount, int conCount, @NonNull Component freeSpace) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (skinNames == null) {
            throw new NullPointerException("skinNames is marked non-null but is null");
        }
        if (freeSpace == null) {
            throw new NullPointerException("freeSpace is marked non-null but is null");
        }
        this.name = name;
        this.skinNames = skinNames;
        this.proCount = proCount;
        this.conCount = conCount;
        this.freeSpace = freeSpace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.name).proCount(this.proCount).conCount(this.conCount).freeSpace(this.freeSpace);
        if (this.skinNames != null) {
            builder.skinNames(this.skinNames);
        }
        return builder;
    }

    @NonNull
    public Component getName() {
        return this.name;
    }

    @NonNull
    public List<Component> getSkinNames() {
        return this.skinNames;
    }

    public int getProCount() {
        return this.proCount;
    }

    public int getConCount() {
        return this.conCount;
    }

    @NonNull
    public Component getFreeSpace() {
        return this.freeSpace;
    }

    public StandInfo withName(@NonNull Component name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new StandInfo(name, this.skinNames, this.proCount, this.conCount, this.freeSpace);
    }

    public StandInfo withSkinNames(@NonNull List<Component> skinNames) {
        if (skinNames == null) {
            throw new NullPointerException("skinNames is marked non-null but is null");
        }
        return this.skinNames == skinNames ? this : new StandInfo(this.name, skinNames, this.proCount, this.conCount, this.freeSpace);
    }

    public StandInfo withProCount(int proCount) {
        return this.proCount == proCount ? this : new StandInfo(this.name, this.skinNames, proCount, this.conCount, this.freeSpace);
    }

    public StandInfo withConCount(int conCount) {
        return this.conCount == conCount ? this : new StandInfo(this.name, this.skinNames, this.proCount, conCount, this.freeSpace);
    }

    public StandInfo withFreeSpace(@NonNull Component freeSpace) {
        if (freeSpace == null) {
            throw new NullPointerException("freeSpace is marked non-null but is null");
        }
        return this.freeSpace == freeSpace ? this : new StandInfo(this.name, this.skinNames, this.proCount, this.conCount, freeSpace);
    }

    public String toString() {
        return "StandInfo(name=" + String.valueOf(this.getName()) + ", nameKey=" + this.getNameKey() + ", reducedNameKey=" + this.getReducedNameKey() + ", skinNames=" + String.valueOf(this.getSkinNames()) + ", proCount=" + this.getProCount() + ", conCount=" + this.getConCount() + ", freeSpace=" + String.valueOf(this.getFreeSpace()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandInfo)) {
            return false;
        }
        StandInfo other = (StandInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProCount() != other.getProCount()) {
            return false;
        }
        if (this.getConCount() != other.getConCount()) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nameKey = this.getNameKey();
        String other$nameKey = other.getNameKey();
        if (this$nameKey == null ? other$nameKey != null : !this$nameKey.equals(other$nameKey)) {
            return false;
        }
        String this$reducedNameKey = this.getReducedNameKey();
        String other$reducedNameKey = other.getReducedNameKey();
        if (this$reducedNameKey == null ? other$reducedNameKey != null : !this$reducedNameKey.equals(other$reducedNameKey)) {
            return false;
        }
        List<Component> this$skinNames = this.getSkinNames();
        List<Component> other$skinNames = other.getSkinNames();
        if (this$skinNames == null ? other$skinNames != null : !((Object)this$skinNames).equals(other$skinNames)) {
            return false;
        }
        Component this$freeSpace = this.getFreeSpace();
        Component other$freeSpace = other.getFreeSpace();
        return !(this$freeSpace == null ? other$freeSpace != null : !this$freeSpace.equals(other$freeSpace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProCount();
        result = result * 59 + this.getConCount();
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nameKey = this.getNameKey();
        result = result * 59 + ($nameKey == null ? 43 : $nameKey.hashCode());
        String $reducedNameKey = this.getReducedNameKey();
        result = result * 59 + ($reducedNameKey == null ? 43 : $reducedNameKey.hashCode());
        List<Component> $skinNames = this.getSkinNames();
        result = result * 59 + ($skinNames == null ? 43 : ((Object)$skinNames).hashCode());
        Component $freeSpace = this.getFreeSpace();
        result = result * 59 + ($freeSpace == null ? 43 : $freeSpace.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameKey() {
        Object $value = this.nameKey.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.nameKey;
            synchronized (atomicReference) {
                $value = this.nameKey.get();
                if ($value == null) {
                    String string;
                    ComponentContents componentContents = this.name.m_214077_();
                    if (componentContents instanceof TranslatableContents) {
                        TranslatableContents tc = (TranslatableContents)componentContents;
                        string = tc.m_237508_();
                    } else {
                        string = "entity.jcraft.unknown";
                    }
                    String actualValue = string;
                    $value = actualValue == null ? this.nameKey : actualValue;
                    this.nameKey.set($value);
                }
            }
        }
        return (String)($value == this.nameKey ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReducedNameKey() {
        Object $value = this.reducedNameKey.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.reducedNameKey;
            synchronized (atomicReference) {
                $value = this.reducedNameKey.get();
                if ($value == null) {
                    String actualValue = this.getNameKey().split("\\.", 3)[2];
                    $value = actualValue == null ? this.reducedNameKey : actualValue;
                    this.reducedNameKey.set($value);
                }
            }
        }
        return (String)($value == this.reducedNameKey ? null : $value);
    }

    public static class Builder {
        private Component name;
        private ImmutableList.Builder<Component> skinNames;
        private int proCount;
        private int conCount;
        private boolean freeSpace$set;
        private Component freeSpace$value;

        Builder() {
        }

        public Builder name(@NonNull Component name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder skinName(Component skinName) {
            if (this.skinNames == null) {
                this.skinNames = ImmutableList.builder();
            }
            this.skinNames.add((Object)skinName);
            return this;
        }

        public Builder skinNames(Iterable<? extends Component> skinNames) {
            if (skinNames == null) {
                throw new NullPointerException("skinNames cannot be null");
            }
            if (this.skinNames == null) {
                this.skinNames = ImmutableList.builder();
            }
            this.skinNames.addAll(skinNames);
            return this;
        }

        public Builder clearSkinNames() {
            this.skinNames = null;
            return this;
        }

        public Builder proCount(int proCount) {
            this.proCount = proCount;
            return this;
        }

        public Builder conCount(int conCount) {
            this.conCount = conCount;
            return this;
        }

        public Builder freeSpace(@NonNull Component freeSpace) {
            if (freeSpace == null) {
                throw new NullPointerException("freeSpace is marked non-null but is null");
            }
            this.freeSpace$value = freeSpace;
            this.freeSpace$set = true;
            return this;
        }

        public StandInfo build() {
            ImmutableList skinNames = this.skinNames == null ? ImmutableList.of() : this.skinNames.build();
            Component freeSpace$value = this.freeSpace$value;
            if (!this.freeSpace$set) {
                freeSpace$value = StandInfo.$default$freeSpace();
            }
            return new StandInfo(this.name, (List<Component>)skinNames, this.proCount, this.conCount, freeSpace$value);
        }

        public String toString() {
            return "StandInfo.Builder(name=" + String.valueOf(this.name) + ", skinNames=" + String.valueOf(this.skinNames) + ", proCount=" + this.proCount + ", conCount=" + this.conCount + ", freeSpace$value=" + String.valueOf(this.freeSpace$value) + ")";
        }
    }
}

