/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.stand;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.data.AttackerDataLoader;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;

public final class StandTypeUtil {
    public static boolean isNone(StandType type) {
        return type == null || type == JStandTypeRegistry.NONE.get();
    }

    public static Stream<StandType> streamAll() {
        return StreamSupport.stream(JRegistries.STAND_TYPE_REGISTRY.spliterator(), false);
    }

    public static Stream<StandType> streamAllObtainable() {
        return StandTypeUtil.streamAll().filter(type -> type.getData().isObtainable());
    }

    public static Stream<StandType> streamAllRegular() {
        return StandTypeUtil.streamAllObtainable().filter(type -> !type.getData().isEvolution());
    }

    public static Stream<StandType> streamAllEvolutions() {
        return StandTypeUtil.streamAllObtainable().filter(type -> type.getData().isEvolution());
    }

    public static Stream<EntityType<? extends StandEntity<?, ?>>> streamEntityTypes() {
        return StandTypeUtil.streamAll().map(StandType::getEntityType);
    }

    public static StandType getRandomRegular(RandomSource random) {
        List<StandType> types = StandTypeUtil.streamAllObtainable().filter(type -> !type.getData().isEvolution()).toList();
        return types.get(random.m_188503_(types.size()));
    }

    public static StandType getRandom(RandomSource random) {
        List<StandType> types = StandTypeUtil.streamAllObtainable().toList();
        return types.get(random.m_188503_(types.size()));
    }

    @Nullable
    public static StandType readFromNBT(CompoundTag nbt, String key) {
        if (nbt.m_128425_(key, 3)) {
            int ordinal = nbt.m_128451_(key);
            return Optional.ofNullable((RegistrySupplier)JStandTypeRegistry.LEGACY_ORDINALS.get(ordinal)).map(Supplier::get).orElse(null);
        }
        if (nbt.m_128425_(key, 8)) {
            String id = nbt.m_128461_(key);
            if (id.isEmpty()) {
                return null;
            }
            return (StandType)JRegistries.STAND_TYPE_REGISTRY.get(new ResourceLocation(id));
        }
        return null;
    }

    public static StandData getStandData(ResourceLocation id) {
        return AttackerDataLoader.getStandData(id);
    }

    private StandTypeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

