/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.api.stand;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import lombok.NonNull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class SummonData {
    public static final SummonData EMPTY = SummonData.of(() -> null);
    public static final Codec<SummonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SoundEvent.f_263130_.xmap(h -> () -> ((Holder)h).m_203334_(), s -> BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)s.get()))).fieldOf("sound").forGetter(d -> d.sound), (App)Codec.BOOL.optionalFieldOf("play_generic_sound", (Object)false).forGetter(SummonData::isPlayGenericSound), (App)Codec.INT.optionalFieldOf("anim_duration", (Object)19).forGetter(SummonData::getAnimDuration)).apply((Applicative)instance, SummonData::new));
    private @NonNull Supplier<@Nullable SoundEvent> sound;
    private boolean playGenericSound;
    private int animDuration;

    public static SummonData of(Supplier<@Nullable SoundEvent> sound) {
        return SummonData.builder().sound(sound).build();
    }

    @Nullable
    public SoundEvent getSound() {
        return this.sound.get();
    }

    private static int $default$animDuration() {
        return 19;
    }

    SummonData(@NonNull Supplier<@Nullable SoundEvent> sound, boolean playGenericSound, int animDuration) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        this.sound = sound;
        this.playGenericSound = playGenericSound;
        this.animDuration = animDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().sound(this.sound).playGenericSound(this.playGenericSound).animDuration(this.animDuration);
    }

    public boolean isPlayGenericSound() {
        return this.playGenericSound;
    }

    public int getAnimDuration() {
        return this.animDuration;
    }

    public SummonData withSound(@NonNull Supplier<@Nullable SoundEvent> sound) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        return this.sound == sound ? this : new SummonData(sound, this.playGenericSound, this.animDuration);
    }

    public SummonData withPlayGenericSound(boolean playGenericSound) {
        return this.playGenericSound == playGenericSound ? this : new SummonData(this.sound, playGenericSound, this.animDuration);
    }

    public SummonData withAnimDuration(int animDuration) {
        return this.animDuration == animDuration ? this : new SummonData(this.sound, this.playGenericSound, animDuration);
    }

    public String toString() {
        return "SummonData(sound=" + String.valueOf(this.getSound()) + ", playGenericSound=" + this.isPlayGenericSound() + ", animDuration=" + this.getAnimDuration() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummonData)) {
            return false;
        }
        SummonData other = (SummonData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPlayGenericSound() != other.isPlayGenericSound()) {
            return false;
        }
        if (this.getAnimDuration() != other.getAnimDuration()) {
            return false;
        }
        SoundEvent this$sound = this.getSound();
        SoundEvent other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SummonData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPlayGenericSound() ? 79 : 97);
        result = result * 59 + this.getAnimDuration();
        SoundEvent $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public static class Builder {
        private Supplier<@Nullable SoundEvent> sound;
        private boolean playGenericSound;
        private boolean animDuration$set;
        private int animDuration$value;

        Builder() {
        }

        public Builder sound(@NonNull Supplier<@Nullable SoundEvent> sound) {
            if (sound == null) {
                throw new NullPointerException("sound is marked non-null but is null");
            }
            this.sound = sound;
            return this;
        }

        public Builder playGenericSound(boolean playGenericSound) {
            this.playGenericSound = playGenericSound;
            return this;
        }

        public Builder animDuration(int animDuration) {
            this.animDuration$value = animDuration;
            this.animDuration$set = true;
            return this;
        }

        public SummonData build() {
            int animDuration$value = this.animDuration$value;
            if (!this.animDuration$set) {
                animDuration$value = SummonData.$default$animDuration();
            }
            return new SummonData(this.sound, this.playGenericSound, animDuration$value);
        }

        public String toString() {
            return "SummonData.Builder(sound=" + String.valueOf(this.sound) + ", playGenericSound=" + this.playGenericSound + ", animDuration$value=" + this.animDuration$value + ")";
        }
    }
}

